/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.netty;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.DeploymentHelper;
import com.blixx.agent.PolicyRepository;
import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import com.blixx.shared.os.SystemUtils;
import com.boom.netty.common.MessageSender;
import com.boom.netty.service.deploy.msg.DeployRequestMsg;
import com.boom.netty.service.deploy.msg.DeployResponseMsg;
import com.boom.netty.service.deploy.msg.UndeployRequestMsg;
import com.boom.netty.service.deploy.msg.UndeployResponseMsg;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;

public class DeploymentCmdHandler {
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private DeploymentHelper deploymentHelper;
    private MessageSender messageSender;
    private PolicyRepository policyRepository;
    private AgentEngine agentEngine = null;
    private Path deployFolder;
    private Path policiesFolder;

    public DeploymentCmdHandler(MessageSender messageSender, DeploymentHelper deploymentHelper, PolicyRepository policyRepository) {
        this.deploymentHelper = deploymentHelper;
        this.messageSender = messageSender;
        this.policyRepository = policyRepository;
        this.deployFolder = Paths.get("deployment", new String[0]);
        this.policiesFolder = Paths.get("policies", new String[0]);
        this.cleanupDeploymentFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDeploymentFolder() {
        if (!Files.exists(this.deployFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(this.deployFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                RTLogger.print(1, "Error creating deployment folder", e);
            }
        }
        this.waitUntilDeploymentIsPossible();
        try (Stream<Path> list = Files.list(this.deployFolder);){
            list.forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    RTLogger.print(5, "Could not remove file " + path.toAbsolutePath().toString(), e);
                }
            });
        }
        catch (IOException e) {
            RTLogger.print(5, "Could not list files from dir " + this.deployFolder.toAbsolutePath().toString(), e);
        }
        finally {
            this.deploymentHelper.finishDeployment();
        }
    }

    @MessageHandlerMethod
    public void handle(DeployRequestMsg msg) {
        this.executor.submit(() -> this.handleDeploymentRequest(msg));
    }

    @MessageHandlerMethod
    public void handle(UndeployRequestMsg msg) {
        this.executor.submit(() -> this.handleUndeploymentRequest(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeploymentRequest(DeployRequestMsg msg) {
        ArrayList<Path> filesToRemove = new ArrayList<Path>();
        try {
            String msgPolicy;
            Object monPolicy;
            this.waitUntilDeploymentIsPossible();
            if (msg.getPkgNameToFile() != null) {
                boolean reloadClasses = false;
                for (Map.Entry<String, String> entry : msg.getPkgNameToFile().entrySet()) {
                    Path file = this.deployFolder.resolve(this.getFileNameOnly(entry.getValue()));
                    filesToRemove.add(file);
                    reloadClasses = this.deploymentHelper.deployBinaries(file.toFile(), entry.getKey()) || reloadClasses;
                }
                if (reloadClasses) {
                    this.agentEngine.loadJars();
                    this.policyRepository.reRegisterJavaMonitors();
                }
            }
            if ((monPolicy = msg.getMonPolicy()) != null) {
                Path file = this.deployFolder.resolve(this.getFileNameOnly((String)monPolicy));
                filesToRemove.add(file);
                this.deployPolicy(file);
            }
            if ((msgPolicy = msg.getMsgPolicy()) != null) {
                Path file = this.deployFolder.resolve(this.getFileNameOnly(msgPolicy));
                filesToRemove.add(file);
                this.deployPolicy(file);
            }
            if (msg.getDeployAgentFile() != null) {
                this.updateAgent(this.getFileNameOnly(msg.getDeployAgentFile()));
            }
            DeployResponseMsg responseMsg = new DeployResponseMsg(msg.getSource(), msg.getOperationId());
            responseMsg.setCode(0);
            this.messageSender.sendMessage(responseMsg);
        }
        catch (Throwable e) {
            DeployResponseMsg responseMsg = new DeployResponseMsg(msg.getSource(), msg.getOperationId());
            responseMsg.setCode(1);
            responseMsg.setMessage(e.getMessage());
            this.messageSender.sendMessage(responseMsg);
        }
        finally {
            for (Path path : filesToRemove) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    RTLogger.print(5, "Could not remove file " + path.toAbsolutePath().toString(), e);
                }
            }
            this.deploymentHelper.finishDeployment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUndeploymentRequest(UndeployRequestMsg msg) {
        try {
            this.waitUntilDeploymentIsPossible();
            if (msg.getMonPolicies() != null) {
                msg.getMonPolicies().stream().filter(f -> f != null).forEach(this.policyRepository::removePolicy);
            }
            if (msg.getMsgPolicies() != null) {
                msg.getMsgPolicies().stream().filter(f -> f != null).forEach(this.policyRepository::removeMsgPolicy);
            }
            if (msg.getPkgNameToFile() != null) {
                for (Map.Entry<String, String> entry : msg.getPkgNameToFile().entrySet()) {
                    Path file = this.deployFolder.resolve(this.getFileNameOnly(entry.getValue()));
                    this.deploymentHelper.undeployBinary(file.toFile(), entry.getKey());
                    try {
                        Files.deleteIfExists(file);
                    }
                    catch (IOException e) {
                        RTLogger.print(5, "Could not remove file " + file.toAbsolutePath().toString(), e);
                    }
                }
            }
            UndeployResponseMsg responseMsg = new UndeployResponseMsg(msg.getSource(), msg.getOperationId());
            responseMsg.setCode(0);
            this.messageSender.sendMessage(responseMsg);
        }
        catch (Throwable e) {
            UndeployResponseMsg responseMsg = new UndeployResponseMsg(msg.getSource(), msg.getOperationId());
            responseMsg.setCode(1);
            responseMsg.setMessage(e.getMessage());
            this.messageSender.sendMessage(responseMsg);
        }
        finally {
            this.deploymentHelper.finishDeployment();
        }
    }

    private void deployPolicy(Path policyFile) {
        String fileName = "";
        try {
            fileName = policyFile.getFileName().toString();
            Path targetPolicyFile = this.policiesFolder.resolve(fileName);
            Files.move(policyFile, targetPolicyFile, StandardCopyOption.REPLACE_EXISTING);
            this.policyRepository.updatePolicy(targetPolicyFile.toFile());
        }
        catch (Throwable e) {
            this.agentEngine.sendInternalMessageDupl("Deployment of policy " + fileName + " failed. " + e.getMessage(), 4, "DEPLOY", fileName);
        }
    }

    private String getFileNameOnly(String fileName) {
        int lastIndexSlash = fileName.lastIndexOf(47);
        int lastIndexBackslash = fileName.lastIndexOf(92);
        int lastIndex = 0;
        if (lastIndexSlash >= 0 || lastIndexBackslash >= 0) {
            lastIndex = Math.max(lastIndexSlash, lastIndexBackslash);
        }
        return fileName.substring(lastIndex);
    }

    private void waitUntilDeploymentIsPossible() {
        long start = System.currentTimeMillis();
        while (!this.deploymentHelper.startDeployment()) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {}
        }
        long deltaWait = System.currentTimeMillis() - start;
        if (deltaWait > 100L) {
            RTLogger.print(5, "- wait time deployment processing (ms):" + deltaWait);
        }
    }

    private void updateAgent(String fileName) {
        String jarFileName = BM.PRODUCT_lowercase + "_agent.jar.tmp";
        Path agentFile = this.deployFolder.resolve(fileName);
        Path targetFile = Paths.get(jarFileName, new String[0]);
        try {
            Files.move(agentFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
            this.agentEngine.restart();
            if (SystemUtils.OS == 1) {
                RTLogger.print(1, "(3)Agent exit.");
                System.exit(0);
            }
        }
        catch (Throwable t) {
            try {
                try {
                    Files.deleteIfExists(agentFile);
                }
                catch (IOException e) {
                    RTLogger.print(3, "Could not remove file " + agentFile, e);
                }
                try {
                    Files.deleteIfExists(targetFile);
                }
                catch (IOException e) {
                    RTLogger.print(3, "Could not remove file " + targetFile, e);
                }
                RTLogger.print(2, "Ignored upgrade Agent. The jar file was not transferred correctly.");
                this.agentEngine.sendInternalMessageDupl("Ignored upgrade Agent. The jar file was not transferred correctly.", 2, "RESTART", "AGENT");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

