/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.netty;

import com.blixx.log.RTLogger;
import com.boom.netty.common.MessageSender;
import com.boom.netty.service.basic.msg.ReadyToReceiveDataMsg;
import com.boom.netty.service.basic.msg.UnRegisteredMessageType;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import com.boom.netty.ws.mhf.msg.RawMessage;
import java.util.function.Consumer;

public class NettyBasicMessageHandler {
    private final MessageSender sender;
    private final Consumer<ReadyToReceiveDataMsg> consumer;

    public NettyBasicMessageHandler(MessageSender sender, Consumer<ReadyToReceiveDataMsg> consumer) {
        this.sender = sender;
        this.consumer = consumer;
    }

    @MessageHandlerMethod
    public void handle(RawMessage msg) {
        RTLogger.print(1, "Unregistered message received : " + msg.getOriginalMsgCode());
        UnRegisteredMessageType res = new UnRegisteredMessageType(msg.getSource(), msg.getOperationId());
        res.setOriginalMessageId(msg.getOriginalMsgCode());
        this.sender.sendMessage(res);
    }

    @MessageHandlerMethod
    public void handle(ReadyToReceiveDataMsg msg) {
        this.consumer.accept(msg);
    }
}

