/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.netty;

import com.blixx.agent.AgentActionExecutor;
import com.blixx.log.RTLogger;
import com.boom.netty.common.MessageSender;
import com.boom.netty.service.cmds.AbstractAgentAction;
import com.boom.netty.service.cmds.AgentActionResponse;
import com.boom.netty.service.cmds.ExecAgentAction;
import com.boom.netty.service.cmds.InternalAgentAction;
import com.boom.netty.service.cmds.JavaAgentAction;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import java.util.Iterator;

public class RemoteCmdHandler {
    private MessageSender messageSender;

    public RemoteCmdHandler(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    @MessageHandlerMethod
    public void handle(InternalAgentAction msg) {
        try {
            String[] array = new String[msg.getParameters() == null ? 2 : 2 + msg.getParameters().size()];
            array[1] = msg.getActionName();
            if (msg.getParameters() != null) {
                int i = 2;
                Iterator<String> iterator = msg.getParameters().iterator();
                while (iterator.hasNext()) {
                    String param;
                    array[i] = param = iterator.next();
                    ++i;
                }
            }
            AgentActionResponse response = new AgentActionExecutor().processAgentActions(msg.getSource(), msg.getOperationId(), array, msg.getTimeoutSec());
            this.messageSender.sendMessage(response);
        }
        catch (Exception e) {
            this.sendError(msg, e);
        }
    }

    @MessageHandlerMethod
    public void handle(JavaAgentAction msg) {
        try {
            AgentActionResponse response = new AgentActionExecutor().processJavaAction(msg.getSource(), msg.getOperationId(), msg.getClassName(), msg.getParameters(), msg.getTimeoutSec());
            this.messageSender.sendMessage(response);
        }
        catch (Exception e) {
            this.sendError(msg, e);
        }
    }

    @MessageHandlerMethod
    public void handle(ExecAgentAction msg) {
        try {
            String fullString = msg.getCommand();
            if (msg.getParameters() != null) {
                for (int i = 0; i < msg.getParameters().size(); ++i) {
                    int varNumber = i + 1;
                    fullString = fullString.replace("<$" + varNumber + ">", msg.getParameters().get(i));
                }
            }
            RTLogger.print(1, "RemoteAction (%s) start - %s", msg.getOperationId(), fullString);
            AgentActionResponse response = new AgentActionExecutor().processExecAction(msg.getSource(), msg.getOperationId(), fullString, msg.getTimeoutSec());
            RTLogger.print(1, "RemoteAction (%s) finish - %s, %s", msg.getOperationId(), response.getResultCode(), response.getOutput());
            this.messageSender.sendMessage(response);
        }
        catch (Exception e) {
            RTLogger.print(1, "RemoteAction (%s) Error", msg.getOperationId(), e);
            this.sendError(msg, e);
        }
    }

    private void sendError(AbstractAgentAction msg, Exception e) {
        AgentActionResponse response = new AgentActionResponse(msg.getSource(), msg.getOperationId()).setResultCode(1).setOutput("Error: " + e.getMessage());
        this.messageSender.sendMessage(response);
    }
}

