/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.netty;

import com.blixx.agent.AgentEngine;
import com.blixx.log.RTLogger;
import com.boom.netty.common.MessageSender;
import com.boom.netty.service.file.FileUtils;
import com.boom.netty.service.tl.TlcAgentFile;
import com.boom.netty.service.tl.TlcAgentFileDir;
import com.boom.netty.service.tl.msg.TlcDeleteFileRequest;
import com.boom.netty.service.tl.msg.TlcDeleteFileResponse;
import com.boom.netty.service.tl.msg.TlcGetDirectoryListRequest;
import com.boom.netty.service.tl.msg.TlcGetDirectoryListResponse;
import com.boom.netty.service.tl.msg.TlcRenameFileRequest;
import com.boom.netty.service.tl.msg.TlcRenameFileResponse;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TCmdHandler {
    private final MessageSender messageSender;

    public TCmdHandler(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    @MessageHandlerMethod
    public void handle(TlcGetDirectoryListRequest msg) {
        ArrayList<TlcAgentFile> agentFiles = new ArrayList<TlcAgentFile>();
        TlcGetDirectoryListResponse response = new TlcGetDirectoryListResponse(msg.getSource(), msg.getOperationId(), AgentEngine.getInstance().getAgentID());
        try {
            List<File> files = com.blixx.shared.utils.FileUtils.getPaths(msg.getPath(), msg.isRecursive(), msg.getRegex());
            for (File f : files) {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                if (!basicFileAttributes.isRegularFile()) continue;
                TlcAgentFile agentFile = new TlcAgentFile();
                agentFile.setFilename(f.getName());
                agentFile.setDir(f.getParentFile().getCanonicalPath());
                agentFile.setSizeInBytes(basicFileAttributes.size());
                agentFile.setLastModifiedDate(basicFileAttributes.lastModifiedTime().toMillis());
                if (msg.isIncludeCreationDate()) {
                    agentFile.setCreationDate(com.blixx.shared.utils.FileUtils.getFileCreationDate(f));
                }
                if (msg.isIncludeHash()) {
                    agentFile.setHash(FileUtils.getDigestOfFile(Paths.get(f.getAbsolutePath(), new String[0]), "SHA-256").asString());
                }
                agentFile.setReadable(f.canRead());
                agentFile.setWriteable(f.canWrite());
                agentFiles.add(agentFile);
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd HHmmss");
                    RTLogger.print(1, "TLC - listdir: found file: %s - %s bytes. lmd=%s", agentFile.getFilename(), agentFile.getSizeInBytes(), sdf.format(new Date(agentFile.getLastModifiedDate())));
                }
                catch (Exception exception) {}
            }
            RTLogger.print(1, "TLC - listdir: %s. ok.", msg.getPath());
        }
        catch (Exception e) {
            RTLogger.print(1, "TLC Error - listdir: %s", msg.getPath(), e);
            response.setError(e.getMessage());
        }
        TlcAgentFileDir dir = new TlcAgentFileDir();
        dir.setFiles(agentFiles);
        response.setFileList(dir);
        this.messageSender.sendMessage(response);
    }

    @MessageHandlerMethod
    public void handle(TlcRenameFileRequest request) {
        try {
            Path fromFilePath = Paths.get(request.getAbsolutePathFrom(), new String[0]);
            Path toFilePath = Paths.get(request.getAbsolutePathTo(), new String[0]);
            if (Files.exists(toFilePath, new LinkOption[0])) {
                this.messageSender.sendMessage(new TlcRenameFileResponse(request, "Target file is already exists"));
                RTLogger.print(1, "TLC Error - move file: %s to: %s file already exists", request.getAbsolutePathFrom(), request.getAbsolutePathTo());
            } else {
                Files.move(fromFilePath, toFilePath, StandardCopyOption.ATOMIC_MOVE);
                this.messageSender.sendMessage(new TlcRenameFileResponse(request));
                RTLogger.print(1, "TLC - moved file: %s to %s", fromFilePath, toFilePath);
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "TLC Error - move file: %s to: %s", request.getAbsolutePathFrom(), request.getAbsolutePathTo(), e);
            this.messageSender.sendMessage(new TlcRenameFileResponse(request, "Error renaming file"));
        }
    }

    @MessageHandlerMethod
    public void handle(TlcDeleteFileRequest request) {
        try {
            Path fileToDeletePath = Paths.get(request.getAbsolutePath(), new String[0]);
            if (Files.exists(fileToDeletePath, new LinkOption[0])) {
                Files.delete(fileToDeletePath);
                this.messageSender.sendMessage(new TlcDeleteFileResponse(request));
                RTLogger.print(1, "TLC - deleted file: %s", fileToDeletePath);
            } else {
                RTLogger.print(1, "TLC Error - deleted file: %s. FileNotFound", fileToDeletePath);
                this.messageSender.sendMessage(new TlcDeleteFileResponse(request, "File not found: " + request.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "TLC Error - deleted file: %s", request.getAbsolutePath(), e);
            this.messageSender.sendMessage(new TlcDeleteFileResponse(request, "Error deleting file: " + e.getMessage()));
        }
    }
}

