/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.netty;

import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.boom.netty.common.MessageSender;
import com.boom.netty.service.tl.TCmd;
import com.boom.netty.service.tl.TCmdResult;
import com.boom.netty.service.tl.msg.TldCmdsRequest;
import com.boom.netty.service.tl.msg.TldCmdsResponse;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class TldCmdRecieveHandler {
    private MessageSender messageSender;
    String workingDir;

    public TldCmdRecieveHandler(MessageSender messageSender, String workingDir) {
        this.messageSender = messageSender;
        this.workingDir = workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MessageHandlerMethod
    public void handle(TldCmdsRequest msg) {
        TldCmdsResponse response = new TldCmdsResponse(msg.getSource(), msg.getOperationId());
        ArrayList<TCmdResult> cmdResults = new ArrayList<TCmdResult>();
        for (TCmd cmd : msg.getCmds()) {
            TCmdResult res = new TCmdResult();
            res.setCmdId(cmd.getId());
            try {
                String fullCommand = this.getFullCommand(cmd);
                RTLogger.print(1, "Running : " + fullCommand + " on working directory :" + this.workingDir);
                ExecResult cmdResult = ExecUtils.exec2(fullCommand, new File(this.workingDir), cmd.getTimeoutSec());
                StringBuilder sbResult = new StringBuilder();
                Iterator<String> it = cmdResult.m_outMessages.iterator();
                while (it.hasNext()) {
                    sbResult.append(it.next());
                    if (!it.hasNext()) continue;
                    sbResult.append('\n');
                }
                StringBuilder sbError = new StringBuilder();
                Iterator<String> itError = cmdResult.m_errorMessages.iterator();
                while (itError.hasNext()) {
                    sbError.append(itError.next());
                    if (!itError.hasNext()) continue;
                    sbError.append('\n');
                }
                res.setResultCode(cmdResult.resultCode);
                res.setResponse(sbResult.toString());
                res.setError(sbError.toString());
                RTLogger.print(1, "Command : %s done. RC=%s - %s", cmd.getCmd(), cmdResult.resultCode, cmdResult.getOutput());
                cmdResults.add(res);
                if (res.getError() == null || cmd.isContinueOnError()) continue;
                break;
            }
            catch (IOException e) {
                res.setError("Error while executing command : " + e.getMessage());
                RTLogger.print(1, "Exception during running command : %s", cmd.getCmd(), e);
                cmdResults.add(res);
                if (cmd.isContinueOnError()) continue;
                break;
            }
            finally {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        response.setCmdsResult(cmdResults);
        this.messageSender.sendMessage(response);
    }

    private String getFullCommand(TCmd cmd) {
        String fullCommand = cmd.getCmd();
        if (cmd.getParameters() != null) {
            for (int i = 0; i < cmd.getParameters().length; ++i) {
                String p = cmd.getParameters()[i];
                fullCommand = fullCommand.replace("{" + i + "}", p);
            }
        }
        return fullCommand;
    }
}

