/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.utils;

import com.blixx.shared.MsgPolicy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cube {
    private Map<String, MsgPolicy> m_top = new ConcurrentHashMap<String, MsgPolicy>();
    private Map<String, HashSet<String>> m_keyMap = new ConcurrentHashMap<String, HashSet<String>>();
    private Map<String, HashSet<String>> m_cache = new ConcurrentHashMap<String, HashSet<String>>();

    public void remove(String name) {
        this.m_top.remove(name);
        Iterator<String> it = this.m_keyMap.keySet().iterator();
        while (it.hasNext()) {
            HashSet<String> inner = this.m_keyMap.get(it.next());
            if (!inner.contains(name)) continue;
            inner.remove(name);
        }
    }

    public void add(MsgPolicy p) {
        this.m_cache.clear();
        this.m_top.put(p.getName(), p);
        HashSet<String> keySet = p.getAMKeys();
        for (String AppMap : keySet) {
            HashSet<Object> inner;
            if (this.m_keyMap.containsKey(AppMap)) {
                inner = this.m_keyMap.get(AppMap);
                if (inner.contains(p.getName())) continue;
                inner.add(p.getName());
                continue;
            }
            inner = new HashSet<String>();
            inner.add(p.getName());
            this.m_keyMap.put(AppMap, inner);
        }
    }

    public MsgPolicy getPolicy(String name) {
        return this.m_top.get(name);
    }

    private HashSet<String> getPolicies(String AMkey) {
        return this.m_keyMap.get(AMkey);
    }

    public HashSet<String> getFilteresPolicies(String appl, String msggrp) {
        HashSet<String> m4h;
        HashSet<String> m3h;
        HashSet<String> m2h;
        String m1;
        boolean isMsgGrpDefined = true;
        if (msggrp == null) {
            isMsgGrpDefined = false;
        }
        if (this.m_cache.containsKey(m1 = appl + "@@" + msggrp)) {
            return this.m_cache.get(m1);
        }
        String m2 = appl + "@@<*>";
        String m3 = "<*>@@" + msggrp;
        String m4 = "<*>@@<*>";
        HashSet<String> filtered = new HashSet<String>();
        HashSet<String> m1h = this.getPolicies(m1);
        if (m1h != null && isMsgGrpDefined) {
            filtered.addAll(m1h);
        }
        if ((m2h = this.getPolicies(m2)) != null) {
            filtered.addAll(m2h);
        }
        if ((m3h = this.getPolicies(m3)) != null && isMsgGrpDefined) {
            filtered.addAll(m3h);
        }
        if ((m4h = this.getPolicies(m4)) != null) {
            filtered.addAll(m4h);
        }
        this.m_cache.put(m1, filtered);
        return filtered;
    }

    public boolean isEmpty() {
        return this.m_top.size() == 0;
    }
}

