/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.utils;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.MMObject;
import com.blixx.agent.Message;
import com.blixx.agent.MonitorValue;
import com.blixx.shared.Severity;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SupportedVariables {
    private static final String _1 = "<1*>";
    public static final String UTF_8 = "UTF-8";
    private String hostname = "";
    private AgentEngine agent = null;
    static Pattern doProcessing = Pattern.compile(".*(\\Q<$\\E[+-\\\\>]+\\d+>).*");

    public SupportedVariables() {
        this.agent = AgentEngine.getInstance();
        this.hostname = this.agent.getAgentHostname();
    }

    public SupportedVariables(boolean test) {
    }

    public String replaceAll(String message, MonitorValue mv) {
        try {
            if (message.indexOf(36) == -1) {
                return message;
            }
            AgentEngine agent = AgentEngine.getInstance();
            message = message.replace("<$AGENT_HOST>", agent.getAgentHostname());
            message = message.replace("<$AGENT_IP>", agent.getAgentIP());
            message = message.replace("<$AGENT_ID>", agent.getAgentID());
            message = message.replace("<$MSG_NODE_ID>", agent.getAgentID());
            if (mv.getNode().equals("")) {
                message = message.replace("<$MSG_NODE_NAME>", this.hostname);
                message = message.replace("<$HOST_NAME>", this.hostname);
                message = message.replace("<$MSG_NODE>", this.hostname);
                message = message.replace("<$HOST>", this.hostname);
            } else {
                message = this.resolveHostName(message, mv.getNode());
                message = message.replace("<$MSG_NODE_NAME>", mv.getNode());
                message = message.replace("<$HOST_NAME>", mv.getNode());
                message = message.replace("<$MSG_NODE>", mv.getNode());
                message = message.replace("<$HOST>", mv.getNode());
            }
            if (mv.p3_object != null) {
                message = message.replace("<$MSG_OBJECT>", mv.p3_object);
                message = message.replace("<$OBJECT>", mv.p3_object);
            }
            String severity = Severity.getSeverity(mv.p4_severity);
            message = message.replace("<$MSG_SEV>", severity);
            message = message.replace("<$SEVERITY>", severity);
            message = message.replace("<$NAME>", mv.p2_policyName);
            message = message.replace("<$VALUE>", "" + mv.p0_value);
            message = message.replace("<$TIME>", "" + mv.p1_time);
            message = message.replace("<$THRESHOLD>", "" + mv.getOptions().get("THRESHOLD"));
            message = message.replace("<$EMPTY>", "");
            message = message.replace("<$OPTIONS>", "" + mv.getOptions());
            message = this.replaceOptVars(message, mv.getOptions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    public String replaceAll4URLEncoded(String message, MMObject mv) {
        try {
            String val;
            AgentEngine agent = AgentEngine.getInstance();
            message = message.replace("<$AGENT_HOST>", URLEncoder.encode(agent.getAgentHostname(), UTF_8));
            message = message.replace("<$AGENT_IP>", URLEncoder.encode(agent.getAgentIP(), UTF_8));
            message = message.replace("<$AGENT_ID>", URLEncoder.encode(agent.getAgentID(), UTF_8));
            message = message.replace("<$MSG_NODE_ID>", URLEncoder.encode(agent.getAgentID(), UTF_8));
            if (mv.p3_object != null) {
                message = message.replace("<$MSG_OBJECT>", URLEncoder.encode(mv.p3_object, UTF_8));
                message = message.replace("<$OBJECT>", URLEncoder.encode(mv.p3_object, UTF_8));
            }
            if (mv.p2_application != null) {
                val = URLEncoder.encode(mv.p2_application, UTF_8);
                message = message.replace("<$MSG_APPL>", val);
                message = message.replace("<$APPLICATION>", val);
            }
            if (mv.p7_msg_grp != null) {
                val = URLEncoder.encode(mv.p7_msg_grp, UTF_8);
                message = message.replace("<$MSG_GRP>", val);
                message = message.replace("<$GROUP>", val);
            }
            String severity = Severity.getSeverity(mv.p4_severity);
            message = message.replace("<$MSG_SEV>", severity);
            message = message.replace("<$SEVERITY>", severity);
            message = message.replace("<$OPTIONS>", URLEncoder.encode("" + mv.getOptions(), UTF_8));
            message = message.replace("<$TIME>", "" + mv.p1_time);
            message = message.replace("<$EMPTY>", "");
            message = message.replace("<$NAME>", URLEncoder.encode(mv.p2_policyName, UTF_8));
            message = this.replaceOptVars_URLEncode(message, mv.getOptions());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return message;
    }

    public String replaceAll_URLEncoded(String message, MonitorValue mv) {
        try {
            if (message.indexOf(36) == -1) {
                return message;
            }
            if ((message = this.replaceAll4URLEncoded(message, mv)).indexOf(36) == -1) {
                return message;
            }
            String node = mv.getNode();
            if (node.equals("")) {
                String anode = URLEncoder.encode(this.hostname, UTF_8);
                message = message.replace("<$MSG_NODE_NAME>", anode);
                message = message.replace("<$HOST_NAME>", anode);
                message = message.replace("<$MSG_NODE>", anode);
                message = message.replace("<$HOST>", anode);
            } else {
                message = this.resolveHostName_URLEncode(message, node);
                node = URLEncoder.encode(node, UTF_8);
                message = message.replace("<$MSG_NODE_NAME>", node);
                message = message.replace("<$HOST_NAME>", node);
                message = message.replace("<$MSG_NODE>", node);
                message = message.replace("<$HOST>", node);
            }
            message = message.replace("<$VALUE>", URLEncoder.encode("" + mv.p0_value, UTF_8));
            message = message.replace("<$THRESHOLD>", URLEncoder.encode("" + mv.getOptions().get("THRESHOLD"), UTF_8));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    public String replaceAllForPattern(String message, MonitorValue mv) {
        try {
            if (this.agent != null) {
                message = message.replace("<$AGENT_HOST>", this.agent.getAgentHostname());
                message = message.replace("<$AGENT_IP>", this.agent.getAgentIP());
                message = message.replace("<$AGENT_ID>", this.agent.getAgentID());
                message = message.replace("<$MSG_NODE_ID>", this.agent.getAgentID());
            }
            message = message.replace("<$EMPTY>", "");
            if (mv.getNode().equals("")) {
                message = message.replace("<$MSG_NODE_NAME>", this.hostname);
                message = message.replace("<$MSG_NODE>", this.hostname);
                message = message.replace("<$HOST>", this.hostname);
            } else {
                message = message.replace("<$MSG_NODE_NAME>", mv.getNode());
                message = message.replace("<$MSG_NODE>", mv.getNode());
                message = message.replace("<$HOST>", mv.getNode());
            }
            if (mv.p3_object != null) {
                String str = mv.p3_object;
                str = this.escapeChars(str);
                message = message.replace("<$MSG_OBJECT>", str);
                message = message.replace("<$OBJECT>", str);
            }
            String severity = Severity.getSeverity(mv.p4_severity);
            message = message.replace("<$MSG_SEV>", severity);
            message = message.replace("<$SEVERITY>", severity);
            message = message.replace("<$NAME>", mv.p2_policyName);
            message = message.replace("<$VALUE>", "" + mv.p0_value);
            message = message.replace("<$TIME>", "" + mv.p1_time);
            message = message.replace("<$THRESHOLD>", "" + mv.getOptions().get("THRESHOLD"));
            String str = "" + mv.getOptions();
            str = this.escapeChars(str);
            message = message.replace("<$OPTIONS>", str);
            message = this.replaceOptVarsForPattern(message, mv.getOptions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    private String escapeChars(String str) {
        str = str.replace("\\", "\\\\");
        str = str.replace("[", "\\[");
        str = str.replace("]", "\\]");
        str = str.replace("|", "\\|");
        str = str.replace("<", "\\<");
        str = str.replace(">", "\\>");
        str = str.replace("^", "\\^");
        str = str.replace("$", "\\$");
        return str;
    }

    private String replaceOptVarsForPattern(String message, Map<String, String> options) {
        if (options.size() > 0) {
            for (Map.Entry<String, String> en : options.entrySet()) {
                String variable = en.getKey();
                String optVal = en.getValue();
                if (optVal == null) continue;
                String str = "" + optVal;
                str = this.escapeChars(str);
                if ((message = message.replace("<$" + variable + ">", str)).contains("<$")) continue;
                break;
            }
        }
        return message;
    }

    public String replaceOptVars(String message, Map<String, String> options) {
        if (options.size() > 0) {
            Iterator<Map.Entry<String, String>> it = options.entrySet().iterator();
            while (it.hasNext() && message.contains("<$")) {
                Map.Entry<String, String> en = it.next();
                String variable = en.getKey();
                String optVal = en.getValue();
                if (optVal == null) continue;
                StringBuffer sb = new StringBuffer();
                sb.append("<$");
                sb.append(variable);
                sb.append(">");
                if ((message = message.replace(sb.toString(), optVal)).contains("<$")) continue;
                break;
            }
        }
        return message;
    }

    public String replaceOptVars_URLEncode(String message, Map<String, String> options) {
        if (options.size() > 0) {
            Iterator<Map.Entry<String, String>> it = options.entrySet().iterator();
            while (it.hasNext() && message.contains("<$")) {
                Map.Entry<String, String> en = it.next();
                String variable = en.getKey();
                String optVal = en.getValue();
                if (optVal == null) continue;
                StringBuffer sb = new StringBuffer();
                sb.append("<$");
                sb.append(variable);
                sb.append(">");
                try {
                    message = message.replace(sb.toString(), URLEncoder.encode(optVal, UTF_8));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return message;
    }

    public String replaceAllForPattern(String message, Message m) {
        try {
            String str;
            String str2;
            if (message.contains("_TEXT>")) {
                if (m.m_orig_text != null) {
                    str2 = m.m_orig_text;
                    str2 = this.escapeChars(str2);
                    message = message.replace("<$MSG_ORIG_TEXT>", str2);
                    message = message.replace("<$ORIG_TEXT>", str2);
                    message = message.replace("<$MSG_TEXT>", str2);
                } else if (m.p5_msg_text != null) {
                    str2 = m.p5_msg_text;
                    str2 = this.escapeChars(str2);
                    message = message.replace("<$MSG_ORIG_TEXT>", str2);
                    message = message.replace("<$ORIG_TEXT>", str2);
                    message = message.replace("<$MSG_TEXT>", str2);
                }
            }
            if (this.agent != null) {
                message = message.replace("<$AGENT_HOST>", this.agent.getAgentHostname());
                message = message.replace("<$AGENT_IP>", this.agent.getAgentIP());
                message = message.replace("<$AGENT_ID>", this.agent.getAgentID());
                message = message.replace("<$MSG_NODE_ID>", this.agent.getAgentID());
            }
            if (m.p10_node != null) {
                str2 = m.p10_node;
                str2 = this.escapeChars(str2);
                message = message.replace("<$MSG_NODE_NAME>", str2);
                message = message.replace("<$MSG_NODE>", str2);
                message = message.replace("<$HOST>", str2);
            }
            if (m.p2_application != null) {
                str2 = m.p2_application;
                str2 = this.escapeChars(str2);
                message = message.replace("<$MSG_APPL>", str2);
                message = message.replace("<$APPLICATION>", str2);
            }
            if (m.p3_object != null) {
                str2 = m.p3_object;
                str2 = this.escapeChars(str2);
                message = message.replace("<$MSG_OBJECT>", str2);
                message = message.replace("<$OBJECT>", str2);
            }
            String severity = Severity.getSeverity(m.p4_severity);
            message = message.replace("<$MSG_SEV>", severity);
            message = message.replace("<$SEVERITY>", severity);
            if (m.p7_msg_grp != null) {
                str = m.p7_msg_grp;
                str = this.escapeChars(str);
                message = message.replace("<$MSG_GRP>", str);
                message = message.replace("<$GROUP>", str);
            }
            if (m.p2_policyName != null) {
                message = message.replace("<$NAME>", m.p2_policyName);
            }
            str = "" + m.getOptions();
            str = this.escapeChars(str);
            message = message.replace("<$OPTIONS>", str);
            message = message.replace("<$TIME>", "" + m.p1_time);
            message = this.replaceOptVarsForPattern(message, m.getOptions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    public String replaceAll(String message, Message m) {
        try {
            if (message.indexOf(36) == -1) {
                return message;
            }
            if (message.contains("_TEXT>")) {
                if (m.m_orig_text != null) {
                    message = message.replace("<$MSG_ORIG_TEXT>", m.m_orig_text);
                    message = message.replace("<$ORIG_TEXT>", m.m_orig_text);
                    message = message.replace("<$MSG_TEXT>", m.m_orig_text);
                } else if (m.p5_msg_text != null) {
                    message = message.replace("<$MSG_ORIG_TEXT>", m.p5_msg_text);
                    message = message.replace("<$ORIG_TEXT>", m.p5_msg_text);
                    message = message.replace("<$MSG_TEXT>", m.p5_msg_text);
                }
            }
            AgentEngine agent = AgentEngine.getInstance();
            message = message.replace("<$AGENT_HOST>", agent.getAgentHostname());
            message = message.replace("<$AGENT_IP>", agent.getAgentIP());
            message = message.replace("<$AGENT_ID>", agent.getAgentID());
            message = message.replace("<$MSG_NODE_ID>", agent.getAgentID());
            if (m.p10_node != null) {
                message = this.resolveHostName(message, m.p10_node);
                message = message.replace("<$MSG_NODE>", m.p10_node);
                message = message.replace("<$HOST>", m.p10_node);
            }
            if (m.p2_application != null) {
                message = message.replace("<$MSG_APPL>", m.p2_application);
                message = message.replace("<$APPLICATION>", m.p2_application);
            }
            if (m.p3_object != null) {
                message = message.replace("<$MSG_OBJECT>", m.p3_object);
                message = message.replace("<$OBJECT>", m.p3_object);
            }
            String severity = Severity.getSeverity(m.p4_severity);
            message = message.replace("<$MSG_SEV>", severity);
            message = message.replace("<$SEVERITY>", severity);
            if (m.p7_msg_grp != null) {
                message = message.replace("<$MSG_GRP>", m.p7_msg_grp);
                message = message.replace("<$GROUP>", m.p7_msg_grp);
            }
            message = message.replace("<$OPTIONS>", "" + m.getOptions());
            message = message.replace("<$TIME>", "" + m.p1_time);
            message = message.replace("<$EMPTY>", "");
            if (m.p2_policyName != null) {
                message = message.replace("<$NAME>", m.p2_policyName);
            }
            message = this.replaceOptVars(message, m.getOptions());
            message = this.replaceSNMPvars(message, m);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    public String replaceAll_URLEncode(String message, Message m) {
        try {
            String val;
            if (message.indexOf(36) == -1) {
                return message;
            }
            if (m.m_orig_text != null) {
                val = URLEncoder.encode(m.m_orig_text, UTF_8);
                message = message.replace("<$MSG_ORIG_TEXT>", val);
                message = message.replace("<$ORIG_TEXT>", val);
                message = message.replace("<$MSG_TEXT>", val);
            } else if (m.p5_msg_text != null) {
                val = URLEncoder.encode(m.p5_msg_text, UTF_8);
                message = message.replace("<$MSG_ORIG_TEXT>", val);
                message = message.replace("<$ORIG_TEXT>", val);
                message = message.replace("<$MSG_TEXT>", val);
            }
            message = this.replaceAll4URLEncoded(message, m);
            if (message.indexOf(36) == -1) {
                return message;
            }
            if (m.p10_node != null) {
                message = this.resolveHostName_URLEncode(message, m.p10_node);
                val = URLEncoder.encode(m.p10_node, UTF_8);
                message = message.replace("<$MSG_NODE>", val);
                message = message.replace("<$HOST>", val);
            }
            message = this.replaceSNMPvars_URLEncode(message, m);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    public String replaceSNMPvars(String msg, Message event) {
        try {
            if (!msg.contains("<$")) {
                return msg;
            }
            if (doProcessing.matcher(msg).matches() && event.getOptions().containsKey("1")) {
                Pattern p1 = Pattern.compile(".*(\\Q<$+\\E(\\d+)>).*");
                Matcher m = p1.matcher(msg);
                while (m.matches()) {
                    String variable = m.group(1);
                    String number = m.group(2);
                    String value = event.getOptions().get(number);
                    if (value == null) continue;
                    msg = msg.replace(variable, value);
                    m = p1.matcher(msg);
                }
                if (!msg.contains("<$")) {
                    return msg;
                }
                Pattern p2 = Pattern.compile(".*(\\Q<$-\\E(\\d+)>).*");
                m = p2.matcher(msg);
                while (m.matches()) {
                    String variable = m.group(1);
                    String number = m.group(2);
                    String value = event.getOptions().get(number);
                    if (value == null) continue;
                    StringBuffer ab = new StringBuffer();
                    ab.append('[').append(number).append("]: ").append(value);
                    msg = msg.replace(variable, ab.toString());
                    m = p2.matcher(msg);
                }
                if (!msg.contains("<$")) {
                    return msg;
                }
                Pattern p3 = Pattern.compile(".*(\\Q<$\\>\\E(\\d+)>).*");
                m = p3.matcher(msg);
                while (m.matches()) {
                    String value;
                    String variable = m.group(1);
                    String number = m.group(2);
                    StringBuffer replacement = new StringBuffer("\n");
                    for (int i = Integer.parseInt(number); i < 1000 && (value = event.getOptions().get("" + i)) != null; ++i) {
                        replacement.append(value).append('\n');
                        m = p3.matcher(msg);
                    }
                    msg = msg.replace(variable, replacement.toString());
                }
                if (!msg.contains("<$")) {
                    return msg;
                }
                Pattern p4 = Pattern.compile(".*(\\Q<$\\>+\\E(\\d+)>).*");
                Pattern p5 = Pattern.compile(".*(\\Q<$\\>-\\E(\\d+)>).*");
                m = p4.matcher(msg);
                while (m.matches() || (m = p5.matcher(msg)).matches()) {
                    String value;
                    String variable = m.group(1);
                    String number = m.group(2);
                    StringBuffer replacement = new StringBuffer("\n");
                    for (int i = Integer.parseInt(number); i < 1000 && (value = event.getOptions().get("" + i)) != null; ++i) {
                        replacement.append('[').append(i).append("]: ").append(value).append('\n');
                        m = p4.matcher(msg);
                    }
                    msg = msg.replace(variable, replacement.toString());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return msg;
    }

    public String replaceSNMPvars_URLEncode(String msg, Message event) {
        try {
            if (!msg.contains("<$")) {
                return msg;
            }
            if (doProcessing.matcher(msg).matches() && event.getOptions().containsKey("1")) {
                Pattern p1 = Pattern.compile(".*(\\Q<$+\\E(\\d+)>).*");
                Matcher m = p1.matcher(msg);
                while (m.matches()) {
                    String variable = m.group(1);
                    String number = m.group(2);
                    String value = event.getOptions().get(number);
                    if (value == null) continue;
                    msg = msg.replace(variable, URLEncoder.encode(value, UTF_8));
                    m = p1.matcher(msg);
                }
                if (!msg.contains("<$")) {
                    return msg;
                }
                Pattern p2 = Pattern.compile(".*(\\Q<$-\\E(\\d+)>).*");
                m = p2.matcher(msg);
                while (m.matches()) {
                    String variable = m.group(1);
                    String number = m.group(2);
                    String value = event.getOptions().get(number);
                    if (value == null) continue;
                    StringBuffer ab = new StringBuffer();
                    ab.append('[').append(number).append("]: ").append(value);
                    msg = msg.replace(variable, URLEncoder.encode(ab.toString(), UTF_8));
                    m = p2.matcher(msg);
                }
                if (!msg.contains("<$")) {
                    return msg;
                }
                Pattern p3 = Pattern.compile(".*(\\Q<$\\>\\E(\\d+)>).*");
                m = p3.matcher(msg);
                while (m.matches()) {
                    String value;
                    String variable = m.group(1);
                    String number = m.group(2);
                    StringBuffer replacement = new StringBuffer("\n");
                    for (int i = Integer.parseInt(number); i < 1000 && (value = event.getOptions().get("" + i)) != null; ++i) {
                        replacement.append(value).append('\n');
                        m = p3.matcher(msg);
                    }
                    msg = msg.replace(variable, URLEncoder.encode(replacement.toString(), UTF_8));
                }
                if (!msg.contains("<$")) {
                    return msg;
                }
                Pattern p4 = Pattern.compile(".*(\\Q<$\\>+\\E(\\d+)>).*");
                Pattern p5 = Pattern.compile(".*(\\Q<$\\>-\\E(\\d+)>).*");
                m = p4.matcher(msg);
                while (m.matches() || (m = p5.matcher(msg)).matches()) {
                    String value;
                    String variable = m.group(1);
                    String number = m.group(2);
                    StringBuffer replacement = new StringBuffer("\n");
                    for (int i = Integer.parseInt(number); i < 1000 && (value = event.getOptions().get("" + i)) != null; ++i) {
                        replacement.append('[').append(i).append("]: ").append(value).append('\n');
                        m = p4.matcher(msg);
                    }
                    msg = msg.replace(variable, URLEncoder.encode(replacement.toString(), UTF_8));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return msg;
    }

    public String resolveHostName(String message, String nodeName) {
        if (nodeName == null) {
            return message;
        }
        if (message.indexOf("<$MSG_NODE_NAME>") != -1 || message.indexOf("<$HOST_NAME>") != -1) {
            try {
                String lookup = nodeName;
                InetAddress byName = InetAddress.getByName(nodeName);
                lookup = byName.isLoopbackAddress() ? AgentEngine.getInstance().getAgentHostname() : byName.getHostName();
                message = message.replace("<$MSG_NODE_NAME>", lookup);
                message = message.replace("<$HOST_NAME>", lookup);
            }
            catch (Throwable e) {
                message = message.replace("<$MSG_NODE_NAME>", nodeName);
                message = message.replace("<$HOST_NAME>", nodeName);
            }
        }
        return message;
    }

    public String resolveHostName_URLEncode(String message, String nodeName) {
        if (nodeName == null) {
            return message;
        }
        if (message.indexOf("<$MSG_NODE_NAME>") != -1 || message.indexOf("<$HOST_NAME>") != -1) {
            try {
                String lookup = nodeName;
                InetAddress byName = InetAddress.getByName(nodeName);
                lookup = byName.isLoopbackAddress() ? AgentEngine.getInstance().getAgentHostname() : byName.getHostName();
                lookup = URLEncoder.encode(lookup, UTF_8);
                message = message.replace("<$MSG_NODE_NAME>", lookup);
                message = message.replace("<$HOST_NAME>", lookup);
            }
            catch (Throwable e) {
                message = message.replace("<$MSG_NODE_NAME>", nodeName);
                message = message.replace("<$HOST_NAME>", nodeName);
            }
        }
        return message;
    }
}

