/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.utils;

import com.blixx.agent.HTTPOut;
import com.blixx.log.RTLogger;
import com.blixx.sa.VirtualSocket;
import com.blixx.shared.io.SDataInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class VirtualSocketAgent
extends VirtualSocket {
    HTTPOut m_out = null;
    String m_url = null;

    public VirtualSocketAgent(String sessionid, HTTPOut out, String url) {
        super(sessionid);
        this.m_out = out;
        this.m_url = url;
    }

    @Override
    public void setState(int state) throws IOException {
        this.getOs().setTimeoutTime(System.currentTimeMillis() + (long)this.m_SOTimeout);
        this.getIs().setTimeoutTime(System.currentTimeMillis() + (long)this.m_SOTimeout);
        if (state == 2 && this.m_state.compareAndSet(1, 2)) {
            this.getOs().setTimeoutTime(System.currentTimeMillis() + (long)this.m_SOTimeout);
        } else if (state == 1 && this.m_state.compareAndSet(2, 1)) {
            this.sendResponseNow();
            this.getIs().setTimeoutTime(System.currentTimeMillis() + (long)this.m_SOTimeout);
        } else if (!(state == 1 && this.m_state.compareAndSet(0, 1) || state == 2 && this.m_state.compareAndSet(0, 2) || state != 3)) {
            this.sendResponseNow();
            this.m_state.set(state);
        }
    }

    @Override
    protected void sendResponseNow() throws IOException {
        if (this.getOs().getOutputStream() instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)this.getOs().getOutputStream();
            byte[] tosend = bos.toByteArray();
            try {
                bos.reset();
                SDataInputStream sis = null;
                try {
                    sis = this.m_out.sendData(this.m_url, this.m_out.getLastSessionID(), tosend);
                }
                catch (Throwable e) {
                    RTLogger.print(3, "HTTPOut error ", e);
                }
                if (this.m_out.getLastResponse() >= 500) {
                    StringBuffer sb = new StringBuffer("<");
                    byte[] arr = new byte[64000];
                    int count = -1;
                    InputStream inputStream = sis.getInputStream();
                    while ((count = inputStream.read(arr)) != -1) {
                        sb.append(new String(arr, 0, count));
                    }
                    throw new IOException(sb.toString());
                }
                if (!this.getIs().isClosed()) {
                    this.getIs().setInputStream(sis.getInputStream());
                }
            }
            catch (Throwable e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public boolean isSendResponseOnCloseState() {
        return false;
    }
}

