/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.sc.CMDS;
import java.io.IOException;

public class ScAsnTreeUpdate
extends ServerClient {
    public ScAsnTreeUpdate(IServerAuth auth, AsnUpdateAction[] actions) {
        super(auth);
        String[] array = new String[actions.length * 4];
        int i = 0;
        for (AsnUpdateAction aua : actions) {
            array[i++] = aua.m_path;
            array[i++] = aua.m_element;
            array[i++] = aua.m_action;
            array[i++] = aua.m_type;
        }
        this.setCommand("ASSIGNMENTTREEUPDATE2", null, array);
    }

    @Override
    public String getResultObject() {
        return (String)this.m_result;
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = this.m_parameters.length;
        os.writeInt(size / 4);
        for (int i = 0; i < size; i += 4) {
            String treePath = this.m_parameters[i];
            String newElement = this.m_parameters[i + 1];
            String action = this.m_parameters[i + 2];
            String type = this.m_parameters[i + 3];
            os.writeUTF(treePath);
            os.writeUTF(newElement);
            os.writeUTF(action);
            os.writeUTF(type);
        }
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if ("T".equals(status)) {
            this.isOKFinished = true;
        }
    }

    public static class AsnUpdateActionRename
    extends AsnUpdateAction {
        public AsnUpdateActionRename(String selectedPath, String newElementName, String gtoType) {
            super(selectedPath, newElementName, CMDS.ACTION_RNM, gtoType);
        }
    }

    public static class AsnUpdateActionMove
    extends AsnUpdateAction {
        public AsnUpdateActionMove(String selectedPath, String targetParentPath, String gtoType) {
            super(selectedPath, targetParentPath, CMDS.ACTION_MOVE, gtoType);
        }
    }

    public static class AsnUpdateActionCopy
    extends AsnUpdateAction {
        public AsnUpdateActionCopy(String selectedPath, String targetParentPath, String gtoType) {
            super(selectedPath, targetParentPath, CMDS.ACTION_COPY, gtoType);
        }
    }

    public static class AsnUpdateActionDeleteLinkNoDeploy
    extends AsnUpdateAction {
        public AsnUpdateActionDeleteLinkNoDeploy(String path, String gtoType) {
            super(path, "nonrecursive", CMDS.ACTION_DELLINK_noDeploy, gtoType);
        }
    }

    public static class AsnUpdateActionDeleteLink
    extends AsnUpdateAction {
        public AsnUpdateActionDeleteLink(String path, String gtoType) {
            super(path, "nonrecursive", CMDS.ACTION_DELLINK, gtoType);
        }
    }

    public static class AsnUpdateActionDeleteRecursivePlusUndeploy
    extends AsnUpdateAction {
        public AsnUpdateActionDeleteRecursivePlusUndeploy(String path, String gtoType) {
            super(path, "recursive", CMDS.ACTION_DEL_and_UNDEPLOY, gtoType);
        }
    }

    public static class AsnUpdateActionDeleteRecursive
    extends AsnUpdateAction {
        public AsnUpdateActionDeleteRecursive(String path, String gtoType) {
            super(path, "recursive", CMDS.ACTION_DEL, gtoType);
        }
    }

    public static class AsnUpdateActionDelete
    extends AsnUpdateAction {
        public AsnUpdateActionDelete(String path, String gtoType) {
            super(path, "nonrecursive", CMDS.ACTION_DEL, gtoType);
        }
    }

    public static class AsnUpdateActionAddLinkNoDeploy
    extends AsnUpdateAction {
        public AsnUpdateActionAddLinkNoDeploy(String link, String targetGTO, String gtoType) {
            super(link, targetGTO, CMDS.ACTION_ADDLINK_noDeploy, gtoType);
        }
    }

    public static class AsnUpdateActionAddLink
    extends AsnUpdateAction {
        public AsnUpdateActionAddLink(String link, String targetGTO, String gtoType) {
            super(link, targetGTO, CMDS.ACTION_ADDLINK, gtoType);
        }
    }

    public static class AsnUpdateActionAdd
    extends AsnUpdateAction {
        public AsnUpdateActionAdd(String parentPath, String gtoName, String gtoType) {
            super(parentPath, gtoName, CMDS.ACTION_ADD, gtoType);
        }
    }

    public static class AsnUpdateAction {
        public String m_path;
        public String m_element;
        public String m_action;
        public String m_type;

        public AsnUpdateAction(String path, String element, String action, String type) {
            this.m_path = path;
            this.m_element = element;
            this.m_action = action;
            this.m_type = type;
        }
    }
}

