/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.SCParametersException;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.log.RTLogger;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.File;
import java.io.IOException;

public class ScGetActions
extends ServerClient {
    public ScGetActions(IServerAuth auth, String actionDirectory) throws SCParametersException {
        super(auth);
        if (actionDirectory == null) {
            throw new SCParametersException("ActionDirectory must be not null");
        }
        while (actionDirectory.endsWith("/") || actionDirectory.endsWith("\\")) {
            actionDirectory = actionDirectory.substring(0, actionDirectory.length() - 1);
        }
        this.setCommand("GETACTIONS", actionDirectory);
    }

    @Override
    public String getResultObject() {
        return (String)this.m_result;
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        if (!this.m_action.endsWith(File.separator)) {
            this.m_action = this.m_action + File.separator;
        }
        try {
            File tempDir = new File(this.m_action);
            File[] files = tempDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].delete()) continue;
                RTLogger.print(2, "Can't delete file:" + files[i].getPath());
            }
        }
        catch (Throwable e) {
            RTLogger.print(2, "Can't clean up dir " + this.m_action);
        }
        StringBuffer sb = new StringBuffer();
        int filesCount = is.readInt();
        for (int j = 0; j < filesCount; ++j) {
            String filename = is.readUTF();
            long size = is.readLong();
            if (size <= 0L) continue;
            File file = new File(this.m_action + filename);
            is.readFile(file.getCanonicalPath());
            sb.append(file.getPath()).append('\n');
        }
        String status = is.readUTF();
        if ("T".equals(status)) {
            this.isOKFinished = true;
            this.m_result = sb.toString();
        } else {
            this.m_result = status;
        }
    }
}

