/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.log.RTLogger;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ScGetAgentsCM
extends ServerClient {
    private List<String> m_agentIDs = null;

    public ScGetAgentsCM(IServerAuth auth) {
        super(auth);
        this.setCommand("GET_AGENTS_CM");
    }

    public ScGetAgentsCM(IServerAuth auth, String agentID) {
        this(auth);
        this.m_agentIDs = new ArrayList<String>(1);
        this.m_agentIDs.add(agentID);
    }

    public ScGetAgentsCM(IServerAuth auth, List<String> agentIDs) {
        this(auth);
        this.m_agentIDs = new ArrayList<String>(agentIDs);
    }

    @Override
    public Map<String, AgentCardCM> getResultObject() {
        return (Map)this.m_result;
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        this.m_result = new LinkedHashMap();
        os.writeUTF(this.m_command);
        String error = is.readUTF();
        if (!"T".equals(error)) {
            this.m_result = null;
            this.m_lastException = new RuntimeException(error);
            this.isOKFinished = false;
        } else {
            os.writeInt(this.m_agentIDs == null ? 0 : this.m_agentIDs.size());
            if (this.m_agentIDs != null) {
                for (String id : this.m_agentIDs) {
                    os.writeUTF(id);
                }
            }
            while (is.readBoolean()) {
                String id = is.readUTF();
                AgentCardCM acm = new AgentCardCM(id);
                while (is.readBoolean()) {
                    String fieldName = is.readUTF();
                    String value = is.readUTF();
                    try {
                        acm.add(fieldName, AgentCardCM.getValue(fieldName, value));
                    }
                    catch (Exception e) {
                        RTLogger.print(3, "", e);
                    }
                }
                ((Map)this.m_result).put(acm.getID(), acm);
            }
            this.isOKFinished = true;
        }
    }

    public void runCommandOnServer(SDataInputStream is, SDataOutputStream os, Map<String, AgentCardCM> agentsCM) throws IOException {
        int filterIDSize = is.readInt();
        LinkedHashMap<String, AgentCardCM> filtered = null;
        if (filterIDSize > 0) {
            filtered = new LinkedHashMap<String, AgentCardCM>();
            for (int i = 0; i < filterIDSize; ++i) {
                String id = is.readUTF();
                AgentCardCM acm = agentsCM.get(id);
                if (acm == null) continue;
                filtered.put(id, acm);
            }
        }
        for (Map.Entry<String, AgentCardCM> en : agentsCM.entrySet()) {
            os.writeBoolean(true);
            os.writeUTF(en.getKey());
            for (Map.Entry<String, Object> attribute : en.getValue().getAttributes().entrySet()) {
                if (attribute.getValue() == null) continue;
                os.writeBoolean(true);
                os.writeUTF(attribute.getKey());
                os.writeUTF("" + attribute.getValue());
            }
            os.writeBoolean(false);
        }
        os.writeBoolean(false);
    }
}

