/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.SCParametersException;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class ScGetForwardPolicies
extends ServerClient {
    public ScGetForwardPolicies(IServerAuth auth, String policyDirectory) throws SCParametersException {
        super(auth);
        if (policyDirectory == null) {
            throw new SCParametersException("policyDirectory must be not null");
        }
        while (policyDirectory.endsWith("/") || policyDirectory.endsWith("\\")) {
            policyDirectory = policyDirectory.substring(0, policyDirectory.length() - 1);
        }
        this.setCommand("GET_FORWARD_POLICIES", policyDirectory);
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = is.readInt();
        File ldir = new File(this.m_action);
        if (!ldir.exists()) {
            ldir.mkdirs();
        }
        if (ldir.exists()) {
            int i;
            File[] fpList = ldir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".fwd.xml");
                }
            });
            for (i = 0; i < fpList.length; ++i) {
                File oldCached = fpList[i];
                if (oldCached.delete()) continue;
            }
            for (i = 0; i < size; ++i) {
                String filename = is.readUTF();
                long filesize = is.readLong();
                if (filesize <= 0L) continue;
                File fwdFile = new File(this.m_action, filename);
                is.readFile(fwdFile.getCanonicalPath());
            }
            String status = is.readUTF();
            if ("T".equals(status)) {
                this.isOKFinished = true;
            }
        }
    }
}

