/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ScJob
extends ServerClient {
    Map<String, String> m_options = new LinkedHashMap<String, String>();

    public ScJob(IServerAuth auth, String jobname, String[] parameters, int timeout) {
        super(auth);
        this.setCommand("JOB", jobname, parameters);
        this.setTimeout(timeout);
    }

    public ScJob(IServerAuth auth, String jobname, int timeout) {
        super(auth);
        this.setCommand("JOB", jobname);
        this.setTimeout(timeout);
    }

    protected ScJob(IServerAuth auth) {
        super(auth);
    }

    @Override
    public String getResultObject() {
        return (String)this.m_result;
    }

    public void addOption(String key, String value) {
        if (key == null || value == null) {
            throw new RuntimeException("Null key or value is not allowed.");
        }
        this.m_options.put(key, value);
    }

    public Map<String, String> getOptions() {
        return this.m_options;
    }

    public void clearOptions() {
        this.m_options.clear();
    }

    public String removeOption(String key) {
        return this.m_options.remove(key);
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        if (this.m_options.size() > 0) {
            os.writeUTF("OPTS");
            for (Map.Entry<String, String> en : this.m_options.entrySet()) {
                os.writeBoolean(true);
                os.writeUTF(en.getKey());
                os.writeUTF(en.getValue());
            }
            os.writeBoolean(false);
        }
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeInt(this.m_parameters.length);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            os.writeUTF(this.m_parameters[i]);
        }
        String OK = is.readUTF();
        if ("T".equals(OK)) {
            this.m_result = "T";
            this.isOKFinished = true;
        } else {
            this.m_result = OK;
        }
    }
}

