/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.ctrl.sc.IGetEvent;
import com.blixx.ctrl.sc.INotiMgr;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.notify.Notifier;
import com.blixx.shared.notify.NotifierQueueFull;
import com.blixx.shared.notify.NotifierStopped;
import java.io.IOException;
import java.util.List;

public class ScPushIndi2Notifier
extends ServerClient {
    List<String> m_indicationIDs = null;
    String m_notifiID = null;

    public ScPushIndi2Notifier(IServerAuth auth, List<String> indicationIDs, String notifiID) {
        super(auth);
        this.setCommand("PUSH_INDI2NOTI");
        this.m_indicationIDs = indicationIDs;
        this.m_notifiID = notifiID;
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_notifiID);
        String answ = is.readUTF();
        if ("T".equals(answ)) {
            for (String iid : this.m_indicationIDs) {
                os.writeBoolean(true);
                os.writeUTF(iid);
            }
            os.writeBoolean(false);
            answ = is.readUTF();
            if ("T".equals(answ)) {
                this.isOKFinished = true;
            } else {
                this.m_result = answ;
                this.m_lastException = new Exception(answ);
            }
        } else {
            this.m_result = answ;
            this.m_lastException = new Exception(answ);
        }
    }

    public void runCommandServer(SDataInputStream is, SDataOutputStream os, INotiMgr mgr, IGetEvent ep, String user) throws IOException {
        String notifiID = is.readUTF();
        Notifier n = mgr.getNotifier(notifiID, false);
        if (n == null) {
            if (mgr.getConfig(notifiID) == null) {
                os.writeUTF("Notification interface not found!");
            } else {
                os.writeUTF("Notification interface is not running!");
            }
        } else if (!n.isStarted()) {
            os.writeUTF("Notification interface is not running!");
        } else {
            os.writeUTF("T");
            int count = 0;
            try {
                while (is.readBoolean()) {
                    String id = is.readUTF();
                    SEventFwd sef = ep.getEvent(id);
                    mgr.sendAsNotification(notifiID, sef, user);
                    ++count;
                }
                os.writeUTF("T");
            }
            catch (NotifierStopped e) {
                while (is.readBoolean()) {
                    is.readUTF();
                }
                os.writeUTF("Notification interface is not running!");
            }
            catch (NotifierQueueFull e) {
                while (is.readBoolean()) {
                    is.readUTF();
                }
                os.writeUTF("Notification queue is full! Count of indications sent: " + count);
            }
            catch (Throwable e) {
                os.writeUTF("Unexpected error during sending indication: " + e.getMessage());
            }
        }
    }
}

