/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ext;

import com.blixx.ext.IPerfMetric;

public class PerfStringMetric
implements IPerfMetric {
    protected String m_name = null;
    protected int m_length = 255;
    protected String m_value = null;

    public PerfStringMetric(String fieldname, String value) {
        this(fieldname, 255, value);
    }

    public PerfStringMetric(String fieldname, int fieldLength, String value) {
        if (fieldname == null) {
            throw new RuntimeException("Invalid performance metric. Name can not be null.");
        }
        this.m_name = fieldname;
        if (fieldLength > 0) {
            this.m_length = fieldLength;
        }
        if (value == null || value.length() == 0) {
            value = "-";
        }
        if (value.length() > this.m_length) {
            value = value.substring(0, this.m_length);
        }
        this.m_value = value;
    }

    @Override
    public int getLength() {
        return this.m_length;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getType() {
        return "VARCHAR";
    }

    @Override
    public Object getValue() {
        return "\"" + this.m_value + "\"";
    }
}

