/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.log;

import com.blixx.log.LogFileFilterAll;
import com.blixx.log.LogFileFilterWeekOlder;
import com.blixx.shared.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SALogger {
    protected static final String LL_START = " <";
    protected static final String LL_END = "> ";
    protected int m_level = 1;
    protected String m_dir = null;
    protected String m_currentFile = null;
    protected String FILE_PREFIX = "RTlog_";
    protected int m_count = 1;
    protected long SIZE_LIMIT = 0L;
    protected int FILE_LIMIT = 0;
    protected final CloseableStream stream = new CloseableStream(null, null, System.out);
    protected static Map<String, File> m_logfiles = new ConcurrentHashMap<String, File>();
    public SimpleDateFormat m_sdf_rtlogger = new SimpleDateFormat("yyMMdd HH:mm:ss");
    public AtomicBoolean m_enabled = new AtomicBoolean(true);
    static Pattern m_pattern_size = Pattern.compile("\\s*(\\d+)\\s*(\\w*)\\s*");

    public SALogger() {
    }

    public SALogger(String dir, String prefix, int logCount, long sizelimit) {
        this.setMaxCount(logCount);
        this.setMaxSize(sizelimit);
        this.setDir(dir, prefix);
        this.checkLogLimits();
    }

    public boolean isEnabled() {
        return this.m_enabled.get();
    }

    public void setEnabled(boolean enabled) {
        if (this.m_enabled.compareAndSet(!enabled, enabled) && !enabled) {
            try {
                this.closeAllStreams();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(int level, String msg) {
        block6: {
            if (msg == null || !this.isEnabled()) {
                return;
            }
            try {
                if (level > this.m_level || msg.trim().length() <= 0) break block6;
                StringBuilder sb = new StringBuilder();
                sb.append(this.getTime()).append(LL_START).append(level).append(LL_END).append(msg.replace('\r', ' ').replace('\n', ' '));
                CloseableStream closeableStream = this.stream;
                synchronized (closeableStream) {
                    this.getPrintStream(false);
                    this.stream.pStream.println(sb);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void print(int level, StringBuffer msg) {
        this.print(level, msg.toString());
    }

    public void print(int level, StringBuilder msg) {
        this.print(level, msg.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStringDirect(String msg) {
        if (msg == null || !this.isEnabled()) {
            return;
        }
        CloseableStream closeableStream = this.stream;
        synchronized (closeableStream) {
            this.getPrintStream(false);
            this.stream.pStream.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(int level, String msg, Throwable e) {
        if (msg == null || !this.isEnabled()) {
            return;
        }
        if (level <= this.m_level) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getTime()).append(LL_START).append(level).append(LL_END).append(msg).append(" Exception:").append(e.getMessage());
                CloseableStream closeableStream = this.stream;
                synchronized (closeableStream) {
                    this.getPrintStream(false);
                    this.stream.pStream.println(sb.toString());
                    e.printStackTrace(this.stream.pStream);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void print(int level, String msg, Object ... arguments) {
        this.print(level, String.format(msg, arguments));
    }

    public PrintStream getPrintStream(boolean isDirChanged) {
        try {
            if (isDirChanged || this.stream.pStream != System.out) {
                String old = this.m_currentFile;
                this.m_currentFile = this.getCurrentLogFilename();
                if (isDirChanged || this.m_currentFile != null && !this.m_currentFile.equals(old)) {
                    this.rotateLogfile(this.m_dir, this.m_currentFile);
                } else {
                    File cf = new File(this.m_currentFile);
                    if (!cf.exists() || this.stream.pStream.checkError()) {
                        this.rotateLogfile(this.m_dir, this.m_currentFile);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.setPrintStream(null, null, System.out);
        }
        return this.stream.pStream;
    }

    public String getCurrentFileName() {
        return this.m_currentFile;
    }

    public void setPrintStream(File file, FileOutputStream fos, PrintStream out) {
        if (this.stream.fos != null) {
            this.closeAllStreams();
        }
        if (file != null) {
            this.stream.setRelatedFile(file);
            this.stream.setFos(fos);
            this.stream.setpStream(out);
        }
    }

    public String getDir() {
        return this.m_dir;
    }

    public void setDir(String logFileDir, String prefix) {
        if (logFileDir == null) {
            this.m_dir = null;
            this.closeAllStreams();
            this.stream.setpStream(System.out);
            return;
        }
        this.setPrefix(prefix);
        this.checkLogLimits();
        logFileDir = SALogger.normalizePath(logFileDir);
        if (this.m_dir == null) {
            this.m_count = this.getMaxCountForToday(logFileDir);
        }
        boolean isDirChanged = logFileDir == null || !logFileDir.equals(this.m_dir);
        this.m_dir = logFileDir;
        File checkDir = new File(this.m_dir);
        if (!checkDir.exists()) {
            checkDir.mkdirs();
        }
        this.getPrintStream(isDirChanged);
    }

    public static String normalizePath(String logFileDir) {
        if (logFileDir == null || logFileDir.length() == 0) {
            return null;
        }
        logFileDir = FileUtils.resolveEnvVars(logFileDir);
        logFileDir = File.separator.equals("/") ? logFileDir.replace("\\", File.separator) : logFileDir.replace("/", File.separator);
        if (!logFileDir.endsWith(File.separator)) {
            logFileDir = logFileDir + File.separator;
        }
        return logFileDir;
    }

    protected int getMaxCountForToday(String logFileDir) {
        final String fullTodayPrefix = this.getTodayPrefix();
        int maxExistingCounter = 1;
        try {
            File[] todayFiles = new File(logFileDir).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(fullTodayPrefix);
                }
            });
            if (todayFiles != null && todayFiles.length > 0) {
                for (int i = 0; i < todayFiles.length; ++i) {
                    String name = todayFiles[i].getName();
                    name = name.replace(fullTodayPrefix, "");
                    name = name.replace(".log", "");
                    try {
                        int counter = Integer.parseInt(name);
                        maxExistingCounter = Math.max(maxExistingCounter, counter);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                maxExistingCounter = 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return maxExistingCounter;
    }

    protected String getTodayPrefix() {
        Calendar rightNow = Calendar.getInstance();
        int dom = rightNow.get(5);
        StringBuilder mid = new StringBuilder();
        mid.append(this.FILE_PREFIX);
        mid.append(rightNow.get(1)).append('.');
        mid.append(rightNow.get(2) + 1).append('.');
        mid.append(dom).append('_');
        return mid.toString();
    }

    protected void rotateLogfile(String directory, String newFilename) {
        try {
            String fullPath = directory + newFilename;
            File nlf = null;
            nlf = m_logfiles.get(fullPath);
            if (nlf == null) {
                nlf = new File(directory + newFilename);
                m_logfiles.put(fullPath, nlf);
            }
            FileOutputStream fos = new FileOutputStream(nlf, true);
            this.setPrintStream(nlf, fos, new PrintStream(fos, true));
        }
        catch (Throwable e) {
            this.setPrintStream(null, null, System.out);
        }
        if (this.FILE_LIMIT > 0) {
            this.deleteOlds2(directory);
        } else {
            this.deleteOlds(directory);
        }
    }

    protected String getCurrentLogFilename() {
        String fname = null;
        try {
            fname = null;
            String mid = this.getTodayPrefix();
            this.m_count = this.getMaxCountForToday(this.getDir());
            StringBuilder fin = new StringBuilder();
            fin.append(mid);
            fin.append(this.m_count);
            fin.append(".log");
            fname = fin.toString();
            File f = new File(this.m_dir + fname);
            if (this.stream.pStream != null) {
                try {
                    this.stream.pStream.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            while (this.SIZE_LIMIT > 0L && f.length() > this.SIZE_LIMIT) {
                ++this.m_count;
                fin = new StringBuilder();
                fin.append(mid);
                fin.append(this.m_count);
                fin.append(".log");
                fname = fin.toString();
                f = new File(this.m_dir + fname);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return fname;
    }

    protected void checkLogLimits() {
        if (!(this.getMaxSize() != 0L && this.getMaxFileCount() != 0 || this.getMaxSize() == 0L && this.getMaxFileCount() == 0)) {
            this.setMaxCount(0);
        }
    }

    protected void deleteOlds(String logFileDir) {
        try {
            File[] oldfiles;
            String dir = logFileDir;
            if (dir.endsWith(File.separator)) {
                dir = logFileDir.substring(0, logFileDir.length() - 1);
            }
            if ((oldfiles = new File(dir).listFiles(new LogFileFilterWeekOlder(this.getFilePrefix()))) != null) {
                for (int i = 0; i < oldfiles.length; ++i) {
                    File file = oldfiles[i];
                    if (file.delete()) continue;
                    this.closeAllStreams();
                    file.delete();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void deleteOlds2(String logFileDir) {
        try {
            File[] oldfiles2 = new File(logFileDir).listFiles(new LogFileFilterAll(this.getFilePrefix(), null));
            if (oldfiles2 != null) {
                Comparator comp = (o1, o2) -> {
                    int check1;
                    long l2;
                    long l1 = o1.lastModified() / 1000L;
                    int comp1 = l1 == (l2 = o2.lastModified() / 1000L) ? 0 : 1;
                    int n = check1 = l1 < l2 ? -1 : comp1;
                    if (check1 == 0) {
                        String name1 = o1.getName();
                        String in1 = name1.substring(name1.lastIndexOf(95) + 1, name1.lastIndexOf(46));
                        String name2 = o2.getName();
                        String in2 = name2.substring(name2.lastIndexOf(95) + 1, name2.lastIndexOf(46));
                        Integer i1 = Integer.parseInt(in1);
                        Integer i2 = Integer.parseInt(in2);
                        check1 = i1.compareTo(i2);
                    }
                    return check1;
                };
                Arrays.sort(oldfiles2, comp);
                for (int i = 0; i < oldfiles2.length - this.FILE_LIMIT; ++i) {
                    File file = oldfiles2[i];
                    m_logfiles.remove(file.getName());
                    if (!file.exists() || file.delete()) continue;
                    this.closeAllStreams();
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getFilePrefix() {
        return this.FILE_PREFIX;
    }

    protected void setPrefix(String prefix) {
        this.FILE_PREFIX = prefix;
    }

    public String getTime() {
        Date d = new Date();
        return this.m_sdf_rtlogger.format(d);
    }

    public void setLevel(int i) {
        this.print(1, "Loglevel set to " + this.m_level);
        this.m_level = i;
    }

    public void closeAllStreams() {
        if (this.stream.fos != null) {
            try {
                if (this.stream.pStream != null && this.stream.pStream != System.out) {
                    this.stream.pStream.close();
                }
                if (this.stream.fos != null) {
                    this.stream.fos.close();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.stream.relatedFile = null;
                this.stream.fos = null;
                this.stream.pStream = System.out;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeAllStreams();
    }

    public int getCurrentLevel() {
        return this.m_level;
    }

    public long parseMaxSize(String size) {
        long di;
        long maxSize = 0xA00000L;
        Matcher m = m_pattern_size.matcher(size = size.toLowerCase());
        if (m.matches()) {
            String digits = m.group(1);
            di = 0L;
            try {
                di = Long.parseLong(digits);
            }
            catch (Throwable e) {
                throw new RuntimeException("invalid logfile size input string: " + size);
            }
        } else {
            throw new RuntimeException("invalid logfile size input string: " + size);
        }
        String suffix = m.group(2).toLowerCase();
        long mult = 1L;
        mult = suffix.equalsIgnoreCase("kb") ? 1024L : (suffix.equalsIgnoreCase("mb") || suffix.equalsIgnoreCase("m") ? 0x100000L : (suffix.equalsIgnoreCase("gb") ? 0x40000000L : 0x100000L));
        maxSize = di * mult;
        return maxSize;
    }

    public long getMaxSize() {
        return this.SIZE_LIMIT;
    }

    public long getMaxSizeMB() {
        return this.SIZE_LIMIT / 0x100000L;
    }

    public int getMaxFileCount() {
        return this.FILE_LIMIT;
    }

    public void setMaxCount(int maxLogFilesCount) {
        if (maxLogFilesCount > 0) {
            this.FILE_LIMIT = maxLogFilesCount;
        } else if (maxLogFilesCount == 0) {
            this.FILE_LIMIT = 0;
            this.SIZE_LIMIT = 0L;
        }
    }

    public void setMaxSize(long maxSize) {
        if (maxSize > 0L) {
            this.SIZE_LIMIT = maxSize;
        }
    }

    private static class CloseableStream {
        private File relatedFile;
        private FileOutputStream fos;
        private PrintStream pStream;

        private CloseableStream(File relatedFile, FileOutputStream fos, PrintStream pStream) {
            this.relatedFile = relatedFile;
            this.fos = fos;
            this.pStream = pStream;
        }

        public File getRelatedFile() {
            return this.relatedFile;
        }

        public void setRelatedFile(File relatedFile) {
            this.relatedFile = relatedFile;
        }

        public FileOutputStream getFos() {
            return this.fos;
        }

        public void setFos(FileOutputStream fos) {
            this.fos = fos;
        }

        public PrintStream getpStream() {
            return this.pStream;
        }

        public void setpStream(PrintStream pStream) {
            this.pStream = pStream;
        }
    }
}

