/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.log.RTLogger;
import com.blixx.sa.VirtualSocket;
import com.blixx.shared.io.SDataInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class DelayedSDataInputStream
extends SDataInputStream {
    AtomicBoolean m_isClosed = new AtomicBoolean(false);
    AtomicBoolean m_ready = new AtomicBoolean(false);
    Object m_lock = new Object();
    VirtualSocket m_parent = null;
    long timeoutTime = Long.MAX_VALUE;

    public DelayedSDataInputStream(VirtualSocket parent) {
        this.m_parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputStream(InputStream is) {
        if (!this.m_isClosed.get()) {
            this.setIS(is);
            this.m_ready.set(true);
            Object object = this.m_lock;
            synchronized (object) {
                this.m_lock.notifyAll();
            }
        } else {
            throw new RuntimeException("Stream is closed");
        }
    }

    public void detachInputSteam() {
        try {
            this.stream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_ready.compareAndSet(true, false);
        this.m_isClosed.compareAndSet(true, false);
        this.stream = null;
    }

    @Override
    public int available() throws IOException {
        if (this.stream == null) {
            return 0;
        }
        return super.available();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            super.close();
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.m_isClosed.compareAndSet(false, true);
        Object object = this.m_lock;
        synchronized (object) {
            this.m_lock.notifyAll();
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int read() throws IOException {
        this.waitReady();
        return super.read();
    }

    public void setTimeoutTime(long stopWaitingTime) {
        this.timeoutTime = stopWaitingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitReady() throws IOException {
        this.m_parent.setState(1);
        while (!this.m_ready.get() && !this.m_isClosed.get()) {
            Object object = this.m_lock;
            synchronized (object) {
                try {
                    this.m_lock.wait(500L);
                    if (System.currentTimeMillis() > this.timeoutTime) {
                        throw new SocketTimeoutException("Timeout reached");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public int read(byte[] v) throws IOException {
        this.waitReady();
        return super.read(v);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.waitReady();
        return super.readBoolean();
    }

    @Override
    public char readChar() throws IOException {
        this.waitReady();
        return super.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        this.waitReady();
        return super.readDouble();
    }

    @Override
    public boolean readFile(String fullPath) throws IOException {
        String dir;
        File fdir;
        this.waitReady();
        boolean success = true;
        fullPath = fullPath.replace('\\', '/');
        if (fullPath.indexOf(47) != -1 && !(fdir = new File(dir = fullPath.substring(0, fullPath.lastIndexOf(47)))).exists() && !fdir.mkdirs()) {
            RTLogger.print(1, "error mkdirs " + dir);
            throw new FileNotFoundException("dir: " + dir);
        }
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(fullPath);
            bos = new BufferedOutputStream(fos);
            int blockSize = -1;
            int buffSize = 65536;
            byte[] inArr = new byte[buffSize];
            while ((blockSize = this.readInt()) > 0) {
                RTLogger.print(5, "Reading bytes: " + blockSize + " file: " + fullPath);
                if (blockSize != inArr.length) {
                    inArr = new byte[blockSize];
                }
                this.stream.readFully(inArr);
                bos.write(inArr);
                if (blockSize != buffSize) continue;
                this.m_parent.sendResponseNow();
                this.waitReady();
            }
        }
        catch (Throwable e) {
            success = false;
            RTLogger.print(5, "", e);
            throw new IOException(e.getMessage());
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Throwable blockSize) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable blockSize) {}
            }
        }
        return success;
    }

    @Override
    public byte[] readFileToNULL(String fullPath) throws IOException {
        this.waitReady();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] inArr = new byte[]{};
        try {
            int blockSize = -1;
            int buffSize = 65536;
            while ((blockSize = this.readInt()) != -1) {
                RTLogger.print(6, "/DEV/NULL:> Reading bytes: " + blockSize + " file: " + fullPath);
                inArr = new byte[blockSize];
                this.stream.readFully(inArr);
                baos.write(inArr, 0, blockSize);
                if (blockSize != buffSize) continue;
                this.m_parent.sendResponseNow();
                this.waitReady();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    @Override
    public void readFully(byte[] v) throws IOException {
        this.waitReady();
        super.readFully(v);
    }

    @Override
    public int readInt() throws IOException {
        this.waitReady();
        int i = super.readInt();
        return i;
    }

    @Override
    public long readLong() throws IOException {
        this.waitReady();
        return super.readLong();
    }

    @Override
    public String readUTF() throws IOException {
        this.waitReady();
        String str = super.readUTF();
        return str;
    }

    @Override
    public String readUTF(String defaultReturnValue) {
        try {
            this.waitReady();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.readUTF(defaultReturnValue);
    }

    public boolean isClosed() {
        return this.m_isClosed.get();
    }
}

