/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.shared.os.SystemUtils;
import com.blixx.shared.utils.StrUtils;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExecUtils {
    public static final String EMERGENCY_UNIX_PATH = "PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local:/usr/local/bin:/usr/local/sbin";
    public static final String EMERGENCY_WIN_PATH = "Path=%SystemRoot%;%SystemRoot%\\system32";
    public static final String EMERGENCY_UNIX_LDATH = "LD_LIBRARY_PATH=/lib:/usr/lib:/usr/share/lib";
    public static final int MAX_CHARS_TOREAD = 0x800000;
    private static String[] envp = null;
    Charset s_charset = Charset.defaultCharset();
    private static Charset m_win_charset;
    private static Map<String, String> envMap;
    private Map<InputStream, CharArrayWriter> m_tempBuffer = new HashMap<InputStream, CharArrayWriter>(3, 100.0f);
    private int m_totalBytes = 0;
    private static boolean isWindows;

    public static synchronized void addEnvVariable(String variable) {
        String[] nenvp = new String[envp.length + 1];
        System.arraycopy(envp, 0, nenvp, 0, envp.length);
        nenvp[ExecUtils.envp.length] = variable;
        envp = nenvp;
    }

    public static void setPATHForUnix() {
        StringBuilder sb = new StringBuilder();
        File root = new File("spi");
        if (root.exists() && root.isDirectory()) {
            ExecUtils.addSubDirs(sb, root);
            sb.append("spi");
            for (int i = 0; i < envp.length; ++i) {
                if (!envp[i].startsWith("PATH=") && !envp[i].startsWith("Path=") && !envp[i].startsWith("LD_LIBRARY_PATH=") && !envp[i].startsWith("java.library.path=")) continue;
                if (!envp[i].contains(sb)) {
                    ExecUtils.envp[i] = envp[i] + File.pathSeparatorChar + sb.toString();
                }
                RTLogger.print(3, "ENV>> " + envp[i]);
            }
        }
    }

    public static void addSubDirs(StringBuilder sb, File root) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        File[] files = root.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            try {
                String nn = files[i].getPath() + File.pathSeparatorChar;
                if (sb.indexOf(nn) == -1) {
                    sb.append(nn);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ExecUtils.addSubDirs(sb, files[i]);
        }
    }

    private ExecUtils() {
        if (SystemUtils.UNIX_WHO == 6) {
            String codePage = System.getProperty("os400.job.file.encoding");
            try {
                this.s_charset = Charset.forName(codePage);
            }
            catch (Throwable e) {
                RTLogger.print(1, "Error init charset: " + codePage);
            }
        }
    }

    public static synchronized Process execRuntime(String cmd) throws IOException {
        cmd = cmd.trim();
        return Runtime.getRuntime().exec(cmd);
    }

    public static synchronized Process execRuntime(String[] cmd) throws IOException {
        return Runtime.getRuntime().exec(cmd);
    }

    public static ExecResult exec2(String cmd, File workingDir, int seconds) throws IOException {
        if (workingDir == null) {
            workingDir = new File(".");
        }
        cmd = cmd.trim();
        RTLogger.print(3, "Exec: " + cmd);
        ExecResult result = new ExecUtils().exec2(cmd, SystemUtils.OS, workingDir, seconds);
        return result;
    }

    ExecResult exec2(String cmd, int os, File workingDir, int seconds) throws IOException {
        if (cmd == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (os) {
            case 1: {
                return this.execWindows2(cmd, workingDir, seconds);
            }
            case 2: {
                return this.execUnix2(cmd, workingDir, seconds);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ExecResult execUnix2(String cmd, File workingDir, int seconds) throws IOException {
        InputStreamReader in = null;
        InputStreamReader err = null;
        InputStream errorStream = null;
        InputStream inputStream = null;
        ExecResult result = new ExecResult();
        Process pr = null;
        StrUtils su = new StrUtils();
        Object[] inCMD = su.processQuoted(cmd);
        for (int i = 0; i < inCMD.length; ++i) {
            inCMD[i] = su.removeQuotes(inCMD[i]);
        }
        RTLogger.print(5, "Exec recon3: " + Arrays.toString(inCMD));
        long startTime = System.currentTimeMillis();
        long maxWaitTime = startTime + (long)(seconds * 1000);
        try {
            pr = Runtime.getRuntime().exec((String[])inCMD, envp, workingDir);
            errorStream = pr.getErrorStream();
            inputStream = pr.getInputStream();
            err = new InputStreamReader(errorStream, this.s_charset);
            in = new InputStreamReader(inputStream, this.s_charset);
            this.readResults(in, err, errorStream, inputStream, result);
        }
        catch (Throwable e) {
            if (pr == null) {
                maxWaitTime = 0L;
                result.resultCode = 1;
                result.m_errorMessages.add("Error executing command: " + cmd);
                ExecResult execResult = result;
                return execResult;
            }
        }
        finally {
            block228: {
                block227: {
                    CharArrayWriter caw2;
                    long sec = 0L;
                    while (System.currentTimeMillis() < maxWaitTime) {
                        if (sec != (maxWaitTime - System.currentTimeMillis()) / 1000L) {
                            sec = (maxWaitTime - System.currentTimeMillis()) / 1000L;
                            RTLogger.print(5, "Exec: seconds to wait=" + (maxWaitTime - System.currentTimeMillis()) / 1000L);
                        }
                        result.resultCode = pr.exitValue();
                        this.readTillEnd(in, err, inputStream, errorStream, result);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                        catch (IllegalThreadStateException exc22) {
                            RTLogger.print(5, Arrays.toString(inCMD) + " process still running");
                            this.readDuringRun(in, err, errorStream, inputStream, result);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException exc22) {}
                            continue;
                        }
                        catch (Throwable exc22) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException exc22) {}
                            continue;
                            {
                                catch (Throwable throwable) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    throw throwable;
                                }
                            }
                        }
                    }
                    if (maxWaitTime > 0L && System.currentTimeMillis() >= maxWaitTime) {
                        result.resultCode = Integer.MAX_VALUE;
                        RTLogger.print(5, Arrays.toString(inCMD) + "Process has been not finished. Timeout reached");
                    }
                    try {
                        caw2 = this.m_tempBuffer.get(errorStream);
                        if (caw2 != null && caw2.size() > 0) {
                            result.m_errorMessages.add(caw2.toString());
                        }
                    }
                    catch (Throwable caw2) {}
                    caw2 = this.m_tempBuffer.get(inputStream);
                    if (caw2 != null && caw2.size() > 0) {
                        result.m_outMessages.add(caw2.toString());
                    }
                    this.m_tempBuffer.clear();
                    if (in == null) break block227;
                    try {
                        in.close();
                    }
                    catch (Throwable caw22) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Throwable caw22) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable caw22) {}
                }
                if (errorStream != null) {
                    try {
                        errorStream.close();
                    }
                    catch (Throwable caw22) {}
                }
                if (pr != null && pr.getOutputStream() != null) {
                    try {
                        pr.getOutputStream().close();
                    }
                    catch (Throwable caw22) {}
                }
                break block228;
                catch (Throwable caw22) {
                    this.m_tempBuffer.clear();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable caw22) {}
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable caw22) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable caw22) {}
                    }
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable caw22) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable caw22) {}
                    }
                    catch (Throwable throwable) {
                        this.m_tempBuffer.clear();
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {}
                        }
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (Throwable throwable3) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {}
                        }
                        if (errorStream != null) {
                            try {
                                errorStream.close();
                            }
                            catch (Throwable throwable5) {}
                        }
                        if (pr != null && pr.getOutputStream() != null) {
                            try {
                                pr.getOutputStream().close();
                            }
                            catch (Throwable throwable6) {}
                        }
                        throw throwable;
                    }
                }
            }
        }
        return result;
    }

    private void readDuringRun(InputStreamReader in, InputStreamReader err, InputStream errorStream, InputStream inputStream, ExecResult result) throws IOException {
        this.readInputStream(err, errorStream, result.m_errorMessages);
        this.readInputStream(in, inputStream, result.m_outMessages);
    }

    private void readTillEnd(InputStreamReader in, InputStreamReader err, InputStream inIS, InputStream errIS, ExecResult result) {
        try {
            this.readInputStreamTillEnd(err, errIS, result.m_errorMessages);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.readInputStreamTillEnd(in, inIS, result.m_outMessages);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void readResults(InputStreamReader in, InputStreamReader err, InputStream errorStream, InputStream inputStream, ExecResult result) throws IOException {
        if (!in.ready() && !err.ready()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.readInputStream(err, errorStream, result.m_errorMessages);
        this.readInputStream(in, inputStream, result.m_outMessages);
    }

    private void readInputStream(InputStreamReader isr, InputStream is, List<String> output) throws IOException {
        if (isr == null) {
            return;
        }
        char[] arr = new char[1024];
        int count = 0;
        if (!isr.ready()) {
            return;
        }
        CharArrayWriter caw = this.m_tempBuffer.get(is);
        if (caw == null) {
            caw = new CharArrayWriter(1024);
            this.m_tempBuffer.put(is, caw);
        }
        while (is.available() > 0 && (count = isr.read(arr)) > 0) {
            if (this.m_totalBytes >= 0x800000) continue;
            for (int i = 0; i < count; ++i) {
                char ch = arr[i];
                if ('\r' == ch) continue;
                if ('\n' == ch) {
                    String line = caw.toString();
                    output.add(line);
                    caw.reset();
                    RTLogger.print(6, '\t' + line);
                    continue;
                }
                caw.append(ch);
                ++this.m_totalBytes;
            }
        }
    }

    private void readInputStreamTillEnd(InputStreamReader isr, InputStream is, List<String> output) throws IOException {
        if (isr == null) {
            return;
        }
        char[] arr = new char[1024];
        int count = 0;
        if (isr != null && !isr.ready()) {
            return;
        }
        CharArrayWriter caw = this.m_tempBuffer.get(is);
        if (caw == null) {
            caw = new CharArrayWriter(1024);
            this.m_tempBuffer.put(is, caw);
        }
        while ((count = isr.read(arr)) != -1) {
            if (this.m_totalBytes >= 0x800000) continue;
            for (int i = 0; i < count; ++i) {
                char ch = arr[i];
                if ('\r' == ch) continue;
                if ('\n' == ch) {
                    String line = caw.toString();
                    output.add(line);
                    caw.reset();
                    RTLogger.print(6, '\t' + line);
                    continue;
                }
                caw.append(ch);
                ++this.m_totalBytes;
            }
        }
        if (caw.size() > 0) {
            output.add(caw.toString());
            caw.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecResult execWindows2(String cmd, File workingDir, int sec) throws IOException {
        CharArrayWriter caw2;
        int seconds = sec;
        String[] cmdAttrbs = new String[]{"cmd.exe", "/C", cmd};
        StrUtils su = new StrUtils();
        String[] arrPrg = su.processQuoted(cmd);
        if (arrPrg != null && arrPrg.length > 0) {
            String programm = su.removeQuotesStrict(arrPrg[0]);
            String prgLowerCase = (programm = programm.replace("\"", "")).toLowerCase();
            if (prgLowerCase.endsWith(".exe") || prgLowerCase.endsWith(".com") || prgLowerCase.endsWith(".application") || prgLowerCase.endsWith(".gadget")) {
                File prg = new File(workingDir, programm);
                if (prg.exists() && prg.isFile() && prg.length() == 0L) {
                    throw new IOException("Can't start application. It's a zero-size file: " + programm);
                }
                prg = new File(programm);
                if (prg.exists() && prg.isFile() && prg.length() == 0L) {
                    throw new IOException("Can't start application. It's a zero-size file: " + programm);
                }
            }
        }
        InputStreamReader in = null;
        InputStreamReader err = null;
        ExecResult result = new ExecResult();
        Process pr = null;
        InputStream errorStream = null;
        InputStream inputStream = null;
        long startTime = System.currentTimeMillis();
        long maxWaitTime = startTime + (long)(seconds * 1000);
        pr = Runtime.getRuntime().exec(cmdAttrbs, envp, workingDir);
        errorStream = pr.getErrorStream();
        inputStream = pr.getInputStream();
        if (m_win_charset != null) {
            in = new InputStreamReader(inputStream, m_win_charset);
            err = new InputStreamReader(errorStream, m_win_charset);
        } else {
            in = new InputStreamReader(inputStream);
            err = new InputStreamReader(errorStream);
        }
        this.readResults(in, err, errorStream, inputStream, result);
        while (System.currentTimeMillis() < maxWaitTime) {
            try {
                result.resultCode = pr.exitValue();
                this.readTillEnd(in, err, inputStream, errorStream, result);
                break;
            }
            catch (IllegalThreadStateException exc) {
                this.readDuringRun(in, err, errorStream, inputStream, result);
            }
            catch (Throwable exc) {}
            continue;
            finally {
                --seconds;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException exc) {}
            }
        }
        if (maxWaitTime != 0L && System.currentTimeMillis() >= maxWaitTime) {
            result.resultCode = 1;
            String error = "Timeout! Process has been not finished in specified " + sec + " seconds.";
            result.m_errorMessages.add(error);
            RTLogger.print(5, error);
        }
        try {
            caw2 = this.m_tempBuffer.get(errorStream);
            if (caw2 != null && caw2.size() > 0) {
                result.m_errorMessages.add(caw2.toString());
            }
        }
        catch (Throwable caw2) {
            // empty catch block
        }
        try {
            caw2 = this.m_tempBuffer.get(inputStream);
            if (caw2 == null || caw2.size() <= 0) return result;
            result.m_outMessages.add(caw2.toString());
            return result;
        }
        catch (Throwable caw3) {
            return result;
        }
        finally {
            this.m_tempBuffer.clear();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable caw3) {}
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Throwable caw3) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable caw3) {}
            }
            if (errorStream != null) {
                try {
                    errorStream.close();
                }
                catch (Throwable caw3) {}
            }
            if (pr != null && pr.getOutputStream() != null) {
                try {
                    pr.getOutputStream().close();
                }
                catch (Throwable caw3) {}
            }
        }
        catch (Throwable e) {
            CharArrayWriter caw42;
            block251: {
                CharArrayWriter caw52;
                if (pr != null) break block251;
                maxWaitTime = 0L;
                result.resultCode = 1;
                result.m_errorMessages.add("Exec cannot create a Process object.");
                ExecResult execResult = result;
                while (System.currentTimeMillis() < maxWaitTime) {
                    try {
                        result.resultCode = pr.exitValue();
                        this.readTillEnd(in, err, inputStream, errorStream, result);
                        break;
                    }
                    catch (IllegalThreadStateException exc) {
                        this.readDuringRun(in, err, errorStream, inputStream, result);
                    }
                    catch (Throwable exc) {}
                    continue;
                    finally {
                        --seconds;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException exc) {}
                    }
                }
                if (maxWaitTime != 0L && System.currentTimeMillis() >= maxWaitTime) {
                    result.resultCode = 1;
                    String error = "Timeout! Process has been not finished in specified " + sec + " seconds.";
                    result.m_errorMessages.add(error);
                    RTLogger.print(5, error);
                }
                try {
                    caw52 = this.m_tempBuffer.get(errorStream);
                    if (caw52 != null && caw52.size() > 0) {
                        result.m_errorMessages.add(caw52.toString());
                    }
                }
                catch (Throwable caw52) {
                    // empty catch block
                }
                try {
                    caw52 = this.m_tempBuffer.get(inputStream);
                    if (caw52 == null || caw52.size() <= 0) return execResult;
                    result.m_outMessages.add(caw52.toString());
                    return execResult;
                }
                catch (Throwable throwable) {
                    return execResult;
                }
                finally {
                    this.m_tempBuffer.clear();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            RTLogger.print(5, "Exec failed. ", e);
            while (System.currentTimeMillis() < maxWaitTime) {
                try {
                    result.resultCode = pr.exitValue();
                    this.readTillEnd(in, err, inputStream, errorStream, result);
                    break;
                }
                catch (IllegalThreadStateException exc) {
                    this.readDuringRun(in, err, errorStream, inputStream, result);
                }
                catch (Throwable exc) {}
                continue;
                finally {
                    --seconds;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException exc) {}
                }
            }
            if (maxWaitTime != 0L && System.currentTimeMillis() >= maxWaitTime) {
                result.resultCode = 1;
                String error = "Timeout! Process has been not finished in specified " + sec + " seconds.";
                result.m_errorMessages.add(error);
                RTLogger.print(5, error);
            }
            try {
                caw42 = this.m_tempBuffer.get(errorStream);
                if (caw42 != null && caw42.size() > 0) {
                    result.m_errorMessages.add(caw42.toString());
                }
            }
            catch (Throwable caw42) {
                // empty catch block
            }
            try {
                caw42 = this.m_tempBuffer.get(inputStream);
                if (caw42 == null || caw42.size() <= 0) return result;
                result.m_outMessages.add(caw42.toString());
                return result;
            }
            catch (Throwable throwable) {
                return result;
            }
            finally {
                this.m_tempBuffer.clear();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (errorStream != null) {
                    try {
                        errorStream.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (pr != null && pr.getOutputStream() != null) {
                    try {
                        pr.getOutputStream().close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                CharArrayWriter caw62;
                while (System.currentTimeMillis() < maxWaitTime) {
                    try {
                        result.resultCode = pr.exitValue();
                        this.readTillEnd(in, err, inputStream, errorStream, result);
                        break;
                    }
                    catch (IllegalThreadStateException exc) {
                        this.readDuringRun(in, err, errorStream, inputStream, result);
                    }
                    catch (Throwable exc) {}
                    continue;
                    finally {
                        --seconds;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException exc) {}
                    }
                }
                if (maxWaitTime != 0L && System.currentTimeMillis() >= maxWaitTime) {
                    result.resultCode = 1;
                    String error = "Timeout! Process has been not finished in specified " + sec + " seconds.";
                    result.m_errorMessages.add(error);
                    RTLogger.print(5, error);
                }
                try {
                    caw62 = this.m_tempBuffer.get(errorStream);
                    if (caw62 != null && caw62.size() > 0) {
                        result.m_errorMessages.add(caw62.toString());
                    }
                }
                catch (Throwable caw62) {
                    // empty catch block
                }
                try {
                    caw62 = this.m_tempBuffer.get(inputStream);
                    if (caw62 == null || caw62.size() <= 0) throw throwable;
                    result.m_outMessages.add(caw62.toString());
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throw throwable;
                }
                finally {
                    this.m_tempBuffer.clear();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {}
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable throwable4) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable5) {}
                    }
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable throwable6) {}
                    }
                    if (pr != null && pr.getOutputStream() != null) {
                        try {
                            pr.getOutputStream().close();
                        }
                        catch (Throwable throwable7) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getWindowsConsoleCharset() {
        String charset = "Cp850";
        String[] cmdAttrbs = new String[]{"cmd.exe", "/C", "chcp"};
        BufferedReader in = null;
        Process pr = null;
        InputStream inputStream = null;
        try {
            Pattern cp = Pattern.compile(".*\\s+(\\d+).*");
            pr = Runtime.getRuntime().exec(cmdAttrbs);
            inputStream = pr.getInputStream();
            in = new BufferedReader(new InputStreamReader(inputStream));
            String lineR = null;
            while ((lineR = in.readLine()) != null) {
                Matcher m = cp.matcher(lineR);
                if (!m.matches()) continue;
                String cpage = m.group(1);
                int c = Integer.parseInt(cpage);
                String charsetTemp = "Cp" + c;
                try {
                    m_win_charset = Charset.forName(charsetTemp);
                    charset = charsetTemp;
                    RTLogger.print(3, "console charset: " + charset);
                    return charset;
                }
                catch (Throwable e) {
                    File cFile = new File("charsets.jar");
                    if (!cFile.exists() && !(cFile = new File("spi/charsets.jar")).exists()) {
                        cFile = new File("spi/jars/charsets.jar");
                    }
                    URLClassLoader urlcl = null;
                    try {
                        URL[] urls = new URL[]{cFile.toURI().toURL()};
                        urlcl = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
                        Class<?> epc = urlcl.loadClass("sun.nio.cs.ext.ExtendedCharsets");
                        CharsetProvider extendedProvider = (CharsetProvider)epc.newInstance();
                        m_win_charset = extendedProvider.charsetForName(charsetTemp);
                        return charset;
                    }
                    catch (Throwable e1) {
                        RTLogger.print(2, "Error getting actual console charset decoder: " + charsetTemp);
                        throw e;
                    }
                    finally {
                        if (urlcl != null) {
                            try {
                                urlcl.close();
                            }
                            catch (Throwable urls) {}
                        }
                        return charset;
                    }
                }
            }
        }
        catch (Throwable e) {
            try {
                m_win_charset = Charset.forName(charset);
                RTLogger.print(2, "Error getting actual console charset. Using default: " + charset);
                return charset;
            }
            catch (Throwable e2) {
                String javaHome = System.getProperty("java.home");
                RTLogger.print(1, "JRE has not installed support for additional languages. ");
                RTLogger.print(1, "Missed " + javaHome + "\\libs\\charsets.jar");
                m_win_charset = Charset.defaultCharset();
                if (m_win_charset != null) {
                    RTLogger.print(1, "Using java default codepage for external binaries: " + m_win_charset.name());
                    return charset;
                }
                RTLogger.print(1, "Default charset is NULL!!!");
            }
            return charset;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable cp) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable cp) {}
            }
            if (pr != null && pr.getOutputStream() != null) {
                try {
                    pr.getOutputStream().close();
                }
                catch (Throwable cp) {}
            }
        }
    }

    public static Charset getDefaultCharset() {
        return m_win_charset;
    }

    public static Map<String, String> getEnvMap() {
        return envMap;
    }

    public static String[] getEnvp() {
        return envp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        envMap = new HashMap<String, String>();
        isWindows = false;
        Class<ExecUtils> clazz = ExecUtils.class;
        synchronized (ExecUtils.class) {
            for (Map.Entry<Object, Object> en : System.getProperties().entrySet()) {
                if (en.getKey() == null || en.getValue() == null || !(en.getValue() instanceof String) || !(en.getKey() instanceof String)) continue;
                envMap.put((String)en.getKey(), (String)en.getValue());
            }
            envMap.putAll(System.getenv());
            Iterator<String> it0 = envMap.keySet().iterator();
            while (it0.hasNext()) {
                String name = it0.next();
                if (!name.startsWith("java.") && !name.startsWith("sun.") && !name.startsWith("awt.")) continue;
                it0.remove();
            }
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            String osName = System.getProperty("os.name");
            if (osName != null && osName.toLowerCase().contains("windows")) {
                isWindows = true;
            }
            if (!isWindows) {
                envp = new String[envMap.size() + 1];
                ExecUtils.envp[ExecUtils.envMap.size()] = "UNIX95=1";
            } else {
                envp = new String[envMap.size()];
                ExecUtils.getWindowsConsoleCharset();
                if (m_win_charset == null) {
                    RTLogger.print(2, "CHARSET can't be detected");
                }
            }
            int i = 0;
            boolean pathFound = false;
            boolean ldPathFound = false;
            for (String name : envMap.keySet()) {
                if ("PATH".equalsIgnoreCase(name)) {
                    pathFound = true;
                }
                if ("LD_LIBRARY_PATH".equalsIgnoreCase(name)) {
                    ldPathFound = true;
                }
                ExecUtils.envp[i] = name + "=" + envMap.get(name);
                RTLogger.print(3, "ENV>> " + envp[i]);
                ++i;
            }
            if (!pathFound) {
                if (!isWindows) {
                    ExecUtils.addEnvVariable(EMERGENCY_UNIX_PATH);
                } else {
                    ExecUtils.addEnvVariable(EMERGENCY_WIN_PATH);
                }
            }
            if (!ldPathFound && !isWindows) {
                ExecUtils.addEnvVariable(EMERGENCY_UNIX_LDATH);
            }
            ExecUtils.setPATHForUnix();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

