/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.sa.SchedulerThreadPoolExecutor;
import com.blixx.sa.ThreadGroup;
import com.blixx.shared.BM;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Scheduler
implements Runnable {
    private final AtomicBoolean m_isActive = new AtomicBoolean(true);
    private final AtomicBoolean m_isRunning = new AtomicBoolean(true);
    private AtomicBoolean m_isStopped = null;
    private final ThreadGroup m_internalGroup = new ThreadGroup("Other");
    private final ThreadGroup m_monitorsGroup = new ThreadGroup("ALL");
    private final ThreadGroup m_javaMonGroup = new ThreadGroup("JavaMonitors");
    private final SortedMap<String, SchedulerTask> m_threadPool = Collections.synchronizedSortedMap(new TreeMap());
    private final Map<String, String> m_taskMap = new ConcurrentHashMap<String, String>();
    public static final String INTERNAL = "__@@INTERNAL";
    private final Object m_lock = new Object();
    private ThreadPoolExecutor m_executor = new SchedulerThreadPoolExecutor(0, 10000, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    public Long m_systemTimeForTests = null;

    public Scheduler() {
    }

    public Scheduler(int maxAllowed) {
        this();
        this.m_internalGroup.setMaximum(500);
        this.m_javaMonGroup.setMaximum(maxAllowed);
        this.m_monitorsGroup.setMaximum(maxAllowed);
    }

    public void repeatMe(SchedulerTask task) {
        RTLogger.print(1, "WARNING! System runs out of free handles for new Processes.");
        RTLogger.print(1, "Task " + task.getName() + " will be re-scheduled");
        this.removeTask(task.getName());
        this.addTask(task, 0L);
    }

    public List<String> getScheduledTasks() {
        return new LinkedList<String>(this.m_taskMap.keySet());
    }

    public boolean hasTask(String name) {
        boolean isExist = false;
        String curentKey = this.m_taskMap.get(name);
        if (curentKey != null) {
            isExist = this.m_threadPool.containsKey(curentKey);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(SchedulerTask task) {
        int type = task.getIntervalObj().m_type.get();
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        cal.setTimeInMillis(this.getCurrentMilliseconds());
        boolean isDLT = tz.inDaylightTime(cal.getTime());
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        switch (type) {
            case 2: {
                cal.set(11, 0);
                break;
            }
            case 3: {
                cal.set(11, 0);
                cal.set(7, 2);
                break;
            }
            case 5: {
                cal.set(11, 0);
                cal.set(5, 1);
                break;
            }
        }
        boolean isDLT_2 = tz.inDaylightTime(cal.getTime());
        cal.add(13, task.getIntervalObj().getShiftSeconds());
        if (isDLT != isDLT_2) {
            if (isDLT_2) {
                cal.add(12, 60);
                isDLT_2 = false;
            } else {
                cal.add(12, -60);
                isDLT_2 = true;
            }
        }
        boolean isDLTplanned = tz.inDaylightTime(cal.getTime());
        this.setThreadGroup(task);
        long firstStart = cal.getTimeInMillis();
        while (firstStart < this.getCurrentMilliseconds()) {
            cal.setTimeInMillis(firstStart += task.getInterval());
            isDLTplanned = tz.inDaylightTime(cal.getTime());
        }
        if (type != 1 && isDLT_2 != isDLTplanned) {
            firstStart = !isDLTplanned ? (firstStart += 3600000L) : (firstStart -= 3600000L);
        }
        this.putTask(task, task.getInterval(), firstStart);
        if (RTLogger.getCurrentLevel() >= 3) {
            String msg = "Added new fixed time task " + task + " to the Scheduler, next run: " + new Date(firstStart) + " type=" + type;
            RTLogger.print(3, msg);
        }
        Object object = this.m_lock;
        synchronized (object) {
            try {
                this.m_lock.notifyAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTask(SchedulerTask task, long vTime) {
        if (task.getIntervalObj().getType() != 0) {
            this.addTask(task);
        } else {
            long nextRun;
            long interval = task.getInterval();
            if (interval == 0L && vTime == 0L) {
                if (RTLogger.getCurrentLevel() >= 3) {
                    RTLogger.print(3, task + " was not scheduled. Interval=" + interval);
                }
                return;
            }
            if (vTime == 0L) {
                nextRun = task.getName().contains(INTERNAL) ? this.getCurrentMilliseconds() + interval + 10L * (long)this.m_taskMap.size() : this.getCurrentMilliseconds() + interval + (long)(this.m_taskMap.size() / 10) * 200L;
                if (RTLogger.getCurrentLevel() >= 3) {
                    Date d = new Date(nextRun);
                    String msg = "Add new " + task + " to the Scheduler, next run: " + BM.m_sdf.format(d) + "\nCurrent thread poll size:" + this.m_taskMap.size();
                    RTLogger.print(3, msg);
                }
            } else {
                for (nextRun = vTime + interval; nextRun < this.getCurrentMilliseconds(); nextRun += interval) {
                }
            }
            this.setThreadGroup(task);
            this.putTask(task, interval, nextRun);
            Object object = this.m_lock;
            synchronized (object) {
                try {
                    this.m_lock.notifyAll();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void setThreadGroup(SchedulerTask task) {
        if (!task.getName().contains(INTERNAL)) {
            if (task.getType() > 0) {
                task.setThreadGroup(this.m_javaMonGroup);
            } else {
                task.setThreadGroup(this.m_monitorsGroup);
            }
        } else {
            task.setThreadGroup(this.m_internalGroup);
        }
    }

    public long getNextRunScheduled(String taskName) {
        String key = this.m_taskMap.get(taskName);
        if (key == null) {
            return 0L;
        }
        long res = -1L;
        try {
            res = Long.parseLong(key.substring(0, key.indexOf(95)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    private void putTask(SchedulerTask task, long interval, long nextRun) {
        String checkOldKey;
        if (interval > 0L) {
            task.clearStopFlag();
        }
        if ((checkOldKey = this.m_taskMap.get(task.getName())) != null) {
            this.m_threadPool.remove(checkOldKey);
        }
        String key = nextRun + "_" + task.getName();
        this.m_threadPool.put(key, task);
        this.m_taskMap.put(task.getName(), key);
        if (RTLogger.getCurrentLevel() > 6) {
            String msg = "next turn for " + task.getName() + " Interval=" + interval + " : " + new Date(nextRun);
            RTLogger.print(9, msg);
        }
    }

    public boolean removeTask(String ID) {
        String currentKey = this.m_taskMap.remove(ID);
        if (currentKey == null) {
            return true;
        }
        SchedulerTask task = (SchedulerTask)this.m_threadPool.remove(currentKey);
        if (task == null) {
            return true;
        }
        if (task.stopTask()) {
            RTLogger.print(3, "Task " + task.getName() + " was stopped.");
        } else {
            RTLogger.print(2, "Unable to stop task:" + task.getName());
        }
        if (RTLogger.getCurrentLevel() >= 3) {
            String msg = task + " was removed from Scheduler.\nCurrent thread poll size:" + this.m_taskMap.size();
            RTLogger.print(3, msg);
        }
        return true;
    }

    public SchedulerTask getTask(String ID) {
        String currentKey = this.m_taskMap.get(ID);
        if (currentKey == null) {
            return null;
        }
        return (SchedulerTask)this.m_threadPool.get(currentKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.m_isStopped = new AtomicBoolean(false);
            this.m_isRunning.set(true);
            while (this.m_isRunning.get()) {
                String key;
                if (this.m_threadPool.isEmpty()) {
                    Object object = this.m_lock;
                    synchronized (object) {
                        try {
                            this.m_lock.wait(1000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!this.m_isRunning.get()) {
                            break;
                        }
                        continue;
                    }
                }
                try {
                    key = this.m_threadPool.firstKey();
                }
                catch (NoSuchElementException ex) {
                    continue;
                }
                long first = Long.parseLong(key.substring(0, key.indexOf("_")));
                long deltaCurrent = first - this.getCurrentMilliseconds();
                if (deltaCurrent > 1L) {
                    Object object = this.m_lock;
                    synchronized (object) {
                        try {
                            this.m_lock.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (!this.m_isRunning.get()) {
                            break;
                        }
                        continue;
                    }
                }
                SchedulerTask task = (SchedulerTask)this.m_threadPool.get(key);
                if (task == null || !this.m_taskMap.containsKey(task.getName())) {
                    this.m_threadPool.remove(key);
                    continue;
                }
                if (task.isStopped() || task.getInterval() <= 0L) {
                    if (task.getInterval() == 0L) {
                        try {
                            this.runTask(task);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.removeTask(task.getName());
                    continue;
                }
                if (task.isRunning()) {
                    if (!task.iCanRunLongerThanScheduleInterval() && RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, task + " is busy. This turn skipped.");
                    }
                    this.m_threadPool.remove(key);
                    this.addTask(task, first);
                    continue;
                }
                try {
                    long delay = this.runTask(task);
                    this.m_threadPool.remove(key);
                    this.addTask(task, first);
                }
                catch (OutOfMemoryError e) {
                    RTLogger.print(2, "", e);
                    this.m_threadPool.remove(key);
                    this.addTask(task, first);
                }
                catch (NoMoreSlots e) {
                    RTLogger.print(4, e.getMessage());
                    this.m_threadPool.remove(key);
                    this.addTask(task, first + 33L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    RTLogger.print(5, "", e);
                    this.m_threadPool.remove(key);
                    this.addTask(task, first);
                }
            }
        }
        catch (Throwable tr) {
            if (this.m_isRunning.get()) {
                RTLogger.print(1, "Unexpected stop of Scheduler.", tr);
            }
        }
        finally {
            if (this.m_isStopped == null) {
                new AtomicBoolean(true);
            } else {
                this.m_isStopped.compareAndSet(false, true);
            }
            RTLogger.print(2, "Scheduler stopped");
        }
    }

    private long runTask(SchedulerTask task) throws InterruptedException {
        int tries;
        ThreadGroup ourGroup;
        long delay = 0L;
        if (task.getName().contains(INTERNAL)) {
            ourGroup = this.m_internalGroup;
        } else if (task.getType() > 0) {
            if (!this.m_isActive.get()) {
                return delay;
            }
            ourGroup = this.m_javaMonGroup;
        } else {
            if (!this.m_isActive.get()) {
                return delay;
            }
            ourGroup = this.m_monitorsGroup;
        }
        for (tries = 0; tries < 4 && ourGroup.getActiveCount() > ourGroup.getMaximum(); ++tries) {
            try {
                delay += 100L;
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (tries == 4) {
            throw new NoMoreSlots("All slots are busy. Maximum number of running processes: " + ourGroup.getMaximum());
        }
        boolean started = false;
        do {
            try {
                this.m_executor.execute(task);
                started = true;
            }
            catch (RejectedExecutionException e) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } while (!started);
        return delay;
    }

    public void refresh() {
        ArrayList<SchedulerTask> tasks = new ArrayList<SchedulerTask>(this.m_threadPool.values());
        for (SchedulerTask task : tasks) {
            task.refresh();
        }
    }

    public boolean isStopped() {
        return this.m_isStopped == null || this.m_isStopped.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopScheduler() {
        this.m_isRunning.compareAndSet(true, false);
        Object object = this.m_lock;
        synchronized (object) {
            try {
                this.m_lock.notifyAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int countDown = 300;
        while (!this.isStopped() && --countDown > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        RTLogger.print(2, "Scheduler main thread is stopped. Start stopping tasks...");
        while (!this.m_threadPool.isEmpty()) {
            String key = this.m_threadPool.firstKey();
            SchedulerTask task = (SchedulerTask)this.m_threadPool.get(key);
            if (task.stopTask()) {
                RTLogger.print(2, "Task {" + task.getName() + "} was stopped by Scheduler.");
            } else {
                RTLogger.print(3, "Task {" + task.getName() + "} wasn't stopped by Scheduler.");
            }
            this.m_threadPool.remove(key);
        }
        this.m_executor.shutdownNow();
        RTLogger.print(2, "Scheduler stopped.");
        return this.isStopped();
    }

    public void clean() {
        this.m_taskMap.clear();
        this.m_threadPool.clear();
    }

    public int getSize() {
        return this.m_taskMap.size();
    }

    public long getCurrentMilliseconds() {
        return this.m_systemTimeForTests == null ? System.currentTimeMillis() : this.m_systemTimeForTests;
    }

    public String toString() {
        return "Scheduler";
    }

    public void deactivate() {
        if (this.m_isActive.compareAndSet(true, false)) {
            RTLogger.print(1, "Scheduler is deactivated");
        }
    }

    public void activate() {
        if (this.m_isActive.compareAndSet(false, true)) {
            if (this.m_executor == null || this.m_executor.isTerminated()) {
                this.m_executor = new SchedulerThreadPoolExecutor(0, 10000, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            }
            RTLogger.print(1, "Scheduler is activated");
        }
    }

    public static class NoMoreSlots
    extends RuntimeException {
        public NoMoreSlots(String message) {
            super(message);
        }
    }
}

