/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa.perf;

public class DDFField
implements Comparable {
    public static String VARCHAR = "VARCHAR";
    public static String BIGINT = "BIGINT";
    public static String DOUBLE = "DOUBLE";
    private String m_name;
    private String m_type = VARCHAR;
    private int m_size = 255;
    private int m_position;

    public DDFField(String name, int pos) {
        this.m_name = name;
        this.m_position = pos;
    }

    public String getName() {
        return this.m_name;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setType(String type) {
        if (type.equals("NUMBER")) {
            type = DOUBLE;
        } else if (type.equals("VARCHAR2")) {
            type = VARCHAR;
        }
        this.m_type = type;
        if (this.m_type.equals(BIGINT)) {
            this.m_size = 20;
        } else if (this.m_type.equals(DOUBLE)) {
            this.m_size = 0;
        }
    }

    public void setSize(int size) {
        this.m_size = this.m_type.equals(BIGINT) ? 20 : (this.m_type.equals(DOUBLE) ? 0 : size);
    }

    public String getType() {
        return this.m_type;
    }

    public int getSize() {
        return this.m_size;
    }

    public String toString() {
        String type = "";
        type = this.m_type.equals(BIGINT) ? "BIGINT(20)" : (this.m_type.equals(DOUBLE) ? DOUBLE : (this.m_type.equals(VARCHAR) ? VARCHAR + "(" + this.m_size + ")" : this.m_type + "(" + this.m_size + ")"));
        return "`" + this.m_name + "` " + type + " DEFAULT NULL";
    }

    public boolean equals(Object obj) {
        if (this.m_name == null || obj == null || !(obj instanceof DDFField)) {
            return false;
        }
        String n1 = this.m_name.replace("\"", "");
        n1 = n1.replace("`", "");
        String n2 = ((DDFField)obj).m_name.replace("\"", "");
        n2 = n2.replace("`", "");
        return n1.equalsIgnoreCase(n2);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof DDFField)) {
            return -1;
        }
        String n1 = this.m_name.replace("\"", "");
        n1 = n1.replace("`", "");
        String n2 = ((DDFField)o).m_name.replace("\"", "");
        n2 = n2.replace("`", "");
        return n1.compareToIgnoreCase(n2);
    }

    public int hashCode() {
        if (this.m_name == null) {
            return 0;
        }
        return this.m_name.hashCode();
    }
}

