/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.ext.ILookup;
import com.blixx.log.RTLogger;
import com.blixx.shared.IEnv;
import com.blixx.shared.PatternB;
import com.blixx.shared.exceptions.ConfigException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public abstract class AbstractCondition {
    public static final String OTHER_SEPARATOR = "@@";
    public static final String OTHER_MASK_ALL = "<*>@@<*>@@<*>@@<*>@@<*>@@";
    public static final String CONDITION_ID = "CONDITION_ID";
    public static final String DESCRIPTION = "C_DESCRIPTION";
    public static final String HELPTEXT = "HELPTEXT";
    public static final String HELPTEXT_ID = "HELPTEXT_ID";
    public static final String SET_SEVERITY = "SET_SEVERITY";
    public static final String SET_APPLICATION = "SET_APPLICATION";
    public static final String SET_OBJECT = "SET_OBJECT";
    public static final String SET_TEXT = "SET_TEXT";
    public static final String SET_MSGGRP = "SET_MSGGRP";
    public static final String SET_GROUP = "SET_GROUP";
    public static final String SET_NODE = "SET_NODE";
    public static final String SEVERITY = "SEVERITY";
    public static final String APPLICATION = "APPLICATION";
    public static final String OBJECT = "OBJECT";
    public static final String TEXT = "TEXT";
    public static final String MSGGRP = "MSGGRP";
    public static final String NODE = "NODE";
    public static final String _THRESHOLD = "THRESHOLD";
    public static final String _RESET = "RESET";
    public static final String _DURACTION = "DURATION";
    public static final String _KEY = "KEY";
    public static final String _INGORE_RESET = "IGNORE_RESET";
    public static final String _RESEND = "RESEND";
    public static final String SEND_FIRST = "SEND_FIRST";
    public static final String VFILTER = "VFILTER";
    public static final String MSGKEY = "MSGKEY";
    public static final String ACKKEY = "ACKKEY";
    public static final String NEGATION = "NEGATION";
    public static final String SUPP_TIME = "SUPP_TIME";
    public static final String SUPP_COUNT = "SUPP_COUNT";
    public static final String AUTOACTION = "AUTOACTION";
    public static final String AUTOACTIONNODE = "AUTOACTION_NODE";
    public static final String AUTOACTIONTIMEOUT = "AUTOACTION_TIMEOUT";
    public static final String AUTOACTIONONDUPLICATE = "AUTOACTION_ON_DUPLICATE";
    public static final String OPACTION = "OPACTION";
    public static final String MASK_ALL = "<*>";
    public static final String ACTIONTYPE = "ACTIONTYPE";
    public static final String SEND = "SEND";
    public static final String STOP = "STOP";
    public static final String INSERT_CLOSED = "INSERT_CLOSED";
    public static final String TYPE_A = "TYPE_A";
    public static final String TYPE_K = "TYPE_K";
    public static final String DEDUPL = "DEDUPL";
    public static final String DEDUPL_KEYONLY = "DEDUPL_KEYONLY";
    public static final String INSTRUCTION_ACTION = "INSTRUCTION_ACTION";
    protected String object = "";
    protected String set_node = "".intern();
    protected String set_object = "".intern();
    protected String set_application = "".intern();
    protected String set_msggrp = "".intern();
    protected String set_text = null;
    protected String description = null;
    protected String condition_id = null;
    protected int type_a = 0;
    protected int type_k = 0;
    protected String helptext = null;
    protected String helptext_id = null;
    protected String msgkey = null;
    protected String ackkey = null;
    protected boolean m_dedupl = true;
    protected boolean m_dedupl_keyOnly = false;
    protected int m_insertClosed = 0;
    protected String autoAction = null;
    protected String autoAction_Node = "";
    protected int autoActionTimeout = 120;
    protected int autoActionOnDuplicate = 0;
    protected String opAction = null;
    protected String actionType = null;
    protected String instructionAction = null;
    protected PatternB m_filter_obj = null;
    protected ArrayList<String> m_customAttributes = new ArrayList(15);

    public AbstractCondition() {
        this.condition_id = UUID.randomUUID().toString();
        this.msgkey = "".intern();
        this.ackkey = "".intern();
        this.opAction = "".intern();
        this.autoAction = "".intern();
        this.autoAction_Node = "".intern();
        this.helptext = "".intern();
        this.helptext_id = UUID.randomUUID().toString();
        this.object = MASK_ALL.intern();
        this.set_application = "".intern();
        this.set_msggrp = "".intern();
        this.set_object = "".intern();
        this.set_node = "".intern();
    }

    public ArrayList<String> getCustomAttributes() {
        return this.m_customAttributes;
    }

    protected void initCAs() {
        for (int i = 0; i < 15; ++i) {
            this.m_customAttributes.add("".intern());
        }
    }

    public abstract String getAsSourceString(String var1);

    public boolean isOverrideKey() {
        return this.msgkey != null && this.msgkey.length() > 0;
    }

    public boolean isOverrideCloseMask() {
        return this.ackkey != null && this.ackkey.length() > 0;
    }

    public boolean isOverrideNode() {
        return this.set_node != null && this.set_node.length() > 0;
    }

    public boolean isOverrideObject() {
        return this.set_object != null && this.set_object.length() > 0;
    }

    public boolean isOverrideApplication() {
        return this.set_application != null && this.set_application.length() > 0;
    }

    public boolean isOverrideGroup() {
        return this.set_msggrp != null && this.set_msggrp.length() > 0;
    }

    public boolean isOverrideText() {
        return this.set_text != null && this.set_text.length() > 0;
    }

    public void initCustomAttributes(Properties prop) {
        for (int i = 0; i < 15; ++i) {
            String ca = prop.getProperty("CA" + (i + 1));
            if (ca == null || ca.length() == 0 || ca.split("=").length == 1) {
                this.m_customAttributes.add("".intern());
                continue;
            }
            this.m_customAttributes.add(ca.intern());
        }
    }

    public void putCustomAttributes(Properties prop) {
        for (int i = 0; i < 15; ++i) {
            String ca = this.m_customAttributes.get(i);
            if (ca == null || ca.length() == 0 || ca.split("=").length == 1) {
                prop.setProperty("CA" + (i + 1), "");
                continue;
            }
            prop.setProperty("CA" + (i + 1), ca);
        }
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.setProperty(DESCRIPTION, this.description);
        p.setProperty(CONDITION_ID, this.condition_id);
        p.setProperty(HELPTEXT, this.helptext);
        p.setProperty(HELPTEXT_ID, this.helptext_id);
        p.setProperty(ACTIONTYPE, this.actionType);
        p.setProperty(AUTOACTION, this.autoAction);
        p.setProperty(AUTOACTIONNODE, this.autoAction_Node);
        p.setProperty(AUTOACTIONTIMEOUT, "" + this.autoActionTimeout);
        if (this.autoActionOnDuplicate != 0) {
            p.setProperty(AUTOACTIONONDUPLICATE, "" + this.autoActionOnDuplicate);
        }
        p.setProperty(OPACTION, this.opAction);
        p.setProperty(TYPE_A, "" + this.type_a);
        p.setProperty(TYPE_K, "" + this.type_k);
        if (this.instructionAction != null && this.instructionAction.length() > 0) {
            p.setProperty(INSTRUCTION_ACTION, this.instructionAction);
        }
        if (this.instructionAction != null && this.instructionAction.length() > 0) {
            p.setProperty(INSTRUCTION_ACTION, this.instructionAction);
        }
        p.setProperty(DEDUPL, "" + this.m_dedupl);
        if (this.m_dedupl_keyOnly) {
            p.setProperty(DEDUPL_KEYONLY, "true");
        }
        p.setProperty(INSERT_CLOSED, "" + this.m_insertClosed);
        p.setProperty(OBJECT, this.object);
        p.setProperty(ACKKEY, this.ackkey);
        p.setProperty(SET_NODE, this.set_node == null ? "" : this.set_node);
        p.setProperty(SET_OBJECT, this.set_object == null ? "" : this.set_object);
        p.setProperty(SET_APPLICATION, this.set_application == null ? "" : this.set_application);
        return p;
    }

    public void initFrom(Properties prop) {
        String insClosed;
        String aaOnDupl;
        String dedupl;
        String typeK;
        this.condition_id = (String)prop.get(CONDITION_ID);
        if (this.condition_id == null) {
            this.condition_id = UUID.randomUUID().toString();
        }
        this.description = prop.getProperty(DESCRIPTION, "");
        this.object = prop.getProperty(OBJECT, "".intern()).trim();
        if (this.object == null || this.object.length() == 0 || "*".equals(this.object)) {
            this.object = MASK_ALL.intern();
        } else {
            this.object = this.object.intern();
            if (this.checkPipe(this.object)) {
                this.object = '[' + this.object + ']';
                this.object = this.object.intern();
            }
        }
        try {
            this.m_filter_obj = PatternB.getPattern(this.object);
        }
        catch (ConfigException e) {
            RTLogger.print(1, "condition id: " + this.condition_id + " has unparsable Object regexp: " + this.object);
        }
        this.ackkey = prop.getProperty(ACKKEY, "").trim().intern();
        this.helptext = prop.getProperty(HELPTEXT, "").trim().intern();
        this.helptext_id = prop.getProperty(HELPTEXT_ID, "").trim().intern();
        this.msgkey = prop.getProperty(_KEY);
        if (this.msgkey == null) {
            this.msgkey = prop.getProperty(MSGKEY, "");
        }
        this.msgkey = this.msgkey.intern();
        this.set_application = prop.getProperty(SET_APPLICATION, "").intern();
        this.set_object = prop.getProperty(SET_OBJECT, "").intern();
        String setGroup = prop.getProperty(SET_GROUP);
        if (setGroup == null) {
            setGroup = prop.getProperty(SET_MSGGRP, "");
        }
        this.set_msggrp = setGroup;
        this.set_node = prop.getProperty(SET_NODE, "").intern();
        this.opAction = prop.getProperty(OPACTION, "").intern();
        this.actionType = prop.getProperty(ACTIONTYPE, SEND).intern();
        String typeA = prop.getProperty(TYPE_A);
        if (typeA != null) {
            try {
                this.type_a = Integer.parseInt(typeA);
            }
            catch (NumberFormatException e) {
                RTLogger.print(5, "typeA is not integer. CondID: " + this.condition_id);
            }
        }
        if ((typeK = prop.getProperty(TYPE_K)) != null) {
            try {
                this.type_k = Integer.parseInt(typeK);
            }
            catch (NumberFormatException e) {
                RTLogger.print(5, "typeK is not integer. CondID: " + this.condition_id);
            }
        }
        if ((dedupl = prop.getProperty(DEDUPL)) != null && dedupl.equalsIgnoreCase("FALSE")) {
            this.m_dedupl = false;
        }
        if ((dedupl = prop.getProperty(DEDUPL_KEYONLY)) != null && dedupl.equalsIgnoreCase("true")) {
            this.m_dedupl_keyOnly = true;
        }
        this.instructionAction = prop.getProperty(INSTRUCTION_ACTION, "").intern();
        this.autoAction = prop.getProperty(AUTOACTION, "").intern();
        this.autoAction_Node = prop.getProperty(AUTOACTIONNODE, "").intern();
        String aaTimeout = prop.getProperty(AUTOACTIONTIMEOUT);
        if (aaTimeout != null) {
            try {
                this.autoActionTimeout = Integer.parseInt(aaTimeout);
            }
            catch (NumberFormatException e) {
                RTLogger.print(5, "AutoActionTimeout is not integer. CondID: " + this.condition_id);
            }
        }
        if ((aaOnDupl = prop.getProperty(AUTOACTIONONDUPLICATE)) != null) {
            try {
                this.autoActionOnDuplicate = Integer.parseInt(aaOnDupl);
            }
            catch (NumberFormatException e) {
                RTLogger.print(5, "AUTOACTION_ON_DUPLICATE is not integer. CondID: " + this.condition_id);
            }
        }
        if ((insClosed = prop.getProperty(INSERT_CLOSED)) != null) {
            try {
                this.m_insertClosed = Integer.parseInt(insClosed);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.initCustomAttributes(prop);
    }

    public static Map<String, String> lookup(Map<String, String> variables, IEnv env) {
        if (env != null && env.getLookupServices() != null && env.getLookupServices().size() > 0) {
            try {
                HashMap<String, String> lookupVariables = new HashMap<String, String>(2);
                for (Map.Entry<String, String> en : variables.entrySet()) {
                    String fBody;
                    String[] splitArr;
                    ILookup lookupService;
                    if (!en.getKey().startsWith("lookup(") || !en.getKey().endsWith(")") || (lookupService = env.getLookupService((splitArr = (fBody = en.getKey().substring("lookup(".length(), en.getKey().length() - 1)).split("\\s*,\\s*"))[0])) == null) continue;
                    try {
                        Collection<String> values = lookupService.lookup(en.getValue());
                        if (values == null) continue;
                        String[] valuesArr = values.toArray(new String[0]);
                        for (int i = 1; i < splitArr.length; ++i) {
                            int ii = i - 1;
                            lookupVariables.put(splitArr[i], ii < valuesArr.length ? valuesArr[ii] : "null");
                        }
                    }
                    catch (Exception e) {
                        RTLogger.print(5, "", e);
                    }
                }
                variables.putAll(lookupVariables);
            }
            catch (Throwable e) {
                RTLogger.print(5, "", e);
            }
        }
        return variables;
    }

    public int getInsertClosed() {
        return this.m_insertClosed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCondition that = (AbstractCondition)o;
        return this.condition_id.equals(that.condition_id);
    }

    public int hashCode() {
        return this.condition_id.hashCode();
    }

    public String toString() {
        return this.condition_id;
    }

    public boolean checkPipe(String text) {
        if (text == null || text.contains("[") && text.contains("]")) {
            return false;
        }
        int cp = text.indexOf(124);
        if (cp != -1) {
            boolean isBslActive = false;
            for (int i = Math.max(0, cp - 2); i < text.length(); ++i) {
                if (!isBslActive) {
                    if (text.charAt(i) == '|') {
                        return true;
                    }
                    isBslActive = text.charAt(i) == '\\';
                    continue;
                }
                isBslActive = false;
            }
        }
        return false;
    }

    public String getObjectFilter() {
        return this.object;
    }

    public void setObjectFilter(String object) {
        this.object = object;
    }

    public String getSetNode() {
        return this.set_node;
    }

    public void setSetNode(String setNode) {
        this.set_node = setNode;
    }

    public String getSetObject() {
        return this.set_object;
    }

    public void setSetObject(String setObject) {
        this.set_object = setObject;
    }

    public String getSetApplication() {
        return this.set_application;
    }

    public void setSetApplication(String setApplication) {
        this.set_application = setApplication;
    }

    public String getSetGroup() {
        return this.set_msggrp;
    }

    public void setSetGroup(String setMsggrp) {
        this.set_msggrp = setMsggrp;
    }

    public String getSetText() {
        return this.set_text;
    }

    public void setSetText(String setText) {
        this.set_text = setText;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getConditionId() {
        return this.condition_id;
    }

    public void setConditionId(String conditionId) {
        this.condition_id = conditionId;
    }

    public int getTypeA() {
        return this.type_a;
    }

    public void setTypeA(int typeA) {
        this.type_a = typeA;
    }

    public int getTypeK() {
        return this.type_k;
    }

    public void setTypeK(int typeK) {
        this.type_k = typeK;
    }

    public String getHelptext() {
        return this.helptext;
    }

    public void setHelptext(String helptext) {
        this.helptext = helptext;
    }

    public String getHelptextId() {
        return this.helptext_id;
    }

    public void setHelptextId(String helptextId) {
        this.helptext_id = helptextId;
    }

    public String getKey() {
        return this.msgkey;
    }

    public void setKey(String msgkey) {
        this.msgkey = msgkey;
    }

    public String getCloseMask() {
        return this.ackkey;
    }

    public void setCloseMask(String ackkey) {
        this.ackkey = ackkey;
    }

    public boolean isDedupl() {
        return this.m_dedupl;
    }

    public void setDedupl(boolean dedupl) {
        this.m_dedupl = dedupl;
    }

    public boolean isDeduplKeyOnly() {
        return this.m_dedupl_keyOnly;
    }

    public void setDeduplKeyOnly(boolean deduplKeyOnly) {
        this.m_dedupl_keyOnly = deduplKeyOnly;
    }

    public String getAutoAction() {
        return this.autoAction;
    }

    public void setAutoAction(String autoAction) {
        this.autoAction = autoAction;
    }

    public String getAutoAction_Node() {
        return this.autoAction_Node;
    }

    public void setAutoAction_Node(String autoActionNode) {
        this.autoAction_Node = autoActionNode;
    }

    public int getAutoActionTimeout() {
        return this.autoActionTimeout;
    }

    public void setAutoActionTimeout(int autoActionTimeout) {
        this.autoActionTimeout = autoActionTimeout;
    }

    public int getAutoActionOnDuplicate() {
        return this.autoActionOnDuplicate;
    }

    public void setAutoActionOnDuplicate(int autoActionOnDuplicate) {
        this.autoActionOnDuplicate = autoActionOnDuplicate;
    }

    public String getOpAction() {
        return this.opAction;
    }

    public void setOpAction(String opAction) {
        this.opAction = opAction;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getInstructionAction() {
        return this.instructionAction;
    }

    public void setInstructionAction(String instructionAction) {
        this.instructionAction = instructionAction;
    }

    public PatternB getObjectFilterPattern() {
        return this.m_filter_obj;
    }

    public void setObjectFilterPattern(PatternB filterObj) {
        this.m_filter_obj = filterObj;
    }

    public void setInsertClosed(int insertClosed) {
        this.m_insertClosed = insertClosed;
    }

    public void setCustomAttributes(ArrayList<String> customAttributes) {
        this.m_customAttributes = customAttributes;
    }
}

