/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import com.blixx.shared.IID;
import com.blixx.shared.IODataStream;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.TreeObject;
import com.blixx.shared.utils.XMLTree;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;

public class AgentInventoryCard
implements IODataStream,
IID {
    public static final String JAVA_VMVER = "JAVA.VMVER";
    public static final String JAVA_VMVENDOR = "JAVA.VMVENDOR";
    public static final String JAVA_VMNAME = "JAVA.VMNAME";
    public static final String JAVA_HOME = "JAVA.HOME";
    public static final String HW_CPUN = "HW.CPUN";
    public static final String HW_CPUT = "HW.CPUTYPE";
    public static final String HW_CPUS = "HW.CPUSPEED";
    public static final String OS_ARCH = "OS.ARCH";
    public static final String OS_VERSION = "OS.VERSION";
    public static final String OS_NAME = "OS.NAME";
    public static final String ID = "ID";
    public static final String IP = "IP";
    public static final String HOSTNAME = "HOSTNAME";
    public static final String HW_MEM = "HW.MEM";
    public static final String SWAP = "SWAP";
    public static final String TIME = "_TIME";
    public static final String AGENT_VERSION = "VERSION";
    public static final String VERSION = "_VERSION";
    public static final String VERSION_HISTORY = "_VERSION_HISTORY";
    public static final String SERIAL = "SERIAL";
    public static final String MANUFACTURER = "MANUFACTURER";
    public static final String CONFIG = "CONFIG";
    public static final String SSH_LOGIN = "SSH.LOGIN";
    public static final String SSH_PASSWORD = "SSH.PASSWORD";
    public static final String SERVICES = "SERVICES";
    public static final String DISKS = "DISKS";
    public static final String NETCARDS = "NETCARDS";
    public static final Set<String> excludeFromCompare = new HashSet<String>();
    private GroupTreeObject root = new GroupTreeObject(new TreeObject("root", "", null));

    public AgentInventoryCard(String id) {
        GroupTreeObject inv = new GroupTreeObject(new TreeObject(ID, "", id));
        this.root.addElement(inv);
        this.addAttribute(AgentInventoryCard.getPath(ID), id);
    }

    @Override
    public String getID() {
        return this.getAttribute(AgentInventoryCard.getPath(ID));
    }

    public String getTime() {
        return this.getAttribute(AgentInventoryCard.getPath(TIME));
    }

    public String getVersion() {
        return this.getAttribute(AgentInventoryCard.getPath(VERSION));
    }

    public String getVersionHistory() {
        return this.getAttribute(AgentInventoryCard.getPath(VERSION_HISTORY));
    }

    public boolean isDiscovered() {
        return this.getAttribute(AgentInventoryCard.getPath(HW_CPUN)) != null && !this.getAttribute(AgentInventoryCard.getPath(HW_CPUN)).equals("");
    }

    public static String getPath(String attr) {
        return "/root/ID/" + attr;
    }

    public String getAttribute(String path) {
        String res = "";
        GroupTreeObject gto = this.root.searchPath(path);
        if (gto != null && gto.getTreeObject().getObject() != null) {
            res = "" + gto.getTreeObject().getObject();
        }
        return res;
    }

    public void setAttribute(String path, String value) {
        GroupTreeObject gto = this.root.searchPath(path);
        if (gto != null) {
            gto.getTreeObject().setObject(value);
        } else {
            int sp = path.lastIndexOf(47);
            String last = path.substring(sp + 1);
            GroupTreeObject created = GroupTreeObject.createPath(path.substring(0, sp), this.root);
            created.addElement(new GroupTreeObject(new TreeObject(last, last, value)));
        }
    }

    public String addAttribute(String path, String value) {
        int sp = path.lastIndexOf(47);
        String last = path.substring(sp + 1);
        GroupTreeObject created = GroupTreeObject.createPath(path.substring(0, sp), this.root);
        String val = last;
        int i = 1;
        while (created.getChild(val, last) != null) {
            val = last + i;
            ++i;
        }
        created.addElement(new GroupTreeObject(new TreeObject(val, last, value)));
        return val;
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        byte[] arr = dis.readFileToNULL("Agent inventory");
        ByteArrayInputStream bis = new ByteArrayInputStream(arr);
        XMLTree xt = new XMLTree();
        this.root = xt.parseXML(bis, true);
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        XMLTree xt = new XMLTree();
        Document d = xt.getXML(this.root);
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            XMLFactory.writeXml(d, bs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dos.writeBytes(bs.toByteArray());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        XMLTree xt = new XMLTree();
        Document d = xt.getXML(this.root);
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            XMLFactory.writeXml(d, bs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append(bs.toString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSDIS(File dir) {
        if (!dir.exists()) {
            return;
        }
        File f = new File(dir, this.getID());
        if (f.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                XMLTree xt = new XMLTree();
                this.root = xt.parseXML(fis, true);
            }
            catch (Exception e) {
                RTLogger.print(4, e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void saveSDIS(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File f = new File(dir, this.getID());
        try {
            XMLTree xt = new XMLTree();
            Document d = xt.getXML(this.root);
            XMLFactory.writeXml(d, f);
        }
        catch (Exception e) {
            RTLogger.print(4, e.getMessage());
        }
    }

    public void saveSDIS(File dir, String newVersion) {
        File f;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((f = new File(dir, this.getID())).exists()) {
            try {
                f.renameTo(new File(dir, this.getID() + "." + this.getAttribute(AgentInventoryCard.getPath(VERSION))));
                String vh = this.getAttribute(AgentInventoryCard.getPath(VERSION_HISTORY));
                if (vh.length() > 0) {
                    vh = vh + " ";
                }
                vh = vh + this.getAttribute(AgentInventoryCard.getPath(VERSION));
                this.setAttribute(AgentInventoryCard.getPath(VERSION_HISTORY), vh);
            }
            catch (Exception e) {
                RTLogger.print(4, "Error renaming file: " + f.getName(), e);
            }
        }
        this.setAttribute(AgentInventoryCard.getPath(VERSION), newVersion);
        try {
            XMLTree xt = new XMLTree();
            Document d = xt.getXML(this.root);
            XMLFactory.writeXml(d, f);
        }
        catch (Exception e) {
            RTLogger.print(4, e.getMessage());
        }
    }

    public boolean parseGET_DETAILS(String output) {
        boolean isFirstDiscovery = !this.isDiscovered();
        boolean isChanged = false;
        AgentInventoryCard newIC = new AgentInventoryCard(this.getID());
        newIC.setAttribute(AgentInventoryCard.getPath(TIME), BM.m_sdf.format(new Date()));
        if (isFirstDiscovery) {
            newIC.setAttribute(AgentInventoryCard.getPath(VERSION), "1.0");
            newIC.setAttribute(AgentInventoryCard.getPath(VERSION_HISTORY), "");
        } else {
            newIC.setAttribute(AgentInventoryCard.getPath(VERSION), this.getAttribute(AgentInventoryCard.getPath(VERSION)));
            newIC.setAttribute(AgentInventoryCard.getPath(VERSION_HISTORY), this.getAttribute(AgentInventoryCard.getPath(VERSION_HISTORY)));
        }
        output = output.replace('<', '(');
        output = output.replace('>', ')');
        String[] arr = output.split("[\r\n]+");
        String param = null;
        for (int i = 0; i < arr.length; ++i) {
            String line = arr[i].trim();
            int eq = line.indexOf(61);
            if (eq == -1) continue;
            param = line.substring(0, eq).trim();
            isChanged = this.processAttr(line, param, newIC) || isChanged;
        }
        this.updateFrom(newIC);
        return isChanged && !isFirstDiscovery;
    }

    private boolean processAttr(String line, String n, AgentInventoryCard temp) {
        if (line == null || n == null || temp == null) {
            return false;
        }
        String old = this.getAttribute(AgentInventoryCard.getPath(n));
        String tmp = line.substring(n.length() + 1).trim();
        try {
            if (!ID.equals(n) && !"".equals(temp.getAttribute(AgentInventoryCard.getPath(n)))) {
                String newparamName = temp.addAttribute(AgentInventoryCard.getPath(n), tmp);
                old = this.getAttribute(AgentInventoryCard.getPath(newparamName));
            } else {
                temp.setAttribute(AgentInventoryCard.getPath(n), tmp);
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "", e);
        }
        return !tmp.equalsIgnoreCase(old);
    }

    public void updateFrom(AgentInventoryCard aci) {
        this.root.clean();
        this.root.addElements(aci.root.getElements());
    }

    public GroupTreeObject getTree() {
        return this.root;
    }

    static {
        excludeFromCompare.add(AgentInventoryCard.getPath(TIME));
        excludeFromCompare.add(AgentInventoryCard.getPath(VERSION));
        excludeFromCompare.add(AgentInventoryCard.getPath(VERSION_HISTORY));
    }
}

