/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.bes.utils.CommTokenManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.io.LRUConcurrentCache;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Pattern;

public class Cryptor {
    private static Pattern d = Pattern.compile("\\d+");
    private static final int DIFF = 305;
    private static final int MAX_BYTES_LENGTH = 250000000;
    private static final int MAX_STRING_LENGTH = 0x5000000;
    private static final int USE_CACHE_MAX_STRING_LENGTH = 10;
    private static LRUConcurrentCache<String, byte[]> cacheV1 = new LRUConcurrentCache(5000);
    private static LRUConcurrentCache<String, byte[]> cacheV2 = new LRUConcurrentCache(5000);
    private static Charset charset = StandardCharsets.UTF_8;
    private static boolean useIntern = false;
    private static final String v4key = "boom";

    public static String encrypt(String in) {
        StringBuilder out = new StringBuilder();
        byte[] b = in.getBytes();
        int index = 0;
        byte[] byArray = b;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int value;
            index = value = byArray[i];
            if (9 < (index += 305) && index < 100) {
                out.append("0");
            } else if (index < 9) {
                out.append("00");
            }
            out.append(index);
        }
        return out.toString();
    }

    public static String decrypt(String in) {
        byte[] mass;
        if (in == null || in.length() == 0) {
            return in;
        }
        if (!d.matcher(in).matches()) {
            return Cryptor.decrypt2(in);
        }
        try {
            int index = 0;
            mass = new byte[in.length() / 3];
            for (int i = 0; i < in.length(); i += 3) {
                String t = in.substring(i, i + 3);
                int v = Integer.parseInt(t) - 305;
                mass[index] = (byte)v;
                ++index;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Decryption failed!");
        }
        return new String(mass);
    }

    public static String decryptV3(String in, String secretKeyV3) {
        if (in == null || in.length() == 0) {
            return in;
        }
        try {
            return Cryptor.readUTFV3(in, secretKeyV3);
        }
        catch (IOException e) {
            RTLogger.print(1, e.getMessage());
            return "";
        }
    }

    public static String decryptV4(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        try {
            return Cryptor.readUTFV3(in, v4key);
        }
        catch (IOException e) {
            RTLogger.print(1, e.getMessage());
            return "";
        }
    }

    public static String encrypt2(String in) {
        try {
            return Base64.getEncoder().encodeToString(Cryptor.writeUTF(in, 1, ""));
        }
        catch (IOException e) {
            RTLogger.print(1, e.getMessage());
            return "";
        }
    }

    private static String decrypt2(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        String res = "error32256";
        try {
            res = Cryptor.readUTF(in);
        }
        catch (Throwable e) {
            RTLogger.print(1, e.getMessage());
        }
        return res;
    }

    public static String encrypt3(String in) {
        try {
            return Base64.getEncoder().encodeToString(Cryptor.writeUTF(in, 2, ""));
        }
        catch (IOException e) {
            RTLogger.print(1, e.getMessage());
            return "";
        }
    }

    public static String encrypt4(String in) {
        try {
            return Base64.getEncoder().encodeToString(Cryptor.writeUTF(in, 4, v4key));
        }
        catch (IOException e) {
            RTLogger.print(1, e.getMessage());
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] writeUTF(String msg, int version, String secretKeyV3) throws IOException {
        if (version >= 3 && secretKeyV3.isEmpty()) {
            throw new IllegalStateException("Please define the secret key first for V3");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (DataOutputStream stream = new DataOutputStream(bos);){
            switch (version) {
                case 3: {
                    stream.writeInt(-10);
                    break;
                }
                case 4: {
                    stream.writeInt(-20);
                    break;
                }
                case 2: {
                    stream.writeInt(-5);
                    break;
                }
                case 0: {
                    stream.writeInt(-30);
                    break;
                }
            }
            if (msg == null || msg.equals("")) {
                stream.writeInt(0);
            } else {
                if (msg.length() > 0x5000000) {
                    msg = msg.substring(0, 0x5000000);
                }
                byte[] cached = null;
                if (msg.length() < 10) {
                    switch (version) {
                        case 1: {
                            cached = cacheV1.get(msg);
                            break;
                        }
                        case 2: {
                            cached = cacheV2.get(msg);
                        }
                    }
                }
                if (cached != null) {
                    stream.writeInt(cached.length);
                    stream.write(cached);
                } else {
                    byte[] toEnc = msg.getBytes(charset);
                    byte[] enc = Cryptor.writeEncoded(toEnc, 0, toEnc.length, version, secretKeyV3);
                    if (enc != null) {
                        stream.writeInt(enc.length);
                        stream.write(enc);
                        if (msg.length() < 10) {
                            switch (version) {
                                case 1: {
                                    cacheV1.put(msg, enc);
                                    break;
                                }
                                case 2: {
                                    cacheV2.put(msg, enc);
                                }
                            }
                        }
                    } else {
                        stream.writeInt(0);
                    }
                }
            }
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] writeFileEncoded(InputStream fis, long maxChunkSize, int version, String secretKeyV3) throws IOException {
        if (version >= 3 && secretKeyV3.isEmpty()) {
            throw new IllegalStateException("Please define the secret key first for V3");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (DataOutputStream stream = new DataOutputStream(bos);){
            stream.writeInt(version);
            byte[] arr = new byte[65536];
            int countB = -1;
            for (long sent = 0L; sent < maxChunkSize && (countB = fis.read(arr)) != -1; sent += (long)countB) {
                byte[] enc = Cryptor.writeEncoded(arr, 0, countB, version, secretKeyV3);
                stream.writeInt(enc.length);
                stream.write(enc);
            }
            stream.writeInt(-1);
        }
        return bos.toByteArray();
    }

    public static String readUTF(String source, String defaultReturnValue) {
        String res = defaultReturnValue;
        try {
            res = Cryptor.readUTF(source);
        }
        catch (Exception e) {
            RTLogger.print(1, e.getMessage());
        }
        return res;
    }

    public static String readUTF(DataInputStream source, String defaultReturnValue) {
        String res = defaultReturnValue;
        try {
            res = Cryptor.readUTF(source);
        }
        catch (Exception e) {
            RTLogger.print(1, e.getMessage());
        }
        return res;
    }

    public static String readUTF(String source) throws IOException {
        return Cryptor.readUTFV3(source, v4key);
    }

    public static String readUTF(DataInputStream source) throws IOException {
        return Cryptor.readUTFV3(source, v4key, new Integer[1]);
    }

    public static String readUTFV3(DataInputStream source, String secretKeyV3, Integer[] lastProtocolVersion) throws IOException {
        String result = null;
        int version = 1;
        int size = 0;
        try {
            size = source.readInt();
            if (size < 0 || size > 250000000) {
                switch (size) {
                    case -30: {
                        size = source.readInt();
                        version = 0;
                        break;
                    }
                    case -5: {
                        size = source.readInt();
                        version = 2;
                        break;
                    }
                    case -10: {
                        size = source.readInt();
                        version = 3;
                        break;
                    }
                    case -20: {
                        size = source.readInt();
                        version = 4;
                        break;
                    }
                    case 557933411: {
                        throw new IOException("Agent was re-assigned to another server???");
                    }
                    default: {
                        throw new IOException("transport failed" + size);
                    }
                }
            }
            if (version == 4 && secretKeyV3 == null) {
                secretKeyV3 = v4key;
            }
            if ((version == 3 || version == 4) && secretKeyV3.isEmpty()) {
                throw new IllegalStateException("Please define the secret key first for V3");
            }
            lastProtocolVersion[0] = version;
            if (size == 0) {
                return "";
            }
            if (size < 0 || size > 250000000) {
                throw new IOException("transport failed--" + size);
            }
            byte[] toDec = new byte[size];
            source.readFully(toDec);
            byte[] dec = Cryptor.readEncoded(toDec, version, secretKeyV3);
            if (dec == null) {
                throw new IOException("Incorrect transport SecretKey");
            }
            result = useIntern ? new String(dec, charset).intern() : new String(dec, charset);
        }
        catch (Exception e) {
            IOException iox = new IOException(e.getMessage());
            iox.setStackTrace(e.getStackTrace());
            throw iox;
        }
        return result;
    }

    public static byte[] writeEncoded(byte[] toEnc, int start, int length, int version, String secretKeyV3) {
        byte[] enc;
        switch (version) {
            case 1: {
                enc = CommTokenManager.encryptV1(toEnc, start, length);
                break;
            }
            case 2: {
                enc = CommTokenManager.encryptV2(toEnc, start, length);
                break;
            }
            case 3: {
                enc = CommTokenManager.encryptV3(toEnc, secretKeyV3, start, length);
                break;
            }
            case 4: {
                enc = CommTokenManager.encryptV4(toEnc, secretKeyV3, start, length);
                break;
            }
            default: {
                enc = Arrays.copyOfRange(toEnc, start, start + length);
            }
        }
        return enc;
    }

    private static byte[] readEncoded(byte[] toDec, int version, String secretKeyV3) {
        byte[] dec = null;
        switch (version) {
            case 4: {
                dec = CommTokenManager.decryptV4(toDec, secretKeyV3);
                break;
            }
            case 3: {
                dec = CommTokenManager.decryptV3(toDec, secretKeyV3);
                break;
            }
            case 2: {
                dec = CommTokenManager.decryptV2(toDec);
                break;
            }
            case 0: {
                dec = toDec;
                break;
            }
            default: {
                dec = CommTokenManager.decryptV1(toDec);
            }
        }
        return dec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUTFV3(String source, String secretKeyV3) throws IOException {
        String result = null;
        source = source.replace("\\r\\n", "").replace("\r\n", "").trim();
        byte[] arr = Base64.getDecoder().decode(source);
        ByteArrayInputStream bin = new ByteArrayInputStream(arr);
        try (DataInputStream stream = new DataInputStream(bin);){
            result = Cryptor.readUTFV3(stream, secretKeyV3, new Integer[1]);
        }
        return result;
    }

    public static boolean readFile(DataInputStream stream, String fullPath, boolean isDecode, int version, boolean append, String secretKeyV3) throws FileNotFoundException, IOException {
        String dir;
        File fdir;
        boolean success = true;
        if ((fullPath = fullPath.replace('\\', '/')).indexOf(47) != -1 && !(fdir = new File(dir = fullPath.substring(0, fullPath.lastIndexOf(47)))).exists() && !fdir.mkdirs()) {
            RTLogger.print(1, "error mkdirs {}", dir);
            throw new FileNotFoundException("dir: " + dir);
        }
        try (FileOutputStream fos = new FileOutputStream(fullPath, append);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            int blockSize = -1;
            byte[] inArr = new byte[65536];
            while ((blockSize = stream.readInt()) > 0) {
                RTLogger.print(1, "Reading bytes: %s file: %s", blockSize, fullPath);
                if (blockSize != inArr.length) {
                    inArr = new byte[blockSize];
                }
                stream.readFully(inArr);
                if (isDecode) {
                    inArr = Cryptor.readEncoded(inArr, version, secretKeyV3);
                }
                bos.write(inArr);
            }
        }
        catch (Exception e) {
            success = false;
            RTLogger.print(1, e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        return success;
    }

    static {
        try {
            int ver;
            String jver = Runtime.class.getPackage().getImplementationVersion();
            if (jver != null && jver.length() > 5) {
                jver = jver.substring(0, 5).replace(".", "");
            }
            if (jver != null && (ver = Integer.parseInt(jver)) >= 170) {
                useIntern = true;
            }
        }
        catch (Exception e) {
            RTLogger.print(1, e.getMessage());
        }
    }
}

