/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import java.util.Calendar;

public class DaytimeOfWeekRange {
    public String m_doyOfweek = "1234567";
    public String m_startStr = null;
    public String m_endStr = null;
    int m_startTime = 0;
    int m_endTime = 0;

    public DaytimeOfWeekRange(String config) {
        String[] arr = config.split("\\s*\\Q;\\E\\s*");
        if (arr.length != 3) {
            throw new RuntimeException("Wrong format. Expected 3 elements");
        }
        this.m_doyOfweek = arr[0];
        this.m_startStr = arr[1];
        this.m_endStr = arr[2];
        this.m_startTime = Integer.parseInt(arr[1].replace(":", ""));
        this.m_endTime = Integer.parseInt(arr[2].replace(":", ""));
    }

    public boolean matched(long ms) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(ms);
        int dowAmerican = c.get(7);
        int dow = DaytimeOfWeekRange.getDayOfWeekForEurope(dowAmerican);
        if (this.m_doyOfweek.contains("" + dow)) {
            int h = c.get(11);
            int m = c.get(12);
            int res = h * 100 + m;
            if (this.m_endTime < this.m_startTime) {
                return res > this.m_startTime && res <= 2400 || res < this.m_endTime;
            }
            return res > this.m_startTime && res < this.m_endTime;
        }
        return false;
    }

    public static int getDayOfWeekForAmerica(int europe) {
        switch (europe) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
        }
        return 1;
    }

    public static int getDayOfWeekForEurope(int american) {
        switch (american) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 7;
    }
}

