/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractConditions;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.exceptions.ConfigException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class MsgConditions
extends AbstractConditions<MsgCondition> {
    private HashSet<String> m_AMkeys = null;

    public static MsgConditions getInstance(Properties conditionGroup, List<Properties> properties, int supptime, int suppcount) {
        MsgConditions cnds = new MsgConditions();
        try {
            cnds.uuid = UUID.fromString(conditionGroup.getProperty("CONDITION_ID"));
        }
        catch (RuntimeException e) {
            throw new ConfigException("UUID incorrect");
        }
        cnds.description = conditionGroup.getProperty("DESCRIPTION");
        if (cnds.description == null) {
            cnds.description = "";
        }
        cnds.m_AMkeys = new HashSet();
        for (int i = 0; i < properties.size(); ++i) {
            Properties pr = properties.get(i);
            try {
                MsgCondition c = MsgCondition.getInstance(pr, supptime, suppcount);
                cnds.addCondition(c);
                cnds.m_AMkeys.addAll(c.getAMKey());
                continue;
            }
            catch (ConfigException e) {
                cnds.getFailedConditions().add(pr);
                RTLogger.print(1, "failed condition. Error: " + e.getMessage());
                RTLogger.print(5, "", e);
            }
        }
        return cnds;
    }

    @Override
    public MsgCondition addNewCondition() {
        MsgCondition c = MsgCondition.getNew(this.getConditionCount() + 1);
        this.addCondition(c);
        return c;
    }

    public HashSet<String> getAMKeys() {
        return this.m_AMkeys;
    }
}

