/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Interval;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.exceptions.ConfigException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class MsgPolicy
extends AbstractPolicy {
    private int suppressTime = 0;
    private int suppressCount = 0;
    private MsgConditions conditions = null;
    private boolean m_PLOG_enabled = false;
    private int m_PLOG_logcount = 3;
    private int m_PLOG_logsize = 1;

    protected MsgPolicy() {
    }

    public static MsgPolicy createNewPolicy() {
        MsgPolicy pol = new MsgPolicy();
        pol.policyName = "Indication_" + System.currentTimeMillis();
        pol.conditions = new MsgConditions();
        pol.conditions.addCondition(MsgCondition.getNew(1));
        return pol;
    }

    public static MsgPolicy create(String separator, Properties prop, Properties conditionGroup, List<Properties> conditions) throws ConfigException {
        MsgPolicy mp = new MsgPolicy();
        MsgPolicy.fillValues(mp, prop, separator);
        if (mp.callType != null) {
            mp.callType = mp.callType.trim();
            if (mp.callType.equalsIgnoreCase("EXEC") || mp.callType.equalsIgnoreCase("JAVA") || mp.callType.equalsIgnoreCase("FILE") || mp.callType.equalsIgnoreCase("NAGIN")) {
                mp.monprog = prop.getProperty("MONPROG", "".intern());
                if (mp.monprog != null) {
                    mp.monprog = mp.monprog.trim();
                }
            } else if (mp.callType.length() != 0) {
                throw new ConfigException("Unknown CALLTYPE. Must be EXEC | JAVA | FILE | NAGIN | empty");
            }
        }
        String suppressT = prop.getProperty("SUPP_TIME", "");
        mp.suppressTime = Interval.parseInterval(suppressT, 0).getIntervalSeconds();
        if (mp.suppressTime < 0) {
            mp.suppressTime = 0;
        }
        String suppressC = prop.getProperty("SUPP_COUNT", "");
        try {
            mp.suppressCount = Integer.parseInt(suppressC);
        }
        catch (NumberFormatException e) {
            mp.suppressCount = 0;
        }
        String plogStr = prop.getProperty("PLOG_ENABLED");
        if (plogStr != null && plogStr.equalsIgnoreCase("true")) {
            mp.m_PLOG_enabled = true;
            try {
                String lcount = prop.getProperty("PLOG_LOGCOUNT", "3");
                String lsize = prop.getProperty("PLOG_LOGSIZE", "1");
                mp.m_PLOG_logcount = Integer.parseInt(lcount);
                mp.m_PLOG_logsize = Integer.parseInt(lsize);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        mp.conditions = MsgConditions.getInstance(conditionGroup, conditions, mp.suppressTime, mp.suppressCount);
        return mp;
    }

    public static MsgPolicy getCopy(MsgPolicy p) {
        Properties main = p.getMainProperties();
        Properties nMain = new Properties(main);
        String name = nMain.getProperty("NAME");
        nMain.setProperty("NAME", name + "_copy" + System.currentTimeMillis());
        Properties cnds = p.getConditions().getProperties();
        Properties nCnds = new Properties(cnds);
        nCnds.setProperty("CONDITION_ID", UUID.randomUUID().toString());
        List al = p.getConditions().getConditionList();
        ArrayList<Properties> nAl = new ArrayList<Properties>(al.size());
        for (int i = 0; i < al.size(); ++i) {
            MsgCondition c = (MsgCondition)al.get(i);
            Properties cn = c.getProperties();
            Properties nCn = new Properties(cn);
            nCn.putAll((Map<?, ?>)cn);
            nCn.setProperty("CONDITION_ID", UUID.randomUUID().toString());
            nCn.setProperty("HELPTEXT_ID", UUID.randomUUID().toString());
            nAl.add(nCn);
        }
        MsgPolicy n = MsgPolicy.create("\u25ba", nMain, cnds, nAl);
        return n;
    }

    public MsgConditions getConditions() {
        return this.conditions;
    }

    public void setConditions(MsgConditions conditions) {
        this.conditions = conditions;
    }

    public HashSet<String> getAMKeys() {
        return this.conditions.getAMKeys();
    }

    @Override
    public Properties getMainProperties() {
        Properties p = super.getMainProperties();
        if (this.intervalStr == null) {
            this.intervalStr = "0";
        }
        p.setProperty("INTERVAL", this.intervalStr);
        if (this.callType == null) {
            this.callType = "";
        }
        p.setProperty("CALLTYPE", this.callType);
        if (this.monprog == null) {
            this.monprog = "";
        }
        p.setProperty("MONPROG", this.monprog);
        p.setProperty("SUPP_COUNT", "" + this.suppressCount);
        p.setProperty("SUPP_TIME", "" + this.suppressTime / 60 + "m");
        if (this.m_PLOG_enabled) {
            p.setProperty("PLOG_ENABLED", "true");
            p.setProperty("PLOG_LOGCOUNT", "" + this.m_PLOG_logcount);
            p.setProperty("PLOG_LOGSIZE", "" + this.m_PLOG_logsize);
        }
        if (this.m_msd_mpm > 0) {
            p.setProperty("MSD_MAX_PER_MINUTE", "" + this.m_msd_mpm);
            p.setProperty("MSD_BLOCK_MINUTES", "" + this.m_msd_bm);
            p.setProperty("MSD_QUARANTINE_MINUTES", "" + this.m_msd_qm);
        }
        return p;
    }

    public boolean isTriggerEnabled() {
        return this.monprog != null && this.monprog.length() > 1;
    }

    public String[] getParameters() {
        String[] full;
        String[] res = null;
        if (this.isTriggerEnabled() && (full = this.monprog.split("\n")).length > 1) {
            res = new String[full.length - 1];
            for (int i = 1; i < full.length; ++i) {
                res[i - 1] = full[i];
            }
        }
        return res;
    }

    public String getBinary() {
        String res = null;
        if (this.isTriggerEnabled()) {
            String[] full = this.monprog.split("\n");
            res = full[0];
        }
        return res;
    }

    public int getSuppressTime() {
        return this.suppressTime;
    }

    public void setSuppressTime(int suppressTime) {
        this.suppressTime = suppressTime;
    }

    public int getSuppressCount() {
        return this.suppressCount;
    }

    public void setSuppressCount(int suppressCount) {
        this.suppressCount = suppressCount;
    }

    public boolean isPlogEnabled() {
        return this.m_PLOG_enabled;
    }

    public void setPlogEnabled(boolean pLOGEnabled) {
        this.m_PLOG_enabled = pLOGEnabled;
    }

    public int getPlogLogcount() {
        return this.m_PLOG_logcount;
    }

    public void setPlogLogcount(int pLOGLogcount) {
        this.m_PLOG_logcount = pLOGLogcount;
    }

    public int getPlogLogsize() {
        return this.m_PLOG_logsize;
    }

    public void setPlogLogsize(int pLOGLogsize) {
        this.m_PLOG_logsize = pLOGLogsize;
    }

    @Override
    public String getPolicyType() {
        return "msg";
    }
}

