/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.Annotation;
import com.blixx.shared.HashCode;
import com.blixx.shared.IEvent;
import com.blixx.shared.Severity;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public abstract class SEvent
implements IEvent {
    public static final char STATE_ACTIVE_CH = '-';
    public static final char STATE_AUTO_CLOSED_CH = 'A';
    public static final char STATE_OPERATOR_CLOSED_CH = 'O';
    public static final char STATE_DELETED = 'D';
    public static final char STATE_UNKNOWN = 'X';
    protected int m_duplicate = 0;
    protected char m_state = (char)45;
    protected boolean m_lockedFlag = false;
    protected boolean m_annotationFlag = false;
    protected String m_service = "".intern();
    protected long m_stime = 0L;
    protected String m_uuid = null;
    protected double m_value = -1.0;
    protected long m_time = -1L;
    protected String m_application = "".intern();
    protected String m_monitor = "".intern();
    protected String m_object = "".intern();
    protected short m_severity = 0;
    protected String m_msg_text = "".intern();
    protected String m_instructionID = "".intern();
    protected String m_msg_grp = "".intern();
    protected String m_messageKey = "".intern();
    protected String m_ackKey = "".intern();
    protected String m_node = "".intern();
    protected String m_autoAction = "".intern();
    protected String m_autoActionNode = "".intern();
    protected int m_autoActionTimeout = 120;
    protected String m_source;
    protected String m_opAction = "".intern();
    protected long m_firstTime = 0L;
    protected short m_typeA = 0;
    protected short m_typeK = 0;
    protected boolean m_deduplication = true;
    protected String m_agentIP = "".intern();
    protected HashCode m_hash = null;
    protected ArrayList<String> m_annotation = new ArrayList(0);

    @Override
    public Object readS(SDataInputStream dis) throws IOException {
        dis.readUTF();
        this.setDuplicate(dis.readInt());
        String state = dis.readUTF();
        if (state != null && state.length() == 1) {
            this.setState(state.charAt(0));
        }
        dis.readBoolean();
        dis.readBoolean();
        this.setLockedFlag(dis.readBoolean());
        dis.readBoolean();
        this.setAnnotationFlag(dis.readBoolean());
        this.setTime(dis.readLong());
        this.setService(dis.readUTF());
        this.setNode(dis.readUTF());
        this.setApplication(dis.readUTF());
        this.setMonitor(dis.readUTF());
        double dval = dis.readDouble();
        if (Double.isNaN(dval)) {
            this.setValue(-1.0);
        } else {
            this.setValue(dval);
        }
        this.setObject(dis.readUTF());
        this.setSeverity(dis.readInt());
        this.setGroup(dis.readUTF());
        this.setText(dis.readUTF());
        this.setKey(dis.readUTF());
        this.setID(dis.readUTF());
        this.setCloseMask(dis.readUTF());
        this.setSource(dis.readUTF());
        this.setAutoAction(dis.readUTF());
        this.setAutoActionNode(dis.readUTF());
        this.setOpAction(dis.readUTF());
        this.setSTime(dis.readLong());
        this.setAgentNode(dis.readUTF());
        this.setInstructionID(dis.readUTF());
        this.setTypeA(dis.readInt());
        this.setTypeK(dis.readInt());
        this.setDeduplication(dis.readBoolean());
        this.setFirstTime(dis.readLong());
        int annotations = dis.readInt();
        for (int i = 0; i < annotations; ++i) {
            this.m_annotation.ensureCapacity(annotations);
            this.m_annotation.add(dis.readUTF());
        }
        return this;
    }

    @Override
    public void sendS(SDataOutputStream dos) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SDataOutputStream sbos = new SDataOutputStream(bos, dos.getVersion());
        sbos.writeUTF(this.getSeverity());
        sbos.writeInt(this.getDuplicates());
        sbos.writeUTF("" + this.getState());
        sbos.writeBoolean(this.getInstructionFlag());
        sbos.writeBoolean(this.getAutoActionFlag());
        sbos.writeBoolean(this.getLockedFlag());
        sbos.writeBoolean(this.getOpActionFlag());
        sbos.writeBoolean(this.getAnnotationFlag());
        sbos.writeLong(this.getTime());
        sbos.writeUTF(this.getService());
        sbos.writeUTF(this.getNode());
        sbos.writeUTF(this.getApplication());
        sbos.writeUTF(this.getMonitor());
        sbos.writeDouble(this.getValue());
        sbos.writeUTF(this.getObject());
        sbos.writeInt(this.getSeverityInt());
        sbos.writeUTF(this.getGroup());
        sbos.writeUTF(this.getText());
        sbos.writeUTF(this.getKeyConfigured());
        sbos.writeUTF(this.getID());
        sbos.writeUTF(this.getCloseMask());
        sbos.writeUTF(this.getSource());
        sbos.writeUTF(this.getAutoAction());
        sbos.writeUTF(this.getAutoActionNode());
        sbos.writeUTF(this.getOpAction());
        sbos.writeLong(this.getSTime());
        sbos.writeUTF(this.getAgentNode());
        sbos.writeUTF(this.getInstructionID());
        sbos.writeInt(this.getTypeA());
        sbos.writeInt(this.getTypeK());
        sbos.writeBoolean(this.getDeduplication());
        sbos.writeLong(this.getFirstTime());
        sbos.writeInt(this.m_annotation.size());
        for (int i = 0; i < this.m_annotation.size(); ++i) {
            sbos.writeUTF(this.m_annotation.get(i));
        }
        dos.write(bos.toByteArray());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getID()).append(": ").append(this.getText()).append(" node=").append(this.getNode());
        return sb.toString();
    }

    public Annotation setAnnotationClosedByUser(String user) {
        String closedBy = "Message Closed by operator: {" + user + "}";
        long closedByTime = System.currentTimeMillis();
        Annotation ann = new Annotation(closedBy, closedByTime, "OAM");
        this.addAnnotation(ann.toString());
        return ann;
    }

    public Annotation setAnnotationClosedByMessage(String mesageID) {
        String closedBy = mesageID;
        long closedByTime = System.currentTimeMillis();
        Annotation ann = new Annotation(closedBy, closedByTime, "SAM");
        this.addAnnotation(ann.toString());
        return ann;
    }

    public ArrayList<String> getAnnotations() {
        return this.m_annotation;
    }

    public boolean setAnnotations(ArrayList<String> annotations) {
        boolean isChanged = false;
        if (annotations == null) {
            return false;
        }
        for (String a : annotations) {
            if (a == null || this.m_annotation.contains(a)) continue;
            this.m_annotation.add(a);
            isChanged = true;
        }
        return isChanged;
    }

    public boolean addAnnotation(String ann) {
        boolean isChanged = false;
        if (ann != null && !this.m_annotation.contains(ann)) {
            this.m_annotation.add(ann);
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public int getDuplicates() {
        return this.m_duplicate;
    }

    @Override
    public boolean getAnnotationFlag() {
        return this.m_annotation.size() > 0 || this.m_annotationFlag;
    }

    @Override
    public String getSource() {
        return this.m_source == null ? "" : new String(this.m_source);
    }

    @Override
    public char getState() {
        return this.m_state;
    }

    public void setState(char state) {
        this.m_state = state;
    }

    @Override
    public long getSTime() {
        return this.m_stime;
    }

    @Override
    public String getApplication() {
        return this.m_application;
    }

    @Override
    public boolean getAutoActionFlag() {
        return this.m_autoAction != null && this.m_autoAction.length() > 0;
    }

    @Override
    public boolean getInstructionFlag() {
        return this.m_instructionID != null && !this.m_instructionID.equals("");
    }

    @Override
    public boolean getLockedFlag() {
        return this.m_lockedFlag;
    }

    @Override
    public String getGroup() {
        return this.m_msg_grp;
    }

    @Override
    public String getText() {
        return this.m_msg_text == null ? "" : new String(this.m_msg_text);
    }

    @Override
    public String getNode() {
        return this.m_node;
    }

    @Override
    public String getObject() {
        return this.m_object;
    }

    @Override
    public boolean getOpActionFlag() {
        return this.m_opAction != null && this.m_opAction.length() > 0;
    }

    @Override
    public String getService() {
        return this.m_service;
    }

    @Override
    public String getSeverity() {
        return Severity.getSeverity(this.m_severity);
    }

    @Override
    public int getSeverityInt() {
        return this.m_severity;
    }

    @Override
    public long getTime() {
        return this.m_time;
    }

    @Override
    public String getID() {
        return this.m_uuid;
    }

    @Override
    public String getCloseMask() {
        return this.m_ackKey;
    }

    @Override
    public String getInstructionID() {
        return this.m_instructionID;
    }

    @Override
    public String getAutoAction() {
        return this.m_autoAction;
    }

    @Override
    public String getAutoActionNode() {
        return this.m_autoActionNode;
    }

    @Override
    public int getAutoActionTimeout() {
        return this.m_autoActionTimeout;
    }

    @Override
    public String getOpAction() {
        return this.m_opAction;
    }

    @Override
    public String getMonitor() {
        return this.m_monitor;
    }

    @Override
    public double getValue() {
        return this.m_value;
    }

    @Override
    public String getAgentNode() {
        return this.m_agentIP;
    }

    @Override
    public void setAgentNode(String agentIP) {
        if (agentIP != null) {
            agentIP = this.check255(agentIP);
            this.m_agentIP = SEvent.getCachedString(agentIP);
        }
    }

    @Override
    public int getTypeA() {
        return this.m_typeA;
    }

    @Override
    public int getTypeK() {
        return this.m_typeK;
    }

    @Override
    public boolean getDeduplication() {
        return this.m_deduplication;
    }

    @Override
    public void setTime(long newTime) {
        this.m_time = newTime;
    }

    @Override
    public void setSTime(long newSTime) {
        this.m_stime = newSTime;
    }

    @Override
    public long getFirstTime() {
        return this.m_firstTime;
    }

    @Override
    public void setNode(String node) {
        if (node != null) {
            node = this.check1024(node);
            this.m_node = SEvent.getCachedString(node);
        }
    }

    @Override
    public void setSeverity(int sev) {
        while (sev < -5) {
            sev += 6;
        }
        this.m_severity = (short)sev;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SEvent) {
            if (this.m_uuid == null || ((SEvent)obj).m_uuid == null) {
                return this.m_uuid == ((SEvent)obj).m_uuid;
            }
            return this.m_uuid.equals(((SEvent)obj).m_uuid);
        }
        return false;
    }

    public int hashCode() {
        if (this.m_uuid == null) {
            return 0;
        }
        return this.m_uuid.hashCode();
    }

    @Override
    public String getKeyConfigured() {
        return this.m_messageKey;
    }

    @Override
    public HashCode getKeyInternal() {
        if (this.m_hash == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getAgentNode());
            sb.append(this.getNode());
            sb.append(this.getApplication());
            sb.append(this.getGroup());
            sb.append(this.getObject());
            sb.append(this.getSeverityInt());
            sb.append(this.m_messageKey);
            sb.append(this.getText());
            this.m_hash = new HashCode(sb.toString());
        }
        return this.m_hash;
    }

    public String getAutoKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAgentNode()).append(":");
        sb.append(this.getNode()).append(":");
        sb.append(this.getApplication()).append(":");
        sb.append(this.getGroup()).append(":");
        sb.append(this.getObject()).append(":");
        sb.append(this.getSeverity());
        return sb.toString();
    }

    public void setText(String text) {
        if (text != null) {
            if (text.length() > 2048) {
                text = text.substring(0, 2048);
            }
            this.m_msg_text = text;
        }
    }

    public void setKey(String key) {
        key = key == null ? "".intern() : this.check1024(key);
        this.m_messageKey = SEvent.getCachedString(key);
    }

    public void setCloseMask(String mask) {
        mask = mask == null ? "".intern() : this.check1024(mask);
        this.m_ackKey = SEvent.getCachedString(mask);
    }

    public void setObject(String object) {
        if (object != null) {
            object = this.check1024(object);
            this.m_object = SEvent.getCachedString(object);
        }
    }

    public void setApplication(String application) {
        if (application != null) {
            application = this.check1024(application);
            this.m_application = SEvent.getCachedString(application);
        }
    }

    public void setGroup(String group) {
        if (group != null) {
            group = this.check1024(group);
            this.m_msg_grp = SEvent.getCachedString(group);
        }
    }

    public void setID(String id) {
        this.m_uuid = id;
    }

    public void setSource(String sourcePolicy) {
        if (sourcePolicy != null) {
            sourcePolicy = this.check1024(sourcePolicy);
            this.m_source = SEvent.getCachedString(sourcePolicy);
        }
    }

    public boolean isActive() {
        return '-' == this.m_state;
    }

    public boolean isDeleted() {
        return 'D' == this.m_state;
    }

    public boolean isClosed() {
        switch (this.m_state) {
            case 'A': 
            case 'O': {
                return true;
            }
        }
        return false;
    }

    public boolean isClosedByOperator() {
        return 'O' == this.m_state;
    }

    public boolean isClosedByAnotherMessageOrInsertedAsClosed() {
        return 'A' == this.m_state;
    }

    public void setService(String serviceName) {
        if (serviceName != null) {
            serviceName = this.check1024(serviceName);
            this.m_service = SEvent.getCachedString(serviceName);
        }
    }

    public void setDuplicate(int duplicateCount) {
        this.m_duplicate = duplicateCount;
    }

    public void setInstructionID(String instructionID) {
        if (instructionID != null) {
            this.m_instructionID = SEvent.getCachedString(instructionID);
        }
    }

    public void setAutoAction(String autoAction) {
        if (autoAction != null) {
            autoAction = this.check1024(autoAction);
            this.m_autoAction = SEvent.getCachedString(autoAction);
        }
    }

    public void setAutoActionNode(String autoActionNode) {
        if (autoActionNode != null) {
            autoActionNode = this.check1024(autoActionNode);
            this.m_autoActionNode = SEvent.getCachedString(autoActionNode);
        }
    }

    public void setAutoActionTimeout(int autoActionTimeout) {
        this.m_autoActionTimeout = autoActionTimeout;
    }

    public void setLockedFlag(boolean lockedFlag) {
        this.m_lockedFlag = lockedFlag;
    }

    public void setOpAction(String operatorAction) {
        if (operatorAction != null) {
            operatorAction = this.check1024(operatorAction);
            this.m_opAction = SEvent.getCachedString(operatorAction);
        }
    }

    public void setMonitor(String monitor) {
        if (monitor != null) {
            monitor = this.check1024(monitor);
            this.m_monitor = SEvent.getCachedString(monitor);
        }
    }

    public void setValue(double value) {
        this.m_value = value;
    }

    public void setTypeA(int availability) {
        this.m_typeA = (short)availability;
    }

    public void setTypeK(int kpi) {
        this.m_typeK = (short)kpi;
    }

    public void setDeduplication(boolean deduplication) {
        this.m_deduplication = deduplication;
    }

    public void setFirstTime(long firstTime) {
        this.m_firstTime = firstTime;
    }

    public void setAnnotationFlag(boolean annotationFlag) {
        this.m_annotationFlag = annotationFlag;
    }

    private String check1024(String sourcePolicy) {
        if (sourcePolicy != null && sourcePolicy.length() > 1024) {
            sourcePolicy = sourcePolicy.substring(0, 1024);
        }
        return sourcePolicy;
    }

    private String check255(String sourcePolicy) {
        if (sourcePolicy != null && sourcePolicy.length() > 255) {
            sourcePolicy = sourcePolicy.substring(0, 255);
        }
        return sourcePolicy;
    }

    public static String getCachedString(String sourceString) {
        return sourceString.intern();
    }
}

