/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.shared.IODataStream;
import com.blixx.shared.UserRight;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class UserRole
implements IODataStream {
    private String id = null;
    private String name = null;
    private String description = null;
    private Map<Integer, UserRight> rights = new ConcurrentHashMap<Integer, UserRight>(20);
    public static final String ID = "ID";
    public static final String NAME = "ROLENAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    private transient String nameInBrackets = null;

    private UserRole() {
    }

    public static UserRole createRole(Map userData) {
        UserRole role = new UserRole();
        role.id = (String)userData.get(ID);
        role.name = (String)userData.get(NAME);
        role.description = (String)userData.get(DESCRIPTION);
        if (role.description == null) {
            role.description = "";
        }
        return role;
    }

    public static UserRole createNewRole(String id) {
        UserRole role = new UserRole();
        role.id = id;
        role.name = "";
        role.description = "";
        return role;
    }

    public static UserRole createNewRole() {
        return UserRole.createNewRole(UUID.randomUUID().toString());
    }

    public void addRights(List<UserRight> rights) {
        for (UserRight r : rights) {
            this.rights.put(r.getItemID(), r);
        }
    }

    public void addRight(UserRight right) {
        this.rights.put(right.getItemID(), right);
    }

    public List<UserRight> getRights() {
        return new ArrayList<UserRight>(this.rights.values());
    }

    public boolean removeRightsIf(Predicate<UserRight> filter) {
        return this.rights.entrySet().removeIf(en -> filter.test((UserRight)en.getValue()));
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getRightLevel(int userRightID) {
        UserRight r = this.rights.get(userRightID);
        if (r == null) {
            return 0;
        }
        return r.getLevel();
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        this.description = dis.readUTF();
        this.name = dis.readUTF();
        this.id = dis.readUTF();
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            UserRight ur = new UserRight();
            ur.read(dis);
            this.rights.put(ur.getItemID(), ur);
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeUTF(this.description);
        dos.writeUTF(this.name);
        dos.writeUTF(this.id);
        List<UserRight> rights = this.getRights();
        int size = rights.size();
        dos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            UserRight ur = rights.get(i);
            ur.send(dos);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getNameInBrackets() {
        if (this.nameInBrackets == null) {
            this.nameInBrackets = '[' + this.name + ']';
        }
        return this.nameInBrackets;
    }
}

