/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared;

import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.exceptions.ConfigException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class XMLFactory {
    private static final String DIVISION_CHAR = "&#xf7;";
    public static final char SEPARATOR_DEFAULT = '\u25ba';
    private static final String SEPARATOR_DEFAULT_STR = "\u25ba";
    public static final String SEPARATOR = "SEPARATOR";
    public static final String VERSION = "VERSION";
    public String m_section = null;
    public String m_element = null;
    public static final String LESS_THAN_ENTITY = "&lt;";
    public static final String GREATER_THAN_ENTITY = "&gt;";
    public static final String AMPERSAND_ENTITY = "&amp;";
    public static final String APOSTROPHE_ENTITY = "&apos;";
    public static final String QUOTE_ENTITY = "&quot;";
    private static final int MASK_NAME_START = 1;
    private static final int MASK_NAME = 2;
    private static final byte[] CHARS;

    public XMLFactory(String section, String element) {
        this.m_section = section;
        this.m_element = element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File reformat(File file) {
        File nFile = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            nFile = new File(file.getParent(), file.getName() + ".c");
            XMLFactory.writeXml(doc, nFile);
        }
        catch (Throwable e) {
            RTLogger.print(1, "", e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable doc) {}
            }
        }
        return nFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Properties> loadFile(File file) {
        ArrayList<Properties> al = new ArrayList<Properties>();
        FileInputStream fileInputStream = null;
        try {
            if (file.exists() && file.canRead()) {
                fileInputStream = new FileInputStream(file);
                al = this.loadFile(fileInputStream);
            }
        }
        catch (FileNotFoundException e) {
            RTLogger.print(1, "", e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return al;
    }

    public ArrayList<Properties> loadFile(InputStream file) {
        ArrayList<Properties> al = new ArrayList<Properties>();
        try {
            Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            String separator = XMLFactory.getSeparator(doc);
            NodeList nlist = doc.getElementsByTagName(this.m_element);
            al.ensureCapacity(nlist.getLength());
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node item = nlist.item(i);
                Node cdata = XMLFactory.searchCDATA(item);
                if (cdata == null) {
                    throw new ConfigException("Error: NO CDATA section found for:" + item.getNodeName());
                }
                String data = cdata.getNodeValue().trim();
                Properties elProperties = XMLFactory.extractProperties(separator, data);
                al.add(elProperties);
            }
        }
        catch (Throwable e) {
            RTLogger.print(1, "", e);
        }
        return al;
    }

    public static String getSeparator(Document doc) {
        Node n;
        String tc = null;
        NodeList olist = doc.getElementsByTagName(SEPARATOR);
        if (olist != null && olist.getLength() > 0 && ((tc = (n = olist.item(0)).getTextContent().trim()) == null || tc.length() == 0)) {
            tc = SEPARATOR_DEFAULT_STR;
        }
        return tc;
    }

    public static Node searchCDATA(Node parent) {
        Node n = null;
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 4) continue;
            n = nl.item(i);
            break;
        }
        return n;
    }

    public static Properties extractProperties(String separator, String dataStr) {
        String dataString = XMLFactory.unescape(dataStr);
        Properties properties = new Properties();
        String[] sss = null;
        if (dataString != null) {
            sss = dataString.split("\\s*" + separator);
        }
        if (sss != null) {
            if (sss.length > 1) {
                int start = 0;
                if (sss[0].trim().length() == 0) {
                    start = 1;
                }
                for (int j = start; j < sss.length; j += 2) {
                    String name = sss[j].trim();
                    String value = "";
                    if (j < sss.length - 1) {
                        value = sss[j + 1];
                    }
                    properties.setProperty(name, value);
                }
            }
        } else {
            throw new ConfigException("Error: config block has no separator");
        }
        return properties;
    }

    public static int getVersion(Document doc) {
        int version = 0;
        NodeList olist = doc.getElementsByTagName(VERSION);
        if (olist != null && olist.getLength() > 0) {
            Node n = olist.item(0);
            String ver = n.getTextContent().trim();
            if (ver == null || ver.length() == 0) {
                version = 1;
            } else {
                try {
                    version = (int)Double.parseDouble(ver);
                }
                catch (NumberFormatException e) {
                    RTLogger.print(1, "Policy version is unknown: " + ver);
                }
            }
        }
        return version;
    }

    public void storeFile(String fullFilename, ArrayList ar) {
        Document doc = this.createXMLver1(ar);
        XMLFactory.writeXml(doc, fullFilename);
    }

    public static boolean writeXml(Document doc, String filename) {
        File file = new File(filename);
        return XMLFactory.writeXml(doc, file);
    }

    public static synchronized boolean writeXml(Document doc, File file) {
        boolean isOk = false;
        if (doc == null) {
            RTLogger.print(1, "Can't write xml file. XML document is empty. " + file.getName());
            return isOk;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            XMLFactory.writeXml(doc, fileOutputStream);
            fileOutputStream.close();
        }
        catch (Throwable e) {
            RTLogger.print(2, "XML write error. ", e);
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return isOk;
    }

    public static void writeXml(Document doc, OutputStream outputStream) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DOMImplementationLS dils = null;
        DOMImplementationList dilist = DOMImplementationRegistry.newInstance().getDOMImplementationList("LS");
        if (dilist != null && dilist.getLength() > 0) {
            for (int i = 0; i < dilist.getLength(); ++i) {
                DOMImplementationLS s = (DOMImplementationLS)((Object)dilist.item(i));
                String classname = s.getClass().getName();
                if (!classname.equals("org.apache.xerces.dom.CoreDOMImplementationImpl") && !classname.equals("com.sun.org.apache.xerces.internal.dom.CoreDOMImplementationImpl")) continue;
                dils = s;
                break;
            }
            if (dils == null) {
                dils = (DOMImplementationLS)((Object)dilist.item(0));
            }
        } else {
            dils = (DOMImplementationLS)((Object)doc.getImplementation());
        }
        LSOutput lso = dils.createLSOutput();
        lso.setEncoding("UTF-8");
        lso.setByteStream(outputStream);
        LSSerializer serializer = dils.createLSSerializer();
        try {
            serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            serializer.getDomConfig().setParameter("split-cdata-sections", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        serializer.setNewLine("\r\n");
        serializer.write(doc, lso);
    }

    public static String writeXml(Document doc) {
        String res = "";
        if (doc == null) {
            RTLogger.print(1, "Can't write xml file. XML document is empty");
            return res;
        }
        ByteArrayOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new ByteArrayOutputStream();
            DOMImplementationLS dils = null;
            DOMImplementationList dilist = DOMImplementationRegistry.newInstance().getDOMImplementationList("LS");
            if (dilist != null && dilist.getLength() > 0) {
                for (int i = 0; i < dilist.getLength(); ++i) {
                    DOMImplementationLS s = (DOMImplementationLS)((Object)dilist.item(i));
                    String classname = s.getClass().getName();
                    if (!classname.equals("org.apache.xerces.dom.CoreDOMImplementationImpl") && !classname.equals("com.sun.org.apache.xerces.internal.dom.CoreDOMImplementationImpl")) continue;
                    dils = s;
                    break;
                }
                if (dils == null) {
                    dils = (DOMImplementationLS)((Object)dilist.item(0));
                }
            } else {
                dils = (DOMImplementationLS)((Object)doc.getImplementation());
            }
            LSOutput lso = dils.createLSOutput();
            lso.setEncoding("UTF-8");
            lso.setByteStream(fileOutputStream);
            LSSerializer serializer = dils.createLSSerializer();
            try {
                serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                serializer.getDomConfig().setParameter("split-cdata-sections", Boolean.FALSE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            serializer.setNewLine("\r\n");
            serializer.write(doc, lso);
            fileOutputStream.close();
            res = fileOutputStream.toString();
        }
        catch (Throwable e) {
            RTLogger.print(2, "XML write error. ", e);
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable dils) {}
            }
        }
        return res;
    }

    public Document createXMLver1(ArrayList<Object> arr) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement(this.m_section);
            Element separator = doc.createElement(SEPARATOR);
            separator.setTextContent(SEPARATOR_DEFAULT_STR);
            root.appendChild(separator);
            for (int i = 0; i < arr.size(); ++i) {
                Properties c = null;
                Object obj = arr.get(i);
                if (obj instanceof Properties) {
                    c = (Properties)obj;
                } else if (obj instanceof Action) {
                    c = ((Action)obj).getProperties();
                } else {
                    throw new RuntimeException("unsupported " + (obj == null ? "NullObject" : obj.getClass().toString()));
                }
                Element cel = XMLFactory.getCDATA(doc, this.m_element, c, SEPARATOR_DEFAULT_STR);
                root.appendChild(cel);
            }
            doc.appendChild(root);
        }
        catch (Throwable e) {
            RTLogger.print(2, "XML creation error. ", e);
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        return doc;
    }

    public static Element getCDATA(Document doc, String name, Properties value, String separator) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        if (value == null) {
            value = new Properties();
        }
        ArrayList<Object> al = new ArrayList<Object>(value.keySet());
        Collections.sort(al);
        Iterator<Object> it = al.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String property = value.getProperty(key);
            sb.append(separator).append(key).append(separator).append(property);
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        Element el = doc.createElement(name);
        XMLFactory.escapeCDATAContent(sb);
        CDATASection cdata = doc.createCDATASection(sb.toString());
        if (cdata != null) {
            Comment cel = doc.createComment(name + " begin");
            el.appendChild(cel);
            el.appendChild(cdata);
            Comment cel2 = doc.createComment(name + " end");
            el.appendChild(cel2);
        }
        return el;
    }

    public static final String escape(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String unescape(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        value = value.replace(AMPERSAND_ENTITY, "&");
        value = value.replace(LESS_THAN_ENTITY, "<");
        value = value.replace(GREATER_THAN_ENTITY, ">");
        value = value.replace(APOSTROPHE_ENTITY, "'");
        value = value.replace(QUOTE_ENTITY, "\"");
        value = value.replace(DIVISION_CHAR, "247");
        return value;
    }

    public static final String escapeCDATAContent(String content) {
        StringBuilder buffer = new StringBuilder(content);
        XMLFactory.escapeCDATAContent(buffer);
        return buffer.toString();
    }

    public static final void escapeCDATAContent(StringBuilder bufferedContent) {
        int size = bufferedContent.length();
        for (int i = 2; i < size; ++i) {
            char at = bufferedContent.charAt(i);
            if (at == '>' && bufferedContent.charAt(i - 1) == ']' && bufferedContent.charAt(i - 2) == ']') {
                bufferedContent.replace(i, i + 1, GREATER_THAN_ENTITY);
                size += 3;
                i += 3;
                continue;
            }
            if (at == '\u00f7') {
                bufferedContent.replace(i, i + 1, DIVISION_CHAR);
                continue;
            }
            if (at > '\b' && at != '\u000b' && at != '\f' && (at < '\u000e' || at > '\u001f') && at != '\ufffe' && at != '\uffff') continue;
            bufferedContent.delete(i, i + 1);
        }
    }

    static {
        int j;
        int i;
        CHARS = new byte[65536];
        int[] nameChar = new int[]{45, 46};
        int[] nameStartChar = new int[]{58, 95};
        int[] letterRange = new int[]{65, 90, 97, 122, 192, 214, 216, 246, 248, 305, 308, 318, 321, 328, 330, 382, 384, 451, 461, 496, 500, 501, 506, 535, 592, 680, 699, 705, 904, 906, 910, 929, 931, 974, 976, 982, 994, 1011, 1025, 1036, 1038, 1103, 1105, 1116, 1118, 1153, 1168, 1220, 1223, 1224, 1227, 1228, 1232, 1259, 1262, 1269, 1272, 1273, 1329, 1366, 1377, 1414, 1488, 1514, 1520, 1522, 1569, 1594, 1601, 1610, 1649, 1719, 1722, 1726, 1728, 1742, 1744, 1747, 1765, 1766, 2309, 2361, 2392, 2401, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2486, 2489, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2674, 2676, 2693, 2699, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2870, 2873, 2908, 2909, 2911, 2913, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 2997, 2999, 3001, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3296, 3297, 3333, 3340, 3342, 3344, 3346, 3368, 3370, 3385, 3424, 3425, 3585, 3630, 3634, 3635, 3648, 3653, 3713, 3714, 3719, 3720, 3732, 3735, 3737, 3743, 3745, 3747, 3754, 3755, 3757, 3758, 3762, 3763, 3776, 3780, 3904, 3911, 3913, 3945, 4256, 4293, 4304, 4342, 4354, 4355, 4357, 4359, 4363, 4364, 4366, 4370, 4436, 4437, 4447, 4449, 4461, 4462, 4466, 4467, 4526, 4527, 4535, 4536, 4540, 4546, 7680, 7835, 7840, 7929, 7936, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8031, 8061, 8064, 8116, 8118, 8124, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8490, 8491, 8576, 8578, 12353, 12436, 12449, 12538, 12549, 12588, 44032, 55203, 12321, 12329, 19968, 40869};
        int[] letterChar = new int[]{902, 908, 986, 988, 990, 992, 1369, 1749, 2365, 2482, 2654, 2701, 2749, 2784, 2877, 2972, 3294, 3632, 3716, 3722, 3725, 3749, 3751, 3760, 3773, 4352, 4361, 4412, 4414, 4416, 4428, 4430, 4432, 4441, 4451, 4453, 4455, 4457, 4469, 4510, 4520, 4523, 4538, 4587, 4592, 4601, 8025, 8027, 8029, 8126, 8486, 8494, 12295};
        int[] combiningCharRange = new int[]{768, 837, 864, 865, 1155, 1158, 1425, 1441, 1443, 1465, 1467, 1469, 1473, 1474, 1611, 1618, 1750, 1756, 1757, 1759, 1760, 1764, 1767, 1768, 1770, 1773, 2305, 2307, 2366, 2380, 2385, 2388, 2402, 2403, 2433, 2435, 2496, 2500, 2503, 2504, 2507, 2509, 2530, 2531, 2624, 2626, 2631, 2632, 2635, 2637, 2672, 2673, 2689, 2691, 2750, 2757, 2759, 2761, 2763, 2765, 2817, 2819, 2878, 2883, 2887, 2888, 2891, 2893, 2902, 2903, 2946, 2947, 3006, 3010, 3014, 3016, 3018, 3021, 3073, 3075, 3134, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3202, 3203, 3262, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3330, 3331, 3390, 3395, 3398, 3400, 3402, 3405, 3636, 3642, 3655, 3662, 3764, 3769, 3771, 3772, 3784, 3789, 3864, 3865, 3953, 3972, 3974, 3979, 3984, 3989, 3993, 4013, 4017, 4023, 8400, 8412, 12330, 12335};
        int[] combiningCharChar = new int[]{1471, 1476, 1648, 2364, 2381, 2492, 2494, 2495, 2519, 2562, 2620, 2622, 2623, 2748, 2876, 3031, 3415, 3633, 3761, 3893, 3895, 3897, 3902, 3903, 3991, 4025, 8417, 12441, 12442};
        int[] digitRange = new int[]{48, 57, 1632, 1641, 1776, 1785, 2406, 2415, 2534, 2543, 2662, 2671, 2790, 2799, 2918, 2927, 3047, 3055, 3174, 3183, 3302, 3311, 3430, 3439, 3664, 3673, 3792, 3801, 3872, 3881};
        int[] extenderRange = new int[]{12337, 12341, 12445, 12446, 12540, 12542};
        int[] extenderChar = new int[]{183, 720, 721, 903, 1600, 3654, 3782, 12293};
        for (i = 0; i < nameStartChar.length; ++i) {
            int n = nameStartChar[i];
            CHARS[n] = (byte)(CHARS[n] | 3);
        }
        for (i = 0; i < letterRange.length; i += 2) {
            j = letterRange[i];
            while (j <= letterRange[i + 1]) {
                int n = j++;
                CHARS[n] = (byte)(CHARS[n] | 3);
            }
        }
        for (i = 0; i < letterChar.length; ++i) {
            int n = letterChar[i];
            CHARS[n] = (byte)(CHARS[n] | 3);
        }
        for (i = 0; i < nameChar.length; ++i) {
            int n = nameChar[i];
            CHARS[n] = (byte)(CHARS[n] | 2);
        }
        for (i = 0; i < digitRange.length; i += 2) {
            j = digitRange[i];
            while (j <= digitRange[i + 1]) {
                int n = j++;
                CHARS[n] = (byte)(CHARS[n] | 2);
            }
        }
        for (i = 0; i < combiningCharRange.length; i += 2) {
            j = combiningCharRange[i];
            while (j <= combiningCharRange[i + 1]) {
                int n = j++;
                CHARS[n] = (byte)(CHARS[n] | 2);
            }
        }
        for (i = 0; i < combiningCharChar.length; ++i) {
            int n = combiningCharChar[i];
            CHARS[n] = (byte)(CHARS[n] | 2);
        }
        for (i = 0; i < extenderRange.length; i += 2) {
            j = extenderRange[i];
            while (j <= extenderRange[i + 1]) {
                int n = j++;
                CHARS[n] = (byte)(CHARS[n] | 2);
            }
        }
        for (i = 0; i < extenderChar.length; ++i) {
            int n = extenderChar[i];
            CHARS[n] = (byte)(CHARS[n] | 2);
        }
    }
}

