/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.exceptions.ConfigException;
import com.blixx.shared.ext.ForwardCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class ForwardConditions {
    public static final String _DESCRIPTION = "DESCRIPTION";
    public static final String _UUID = "TARGET_ID";
    public UUID uuid = null;
    public String description = null;
    public ArrayList<ForwardCondition> m_targets = null;

    public static ForwardConditions getNew() {
        ForwardConditions cs = new ForwardConditions();
        cs.uuid = UUID.randomUUID();
        cs.description = "";
        cs.m_targets = new ArrayList();
        return cs;
    }

    public static ForwardConditions getInstance(Properties conditionGroup, List<Properties> properties) {
        ForwardConditions cnds = new ForwardConditions();
        try {
            cnds.uuid = UUID.fromString(conditionGroup.getProperty(_UUID));
        }
        catch (RuntimeException e) {
            throw new ConfigException("UUID is incorrect");
        }
        cnds.description = conditionGroup.getProperty(_DESCRIPTION);
        if (cnds.description == null) {
            cnds.description = "";
        }
        cnds.m_targets = new ArrayList();
        for (int i = 0; i < properties.size(); ++i) {
            Properties pr = properties.get(i);
            ForwardCondition c = ForwardCondition.getInstance(pr);
            cnds.m_targets.add(c);
        }
        return cnds;
    }

    public ForwardCondition addNewCondition(String policyName) {
        ForwardCondition c = ForwardCondition.getNew(this.m_targets.size() + 1);
        this.addCondition(c);
        return c;
    }

    public void addCondition(ForwardCondition fc) {
        this.m_targets.add(fc);
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.setProperty(_DESCRIPTION, this.description);
        p.setProperty(_UUID, this.uuid.toString());
        return p;
    }

    public ArrayList<ForwardCondition> getConditionList() {
        return this.m_targets;
    }

    public void removeCondition(ForwardCondition c) {
        this.m_targets.remove(c);
    }
}

