/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.PatternB;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class ForwardFilterJsonAdapter
implements JsonSerializer<ForwardFilter>,
JsonDeserializer<ForwardFilter> {
    public static final String NG_PATHS = "ngPaths";
    public static final String ATTRIBUTE = "attribute";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String NUMBER = "number";
    public static final String PATTERN = "pattern";

    @Override
    public ForwardFilter deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ForwardFilter ff = null;
        if (json.isJsonObject()) {
            JsonObject obj = (JsonObject)json;
            ff = new ForwardFilter();
            if (obj.getAsJsonPrimitive(NG_PATHS) != null) {
                ff = new NodeGroupForwardFilter();
                ((NodeGroupForwardFilter)ff).setPaths(obj.getAsJsonPrimitive(NG_PATHS).getAsString());
            }
            ff.m_attribute = obj.getAsJsonPrimitive(ATTRIBUTE).getAsInt();
            ff.m_name = obj.getAsJsonPrimitive(NAME).getAsString();
            ff.m_description = obj.getAsJsonPrimitive(DESCRIPTION).getAsString();
            ff.m_number = obj.getAsJsonPrimitive(NUMBER).getAsInt();
            String omPattern = obj.getAsJsonPrimitive(PATTERN).getAsString();
            ff.m_pattern = PatternB.getPattern(omPattern);
        }
        return ff;
    }

    @Override
    public JsonElement serialize(ForwardFilter src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty(ATTRIBUTE, src.m_attribute);
        obj.addProperty(NAME, src.m_name);
        obj.addProperty(DESCRIPTION, src.m_description);
        obj.addProperty(NUMBER, src.m_number);
        obj.addProperty(PATTERN, src.m_pattern.getOvPattern());
        if (src instanceof NodeGroupForwardFilter) {
            obj.addProperty(NG_PATHS, ((NodeGroupForwardFilter)src).m_path);
        }
        return obj;
    }
}

