/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.log.RTLogger;
import com.blixx.shared.SecureDocumentBuilderFactory;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.exceptions.ConfigException;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.ExtendedServerPolicy;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyTemplate;
import com.blixx.shared.ext.TimeInterval;
import com.blixx.shared.ext.TimeMask;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerPolicyFactory {
    public static final String FILTER = "FILTER";
    public static final String FILTERS = "FILTERS";
    public static final String ID = "ID";
    public static final String NAME = "NAME";
    public static final String EXPECTED_DURATION = "EXPECTED_DURATION";
    public static final String IET = "IET";
    public static final String ENT = "ENT";
    public static final String ACTION = "ACTION";
    public static final String POSTACTION = "POSTACTION";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String OWNER = "OWNER";
    public static final String ENABLED = "ENABLED";
    public static final String ENABLEDBY = "ENABLEDBY";
    public static final String DISABLEDDBY = "DISABLEDDBY";
    public static final String TI_FT = "TI_FT";
    public static final String TI_INTERVAL = "TI_INTERVAL";
    public static final String TI_MASK = "TI_MASK";
    public static final String SERVER_POLICY = "SERVER_POLICY";
    public static final String SET_HOST = "SET_HOST";
    public static final String SET_APPLICATION = "SET_APPLICATION";
    public static final String SET_GROUP = "SET_GROUP";
    public static final String SET_OBJECT = "SET_OBJECT";
    public static final String SET_SEVERITY = "SET_SEVERITY";
    public static final String SET_TEXT = "SET_TEXT";
    public static final String INSERT_AS_CLOSED = "INSERT_AS_CLOSED";
    public static final String CA = "CA";
    public static final String AWAIT = "AWAIT";
    public static final String AWAIT_DROP_ORIGINAL = "AWAIT_DROP_ORIGINAL";
    public static final String AWAIT_ACKNOWLEDE = "AWAIT_ACKNOWLEDE";
    public static final String AWAIT_INTERVAL = "AWAIT_INTERVAL";
    public static final String AWAIT_SET_TEXT = "AWAIT_SET_TEXT";
    public static final String AWAIT_INSERT_AS_CLOSED = "AWAIT_INSERT_AS_CLOSED";
    public static final String SET_KEY = "SET_KEY";
    public static final String SET_CLOSE_MASK = "SET_CLOSE_MASK";
    public static final String NGFILTERS = "NGFILTERS";
    public static final String SET_AA = "SET_AA";
    public static final String SET_AA_NODE = "SET_AA_NODE";
    public static final String DEDUPL = "DEDUPL";
    public static final String DEDUPL_KEYONLY = "DEDUPL_KEYONLY";
    public static final String IS_OVERWRITE_DEDUPL = "IS_OVERWRITE_DEDUPL";
    public static final String IS_OVERWRITE_KPI = "IS_OVERWRITE_KPI";
    protected String directory = "srv/srv_policies";
    protected File dir;

    public ServerPolicyFactory(String directory) throws Exception {
        if (directory != null) {
            this.directory = directory;
        }
        this.dir = new File(this.directory);
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            throw new Exception("Can't create required directory: " + this.directory);
        }
        if (!this.dir.isDirectory()) {
            throw new Exception("Missed required directory: " + this.directory + ". Conflict file with the same found.");
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public File getDir() {
        return this.dir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OutagePolicy initServerPolicy(File file) {
        if (!file.exists()) return null;
        if (!file.canRead()) return null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            OutagePolicy outagePolicy = this.initServerPolicy(fileInputStream);
            return outagePolicy;
        }
        catch (Exception e) {
            RTLogger.print(1, "Failed processing file: " + file.getName() + " " + e.getMessage());
            RTLogger.print(2, "", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtendedServerPolicy initServerPolicyMSP(File file) {
        if (!file.exists()) return null;
        if (!file.canRead()) return null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ExtendedServerPolicy extendedServerPolicy = this.initServerPolicyMSP(fileInputStream);
            return extendedServerPolicy;
        }
        catch (Exception e) {
            RTLogger.print(1, "Failed processing file: " + file.getName() + " " + e.getMessage());
            RTLogger.print(2, "", e);
        }
        return null;
    }

    public OutagePolicy initServerPolicy(InputStream io) throws SAXException, ParserConfigurationException, IOException {
        Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(io);
        String separator = XMLFactory.getSeparator(doc);
        int version = XMLFactory.getVersion(doc);
        NodeList nlist = doc.getElementsByTagName(SERVER_POLICY);
        if (nlist.getLength() != 1) {
            throw new ConfigException("Invalid SERVER_POLICY");
        }
        Node item = nlist.item(0);
        Node cdata = XMLFactory.searchCDATA(item);
        if (cdata == null) {
            throw new ConfigException("Error: NO CDATA section found for:" + item.getNodeName());
        }
        String data = cdata.getNodeValue().trim();
        Properties mainProperties = XMLFactory.extractProperties(separator, data);
        mainProperties.setProperty("VERSION", "" + version);
        List<ForwardFilter> ff = this.parseFilters(FILTERS, doc, separator);
        return this.createServerPolicy(mainProperties, ff);
    }

    public ExtendedServerPolicy initServerPolicyMSP(InputStream io) throws SAXException, ParserConfigurationException, IOException {
        Document doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(io);
        String separator = XMLFactory.getSeparator(doc);
        int version = XMLFactory.getVersion(doc);
        NodeList nlist = doc.getElementsByTagName(SERVER_POLICY);
        if (nlist.getLength() != 1) {
            throw new ConfigException("Invalid SERVER_POLICY");
        }
        Node item = nlist.item(0);
        Node cdata = XMLFactory.searchCDATA(item);
        if (cdata == null) {
            throw new ConfigException("Error: NO CDATA section found for:" + item.getNodeName());
        }
        String data = cdata.getNodeValue().trim();
        Properties mainProperties = XMLFactory.extractProperties(separator, data);
        mainProperties.setProperty("VERSION", "" + version);
        List<ForwardFilter> ff = this.parseFilters(FILTERS, doc, separator);
        List<ForwardFilter> ngFilters = this.parseFilters(NGFILTERS, doc, separator);
        return this.createServerPolicyMSP(mainProperties, ff, ngFilters);
    }

    public OutagePolicy createServerPolicy(Properties mainAttributes, List<ForwardFilter> filters) throws ParserConfigurationException {
        String uuid = mainAttributes.getProperty(ID);
        if (uuid == null) {
            throw new ParserConfigurationException("Empty ID");
        }
        String name = mainAttributes.getProperty(NAME);
        if (name == null) {
            throw new ParserConfigurationException("Empty NAME");
        }
        InitServerPolicy sp = new InitServerPolicy(uuid, name);
        String value = mainAttributes.getProperty(EXPECTED_DURATION);
        try {
            sp.setExpectedDuration(Long.parseLong(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(ENT);
        try {
            sp.setIsEnableTime(Long.parseLong(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(IET);
        try {
            sp.setIsEndTime(Long.parseLong(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(ACTION);
        try {
            sp.setAction(Integer.parseInt(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(POSTACTION);
        try {
            sp.setPostAction(Integer.parseInt(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(DESCRIPTION);
        if (value != null) {
            sp.setDescription(value);
        }
        if ((value = mainAttributes.getProperty(ENABLED)) != null) {
            sp.setEnabled(Boolean.parseBoolean(value));
        }
        if ((value = mainAttributes.getProperty(OWNER)) != null) {
            sp.setOwner(value);
        }
        if ((value = mainAttributes.getProperty(ENABLEDBY)) != null) {
            sp.setEnabledBy(value);
        }
        if ((value = mainAttributes.getProperty(DISABLEDDBY)) != null) {
            sp.setDisabledBy(value);
        }
        String ti_firstTime = mainAttributes.getProperty(TI_FT);
        String ti_interval = mainAttributes.getProperty(TI_INTERVAL);
        String ti_mask = mainAttributes.getProperty(TI_MASK);
        if (ti_firstTime != null) {
            try {
                TimeMask tm = null;
                if (ti_mask != null && ti_mask.length() > 10) {
                    tm = new TimeMask(ti_mask);
                }
                TimeInterval ti = new TimeInterval(Long.parseLong(ti_firstTime), Long.parseLong(ti_interval), tm);
                sp.setTimeInterval(ti);
            }
            catch (Throwable e) {
                RTLogger.print(3, "TimeInterval error parsing: " + sp + " tm " + ti_mask);
            }
        }
        sp.setFilters(filters);
        return sp;
    }

    public ExtendedServerPolicy createServerPolicyMSP(Properties mainAttributes, List<ForwardFilter> filters, List<ForwardFilter> ng_filters) throws ParserConfigurationException {
        String uuid = mainAttributes.getProperty(ID);
        if (uuid == null) {
            throw new ParserConfigurationException("Empty ID");
        }
        String name = mainAttributes.getProperty(NAME);
        if (name == null) {
            throw new ParserConfigurationException("Empty NAME");
        }
        InitExtendedServerPolicy sp = new InitExtendedServerPolicy(uuid, name);
        String value = mainAttributes.getProperty(EXPECTED_DURATION);
        try {
            sp.setExpectedDuration(Long.parseLong(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(ENT);
        try {
            sp.setIsEnableTime(Long.parseLong(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(IET);
        try {
            sp.setIsEndTime(Long.parseLong(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(ACTION);
        try {
            sp.setAction(Integer.parseInt(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(POSTACTION);
        try {
            sp.setPostAction(Integer.parseInt(value));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
        }
        value = mainAttributes.getProperty(DESCRIPTION);
        if (value != null) {
            sp.setDescription(value);
        }
        if ((value = mainAttributes.getProperty(ENABLED)) != null) {
            sp.setEnabled(Boolean.parseBoolean(value));
        }
        if ((value = mainAttributes.getProperty(OWNER)) != null) {
            sp.setOwner(value);
        }
        if ((value = mainAttributes.getProperty(ENABLEDBY)) != null) {
            sp.setEnabledBy(value);
        }
        if ((value = mainAttributes.getProperty(DISABLEDDBY)) != null) {
            sp.setDisabledBy(value);
        }
        String ti_firstTime = mainAttributes.getProperty(TI_FT);
        String ti_interval = mainAttributes.getProperty(TI_INTERVAL);
        String ti_mask = mainAttributes.getProperty(TI_MASK);
        if (ti_firstTime != null) {
            try {
                TimeMask tm = null;
                if (ti_mask != null && ti_mask.length() > 10) {
                    tm = new TimeMask(ti_mask);
                }
                TimeInterval ti = new TimeInterval(Long.parseLong(ti_firstTime), Long.parseLong(ti_interval), tm);
                sp.setTimeInterval(ti);
            }
            catch (Throwable e) {
                RTLogger.print(3, "TimeInterval error parsing: " + sp + " tm " + ti_mask);
            }
        }
        sp.setFilters(filters);
        value = mainAttributes.getProperty(SET_HOST);
        if (value != null) {
            sp.setSetHost(value);
        }
        if ((value = mainAttributes.getProperty(SET_APPLICATION)) != null) {
            sp.setSetApplication(value);
        }
        if ((value = mainAttributes.getProperty(SET_GROUP)) != null) {
            sp.setSetGroup(value);
        }
        if ((value = mainAttributes.getProperty(SET_OBJECT)) != null) {
            sp.setSetObject(value);
        }
        if ((value = mainAttributes.getProperty(SET_SEVERITY)) != null) {
            sp.setSetSeverity(value);
        }
        if ((value = mainAttributes.getProperty(SET_TEXT)) != null) {
            sp.setSetText(value);
        }
        if ((value = mainAttributes.getProperty(INSERT_AS_CLOSED)) != null) {
            try {
                sp.setInsertAsClosed(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
            }
        }
        if ((value = mainAttributes.getProperty(AWAIT)) != null) {
            try {
                sp.setAwait(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
            }
        }
        if ((value = mainAttributes.getProperty(AWAIT_DROP_ORIGINAL)) != null) {
            try {
                sp.setAwaitDropOriginal(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
            }
        }
        if ((value = mainAttributes.getProperty(AWAIT_ACKNOWLEDE)) != null) {
            sp.setAwaitAcknowledge(Boolean.parseBoolean(value));
        }
        if ((value = mainAttributes.getProperty(AWAIT_INSERT_AS_CLOSED)) != null) {
            sp.setAwaitInsertAsClosed(Boolean.parseBoolean(value));
        }
        if ((value = mainAttributes.getProperty(AWAIT_INTERVAL)) != null) {
            sp.setAwaitInterval(value);
        }
        if ((value = mainAttributes.getProperty(AWAIT_SET_TEXT)) != null) {
            sp.setAwaitSetText(value);
        }
        if ((value = mainAttributes.getProperty(SET_KEY)) != null) {
            sp.setSetKey(value);
        }
        if ((value = mainAttributes.getProperty(SET_CLOSE_MASK)) != null) {
            sp.setSetCloseMask(value);
        }
        if ((value = mainAttributes.getProperty(SET_AA)) != null) {
            sp.setSetAutoAction(value);
        }
        if ((value = mainAttributes.getProperty(SET_AA_NODE)) != null) {
            sp.setSetAutoActionNode(value);
        }
        if ((value = mainAttributes.getProperty(DEDUPL)) != null) {
            try {
                sp.setDeduplicate(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
            }
        }
        if ((value = mainAttributes.getProperty(DEDUPL_KEYONLY)) != null) {
            try {
                sp.setDeduplicateKeyOnly(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
            }
        }
        if ((value = mainAttributes.getProperty(IS_OVERWRITE_DEDUPL)) != null) {
            try {
                sp.setOverwriteDeDuplication(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
            }
        }
        if ((value = mainAttributes.getProperty(IS_OVERWRITE_KPI)) != null) {
            try {
                sp.setOverwriteAV_KPI(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().debug("error parsing : {}", (Object)value, (Object)e);
            }
        }
        for (int i = 1; i <= 15; ++i) {
            value = mainAttributes.getProperty(CA + i);
            if (value == null) continue;
            sp.addCAs(CA + i, value);
        }
        sp.setNodeGroupFilters(ng_filters);
        return sp;
    }

    public void saveServerPolicy(OutagePolicy sp) {
        File file = this.getFile(sp);
        Document doc = this.createXML(sp);
        XMLFactory.writeXml(doc, file);
    }

    public void saveExtendedServerPolicy(ExtendedServerPolicy sp) {
        File file = this.getFile(sp);
        Document doc = this.createXML(sp);
        XMLFactory.writeXml(doc, file);
    }

    public File getFile(ServerPolicyTemplate sp) {
        File file = null;
        if (sp instanceof ExtendedServerPolicy) {
            file = new File(this.getDir(), sp.getID() + ".mp.xml");
        } else if (sp instanceof OutagePolicy) {
            file = new File(this.getDir(), sp.getID() + ".sp.xml");
        } else if (sp instanceof AgentOutagePolicy) {
            file = new File(this.getDir(), sp.getID() + ".ap.xml");
        }
        return file;
    }

    public Document createXML(OutagePolicy sp) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("SP");
            Element separator = doc.createElement("SEPARATOR");
            separator.setTextContent("\u25ba");
            root.appendChild(separator);
            Element spMain = XMLFactory.getCDATA(doc, SERVER_POLICY, this.getMainProperties(sp), "\u25ba");
            root.appendChild(spMain);
            Element ffSubRoot = doc.createElement(FILTERS);
            root.appendChild(ffSubRoot);
            List<ForwardFilter> arr = sp.getFilters();
            for (ForwardFilter forwardFilter : arr) {
                Element cel = XMLFactory.getCDATA(doc, FILTER, forwardFilter.getProperties(), "\u25ba");
                ffSubRoot.appendChild(cel);
            }
            root.appendChild(ffSubRoot);
            doc.appendChild(root);
        }
        catch (Throwable e) {
            RTLogger.print(1, "Failed creation of ServerPolicy xml: " + e.getMessage());
            RTLogger.print(2, "", e);
        }
        return doc;
    }

    public Document createXML(ExtendedServerPolicy mp) {
        Document doc = null;
        try {
            doc = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("SP");
            Element separator = doc.createElement("SEPARATOR");
            separator.setTextContent("\u25ba");
            root.appendChild(separator);
            Element spMain = XMLFactory.getCDATA(doc, SERVER_POLICY, this.getMainPropertiesMSP(mp), "\u25ba");
            root.appendChild(spMain);
            Element ffSubRoot = doc.createElement(FILTERS);
            List<ForwardFilter> arr = mp.getFilters();
            for (ForwardFilter forwardFilter : arr) {
                Element cel = XMLFactory.getCDATA(doc, FILTER, forwardFilter.getProperties(), "\u25ba");
                ffSubRoot.appendChild(cel);
            }
            root.appendChild(ffSubRoot);
            Element ngffSubRoot = doc.createElement(NGFILTERS);
            List<ForwardFilter> ng_arr = mp.getNodeGroupFilters();
            for (ForwardFilter forwardFilter : ng_arr) {
                Element cel = XMLFactory.getCDATA(doc, FILTER, forwardFilter.getProperties(), "\u25ba");
                ngffSubRoot.appendChild(cel);
            }
            root.appendChild(ngffSubRoot);
            doc.appendChild(root);
        }
        catch (Exception e) {
            RTLogger.print(1, "Failed creation of ServerPolicy xml: " + e.getMessage());
            RTLogger.print(2, "", e);
        }
        return doc;
    }

    protected Properties getMainProperties(OutagePolicy sp) {
        Properties pr = new Properties();
        pr.setProperty(ID, sp.getID());
        pr.setProperty(NAME, sp.getName());
        pr.setProperty(EXPECTED_DURATION, "" + sp.getExpectedDuration());
        pr.setProperty(ENT, "" + sp.getIsEnableTime());
        pr.setProperty(IET, "" + sp.getIsEndTime());
        pr.setProperty(ACTION, "" + sp.getAction());
        pr.setProperty(POSTACTION, "" + sp.getPostAction());
        pr.setProperty(DESCRIPTION, sp.getDescription());
        pr.setProperty(ENABLED, "" + sp.isEnabled());
        pr.setProperty(ENABLEDBY, sp.getEnabledBy());
        pr.setProperty(OWNER, sp.getOwner());
        pr.setProperty(DISABLEDDBY, sp.getDisabledBy());
        if (sp.getTimeInterval() != null) {
            pr.setProperty(TI_FT, "" + sp.getTimeInterval().getFirstStart());
            pr.setProperty(TI_INTERVAL, "" + sp.getTimeInterval().getInterval());
            TimeMask timeMask = sp.getTimeInterval().getTimeMask();
            if (timeMask != null && timeMask.getMask() != null && timeMask.getMask().length() > 10) {
                pr.setProperty(TI_MASK, "" + timeMask.getMask());
            }
        }
        return pr;
    }

    protected Properties getMainPropertiesMSP(ExtendedServerPolicy mp) {
        Properties pr = this.getMainProperties(mp);
        pr.setProperty(OWNER, mp.getOwner());
        pr.setProperty(SET_HOST, mp.getSetHost());
        pr.setProperty(SET_APPLICATION, mp.getSetApplication());
        pr.setProperty(SET_GROUP, mp.getSetGroup());
        pr.setProperty(SET_OBJECT, mp.getSetObject());
        pr.setProperty(SET_TEXT, mp.getSetText());
        pr.setProperty(SET_SEVERITY, mp.getSetSeverity());
        pr.setProperty(INSERT_AS_CLOSED, "" + mp.isInsertAsClosed());
        pr.setProperty(AWAIT, "" + mp.isAwait());
        pr.setProperty(AWAIT_DROP_ORIGINAL, "" + mp.isAwaitDropOriginal());
        pr.setProperty(AWAIT_ACKNOWLEDE, "" + mp.isAwaitAcknowlede());
        pr.setProperty(AWAIT_INTERVAL, mp.getAwaitInterval());
        pr.setProperty(AWAIT_SET_TEXT, mp.getAwaitSetText());
        pr.setProperty(AWAIT_INSERT_AS_CLOSED, "" + mp.isAwaitInsertAsClosed());
        pr.setProperty(SET_KEY, mp.getSetKey());
        pr.setProperty(SET_CLOSE_MASK, mp.getSetCloseMask());
        pr.setProperty(SET_AA, mp.getSetAutoAction());
        pr.setProperty(SET_AA_NODE, mp.getSetAutoActionNode());
        pr.setProperty(DEDUPL, "" + mp.isDeduplicate());
        pr.setProperty(DEDUPL_KEYONLY, "" + mp.isDeduplicateKeyOnly());
        pr.setProperty(IS_OVERWRITE_DEDUPL, "" + mp.isOverwriteDeDuplication());
        pr.setProperty(IS_OVERWRITE_KPI, "" + mp.isOverwriteAV_KPI());
        Map<String, String> cas = mp.getCAs();
        if (cas != null && cas.size() > 0) {
            for (Map.Entry<String, String> en : cas.entrySet()) {
                pr.setProperty(en.getKey(), en.getValue());
            }
        }
        return pr;
    }

    public List<ForwardFilter> parseFilters(String groupTagName, Document doc, String separator) throws ParserConfigurationException {
        ArrayList<ForwardFilter> listOfCondition = new ArrayList<ForwardFilter>(0);
        NodeList nlist = doc.getElementsByTagName(groupTagName);
        if (nlist.getLength() > 0) {
            Node item = nlist.item(0);
            Document docMonitor = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node newMon = docMonitor.importNode(item, true);
            docMonitor.appendChild(newMon);
            NodeList condList = docMonitor.getElementsByTagName(FILTER);
            listOfCondition.ensureCapacity(condList.getLength());
            for (int k = 0; k < condList.getLength(); ++k) {
                Node cdataCond = XMLFactory.searchCDATA(condList.item(k));
                String ddata = cdataCond.getNodeValue();
                Properties cprops = XMLFactory.extractProperties(separator, ddata);
                try {
                    listOfCondition.add(ForwardFilter.getInstance(cprops));
                    continue;
                }
                catch (RuntimeException e) {
                    RTLogger.print(3, "Forward Filter init failed.", e);
                }
            }
        }
        return listOfCondition;
    }

    public static class InitExtendedServerPolicy
    extends ExtendedServerPolicy {
        public InitExtendedServerPolicy(String uuid, String name) {
            super(uuid, name);
        }

        public void setEnabledBy(String enabledBy) {
            this.m_enabledBy = enabledBy;
        }

        public void setDisabledBy(String disabledBy) {
            this.m_disabledBy = disabledBy;
        }

        public void setEnabled(boolean state) {
            this.m_enabled.set(state);
        }
    }

    public static class InitServerPolicy
    extends OutagePolicy {
        public InitServerPolicy(String uuid, String name) {
            super(uuid, name);
        }

        public void setEnabledBy(String enabledBy) {
            this.m_enabledBy = enabledBy;
        }

        public void setDisabledBy(String disabledBy) {
            this.m_disabledBy = disabledBy;
        }

        public void setEnabled(boolean state) {
            this.m_enabled.set(state);
        }
    }
}

