/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.log.RTLogger;
import com.blixx.shared.IID;
import com.blixx.shared.IODataStream;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.IServerPolicyListener;
import com.blixx.shared.ext.TimeInterval;
import com.blixx.shared.ext.TimeMask;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerPolicyTemplate
implements IID,
IODataStream {
    public static final String ACTION_UNKNOWN = "UNKNOWN";
    public static final String ACTION_NONE = "NONE";
    public static final String ACTION_DROP = "DROP";
    public static final String ACTION_DELAY = "DELAY";
    public static final String ACTION_HIDE = "HIDE";
    public static final String ACTION_MODIFY = "MODIFY";
    public static final String ACTION_PUBLISH = "PUBLISH";
    public static final int ACTION_NONE_INT = 0;
    public static final int ACTION_DROP_INT = 1;
    public static final int ACTION_DELAY_INT = 2;
    public static final int ACTION_HIDE_INT = 3;
    public static final int ACTION_MODIFY_INT = 4;
    public static final int ACTION_PUBLISH_INT = 5;
    protected int m_action = 3;
    protected String m_disabledBy = "";
    protected AtomicBoolean m_enabled = new AtomicBoolean(false);
    protected long m_expectedDuration = -1L;
    protected List<ForwardFilter> m_filters = new ArrayList<ForwardFilter>(1);
    protected long m_isEnableTime = -1L;
    protected long m_isDisableTime = -1L;
    protected transient List<IServerPolicyListener> m_listeners = new ArrayList<IServerPolicyListener>(1);
    protected int m_postAction = 0;
    protected String m_UUID = null;
    protected AtomicBoolean m_active = new AtomicBoolean(false);
    protected TimeInterval m_timeInterval = null;
    protected String m_enabledBy = "";
    protected String m_owner = "";

    public ServerPolicyTemplate() {
        try {
            this.m_timeInterval = new TimeInterval(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getActionLabel(int action) {
        switch (action) {
            case 1: {
                return ACTION_DROP;
            }
            case 2: {
                return ACTION_DELAY;
            }
            case 3: {
                return ACTION_HIDE;
            }
            case 4: {
                return ACTION_MODIFY;
            }
            case 0: {
                return ACTION_NONE;
            }
            case 5: {
                return ACTION_PUBLISH;
            }
        }
        return ACTION_UNKNOWN;
    }

    public static int getAction(String action) {
        if (ACTION_DROP.equalsIgnoreCase(action)) {
            return 1;
        }
        if (ACTION_DELAY.equalsIgnoreCase(action)) {
            return 2;
        }
        if (ACTION_HIDE.equalsIgnoreCase(action)) {
            return 3;
        }
        if (ACTION_MODIFY.equalsIgnoreCase(action)) {
            return 4;
        }
        if (ACTION_NONE.equalsIgnoreCase(action)) {
            return 0;
        }
        if (ACTION_PUBLISH.equalsIgnoreCase(action)) {
            return 5;
        }
        return -1;
    }

    public boolean isActive() {
        if (this.m_timeInterval != null) {
            this.setActive(this.m_timeInterval.isActive());
        }
        return this.m_active.get();
    }

    public boolean isEnabled() {
        return this.m_enabled.get();
    }

    public void setTimeInterval(TimeInterval tm) {
        this.m_timeInterval = tm;
    }

    public TimeInterval getTimeInterval() {
        return this.m_timeInterval;
    }

    public long getExpectedDuration() {
        return this.m_expectedDuration;
    }

    public void setExpectedDuration(long expectedDuration) {
        this.m_expectedDuration = expectedDuration;
    }

    public int getAction() {
        return this.m_action;
    }

    public String getActionName() {
        return ServerPolicyTemplate.getActionLabel(this.m_action);
    }

    public void setAction(int action) {
        this.m_action = action;
    }

    public int getPostAction() {
        return this.m_postAction;
    }

    public void setPostAction(int postAction) {
        this.m_postAction = postAction;
    }

    public boolean check(SEventFwd indication) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        for (ForwardFilter ff : this.m_filters) {
            if (ff.checkEvent(indication)) continue;
            return false;
        }
        return true;
    }

    public String getEnabledBy() {
        return this.m_enabledBy;
    }

    @Override
    public String getID() {
        return this.m_UUID;
    }

    public void setID(String uUID) {
        this.m_UUID = uUID;
    }

    public long getIsEnableTime() {
        return this.m_isEnableTime;
    }

    public long getIsEndTime() {
        return this.m_isDisableTime;
    }

    protected void setIsEndTime(long isEndTime) {
        this.m_isDisableTime = isEndTime;
    }

    protected void setIsEnableTime(long isEndTime) {
        this.m_isEnableTime = isEndTime;
    }

    public String getDisabledBy() {
        return this.m_disabledBy;
    }

    public List<ForwardFilter> getFilters() {
        return this.m_filters;
    }

    public void setFilters(List<ForwardFilter> filters) {
        this.m_filters.clear();
        this.addFilters(filters);
    }

    public boolean addFilters(List<ForwardFilter> filters) {
        return this.m_filters.addAll(filters);
    }

    public void addFilter(ForwardFilter filter) {
        this.m_filters.add(filter);
    }

    public boolean removeFilter(ForwardFilter filter) {
        return this.m_filters.remove(filter);
    }

    public List<ForwardFilter> getFiltersCopy() {
        return new ArrayList<ForwardFilter>(this.m_filters);
    }

    public void setNewFilters(List<ForwardFilter> filters) {
        this.m_filters.clear();
        this.m_filters.addAll(filters);
    }

    protected void onActivate() {
        for (IServerPolicyListener l : this.m_listeners) {
            l.onEvent(1, this);
        }
    }

    protected void onDeactivate() {
        for (IServerPolicyListener l : this.m_listeners) {
            l.onEvent(2, this);
        }
    }

    protected void setActive(boolean active) {
        if (this.m_active.compareAndSet(!active, active)) {
            if (active) {
                this.onActivate();
            } else {
                this.onDeactivate();
            }
        }
    }

    public void addListener(IServerPolicyListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<IServerPolicyListener>(1);
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void setEnabled(String byWho) {
        if (this.m_enabled.compareAndSet(false, true)) {
            this.m_enabledBy = byWho;
            this.m_disabledBy = "";
            this.onEnable();
        }
    }

    public void setDisabled(String byWho, int serverListenerCode) {
        if (this.m_enabled.compareAndSet(true, false)) {
            this.m_disabledBy = byWho;
            this.onDisable(serverListenerCode);
        }
    }

    public void setDisabled(String byWho) {
        if (this.m_enabled.compareAndSet(true, false)) {
            this.m_disabledBy = byWho;
            int eventCode = 5;
            switch (this.m_postAction) {
                case 5: {
                    eventCode = 7;
                    break;
                }
                case 1: {
                    eventCode = 6;
                    break;
                }
            }
            this.onDisable(eventCode);
        }
    }

    protected void onEnable() {
        this.m_isEnableTime = System.currentTimeMillis();
        this.setIsEndTime(-1L);
        for (IServerPolicyListener l : this.m_listeners) {
            l.onEvent(3, this);
        }
    }

    protected void onDisable() {
        this.setIsEndTime(System.currentTimeMillis());
        for (IServerPolicyListener l : this.m_listeners) {
            l.onEvent(4, this);
        }
    }

    protected void onDisable(int serverListenerCode) {
        this.setIsEndTime(System.currentTimeMillis());
        for (IServerPolicyListener l : this.m_listeners) {
            l.onEvent(serverListenerCode, this);
        }
    }

    public int hashCode() {
        return this.m_UUID.hashCode();
    }

    public boolean equals(Object obj) {
        boolean ie = false;
        if (obj instanceof ServerPolicyTemplate) {
            ServerPolicyTemplate sp = (ServerPolicyTemplate)obj;
            if ((this.m_UUID == sp.m_UUID || this.m_UUID != null && this.m_UUID.equals(sp.m_UUID)) && (this.m_owner == sp.m_owner || this.m_owner != null && this.m_owner.equals(sp.m_owner)) && this.m_action == sp.m_action && this.m_postAction == sp.m_postAction && this.m_expectedDuration == sp.m_expectedDuration && (this.m_disabledBy == sp.m_disabledBy || this.m_disabledBy != null && this.m_disabledBy.equals(sp.m_disabledBy)) && this.m_enabled.get() == sp.m_enabled.get() && (this.m_enabledBy == sp.m_enabledBy || this.m_enabledBy != null && this.m_enabledBy.equals(sp.m_enabledBy)) && this.m_isDisableTime == sp.m_isDisableTime && (this.m_timeInterval == sp.m_timeInterval || this.m_timeInterval != null && this.m_timeInterval.equals(sp.m_timeInterval))) {
                ie = Arrays.equals(this.m_filters.toArray(), sp.m_filters.toArray());
            }
        }
        return ie;
    }

    @Override
    public Object read(SDataInputStream is) throws IOException {
        this.m_UUID = is.readUTF();
        this.m_owner = is.readUTF();
        this.m_action = is.readInt();
        this.m_expectedDuration = is.readLong();
        this.m_isEnableTime = is.readLong();
        this.m_isDisableTime = is.readLong();
        this.m_postAction = is.readInt();
        long firstStart = is.readLong();
        long interval = is.readLong();
        String mask = is.readUTF();
        while (is.readBoolean()) {
            int countProps = is.readInt();
            Properties prop = new Properties();
            for (int i = 0; i < countProps; ++i) {
                String key = is.readUTF();
                String value = is.readUTF();
                prop.setProperty(key, value);
            }
            try {
                ForwardFilter ff = ForwardFilter.getInstance(prop);
                this.m_filters.add(ff);
            }
            catch (Throwable e) {
                RTLogger.print(2, "Invalid Filter: " + prop, e);
            }
        }
        TimeMask tm = null;
        if (mask != null && mask.length() > 0) {
            try {
                tm = new TimeMask(mask);
            }
            catch (Exception e) {
                RTLogger.print(2, "Invalid TimeMask: " + mask, e);
            }
        }
        try {
            this.m_timeInterval = new TimeInterval(firstStart, interval, tm);
        }
        catch (Exception e) {
            RTLogger.print(2, "Invalid TimeInterval: " + interval, e);
            try {
                this.m_timeInterval = new TimeInterval(firstStart, 0L, tm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_UUID);
        os.writeUTF(this.m_owner);
        os.writeInt(this.m_action);
        os.writeLong(this.m_expectedDuration);
        os.writeLong(this.m_isEnableTime);
        os.writeLong(this.m_isDisableTime);
        os.writeInt(this.m_postAction);
        os.writeLong(this.m_timeInterval.getFirstStart());
        os.writeLong(this.m_timeInterval.getInterval());
        String mask = "";
        if (this.m_timeInterval.getTimeMask() != null) {
            mask = this.m_timeInterval.getTimeMask().getMask();
        }
        os.writeUTF(mask);
        Iterator<ForwardFilter> it = this.getFilters().iterator();
        os.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            ForwardFilter forwardFilter = it.next();
            Properties p = forwardFilter.getProperties();
            os.writeInt(p.size());
            for (Map.Entry<Object, Object> en : p.entrySet()) {
                String key = (String)en.getKey();
                String value = (String)en.getValue();
                if (value == null) {
                    value = "";
                }
                os.writeUTF(key);
                os.writeUTF(value);
            }
            os.writeBoolean(it.hasNext());
        }
    }

    public String getOwner() {
        return this.m_owner;
    }

    public void setOwner(String owner) {
        this.m_owner = owner;
    }

    public void setActiveFORCE(boolean isActive) {
        this.m_active.set(isActive);
    }

    public void setEnabledByFORCE(String who) {
        this.m_enabledBy = who;
    }

    public void setDisabledByFORCE(String who) {
        this.m_disabledBy = who;
    }

    public void setEnabledFORCE(boolean isEnabled) {
        this.m_enabled.set(isEnabled);
    }
}

