/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.ext.TimeMask;

public class TimeInterval {
    public long m_firstStart = 0L;
    public long m_interval = Long.MAX_VALUE;
    public TimeMask m_timeMask = null;

    public TimeInterval(long firstStart, long interval, TimeMask tm) throws Exception {
        this.m_firstStart = firstStart;
        if (interval <= 0L) {
            throw new Exception("Invalid Interval");
        }
        if (interval <= 1000L) {
            throw new Exception("Invalid Interval (less than a second)");
        }
        this.m_interval = interval;
        this.m_timeMask = tm;
        if (this.m_timeMask != null) {
            long nextstart = this.m_timeMask.getNextTime();
            if (firstStart <= 0L) {
                this.m_firstStart = nextstart;
            }
        }
    }

    public TimeInterval(long firstStart, long interval) throws Exception {
        this(firstStart, interval, null);
    }

    public TimeInterval(long firstStart) throws Exception {
        this(firstStart, Long.MAX_VALUE, null);
    }

    public long getFirstStart() {
        return this.m_firstStart;
    }

    public TimeMask getTimeMask() {
        return this.m_timeMask;
    }

    public boolean isActive() {
        long time = System.currentTimeMillis();
        boolean isActive = this.isActive(time);
        return isActive;
    }

    public boolean isActive(long time) {
        boolean isActive = false;
        try {
            if (time < this.m_firstStart) {
                isActive = false;
            } else if (time >= this.m_firstStart && (this.m_interval == Long.MAX_VALUE || time < this.m_firstStart + this.m_interval && this.m_timeMask == null)) {
                isActive = true;
            } else if (this.m_timeMask != null) {
                this.m_timeMask.setTime(time - this.m_interval);
                long start = this.m_timeMask.getNextTime();
                if (time >= start && (this.m_interval == Long.MAX_VALUE || time < start + this.m_interval)) {
                    isActive = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isActive;
    }

    public boolean isScheduled() {
        boolean isSch = false;
        if (this.m_timeMask != null) {
            try {
                this.m_timeMask.getNextTime();
                isSch = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isSch;
    }

    public long getInterval() {
        return this.m_interval;
    }

    public long getCurrentStart() {
        return this.getCurrentStart(System.currentTimeMillis());
    }

    public long getCurrentStart(long now) {
        if (this.m_firstStart > 0L && now < this.m_firstStart) {
            return this.m_firstStart;
        }
        if (now >= this.m_firstStart && now < this.m_firstStart + this.m_interval) {
            return this.m_firstStart;
        }
        if (this.isScheduled()) {
            this.m_timeMask.setTime(now - this.m_interval + 1L);
            long res = -1L;
            try {
                res = this.m_timeMask.getNextTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return res;
        }
        return -1L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.m_firstStart ^ this.m_firstStart >>> 32);
        result = 31 * result + (int)(this.m_interval ^ this.m_interval >>> 32);
        result = 31 * result + (this.m_timeMask == null ? 0 : this.m_timeMask.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        if (this.m_firstStart != other.m_firstStart) {
            return false;
        }
        if (this.m_interval != other.m_interval) {
            return false;
        }
        return !(this.m_timeMask == null ? other.m_timeMask != null : !this.m_timeMask.equals(other.m_timeMask));
    }
}

