/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeMask {
    private transient Supplier<Long> internalTime = System::currentTimeMillis;
    protected transient List<Integer> filterYear = null;
    protected transient List<Integer> filterMonth = null;
    protected transient List<Integer> filterDay = null;
    protected transient List<Integer> filterHour = null;
    protected transient List<Integer> filterMin = null;
    protected transient List<Integer> filterSec = null;
    protected transient List<Integer> filterDOW = null;
    protected transient List<Integer> filterDOWMOD = null;
    private static final Pattern splitArray = Pattern.compile("\\s*([,-]?)\\s*(\\d+)([Ll]?)\\s*");
    private static final Pattern checkDigitsAndPunkt = Pattern.compile("[\\d\\,\\-\\ \\*L]+");
    protected String mask = null;
    protected transient long nextTime = -1L;
    protected transient TimeZone timeZone = TimeZone.getDefault();

    public TimeMask(String mask, long time) throws Exception {
        this.setTime(time);
        this.setMask(mask);
    }

    public TimeMask(String mask) throws Exception {
        this(mask, System.currentTimeMillis());
    }

    public long getTime() {
        return this.internalTime.get();
    }

    public void setTime(long time) {
        this.internalTime = () -> time;
        this.nextTime = -1L;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeString(long time) {
        Calendar cal = Calendar.getInstance(this.getTimeZone(), Locale.ENGLISH);
        cal.setTimeInMillis(time);
        StringBuilder sb = new StringBuilder();
        String year = new SimpleDateFormat("yyyy").format(cal.getTime());
        String day = new SimpleDateFormat("dd").format(cal.getTime());
        String mon = this.getMonth(cal.get(2) + 1);
        int dow = cal.get(7);
        dow = this.getOurDayOfWeek(dow);
        String dayOfWeek = this.getDayOfWeek(dow);
        SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss");
        String timeStr = sdf2.format(cal.getTime());
        int days2mothEnd = this.getDayNumberFromEnd(cal);
        int countofDayOfWeekWithinMonth = this.getDOWnumber(cal);
        int countofDayOfWeekWithinMonthNegative = this.getDOWnumberFromEnd(cal);
        sb.append(year).append('/').append(mon).append('/').append(day);
        sb.append(' ').append(dayOfWeek).append('(').append(countofDayOfWeekWithinMonth).append(") ");
        sb.append(timeStr);
        sb.append(" ").append(cal.getTimeZone().getID()).append(" ");
        sb.append(" D2ME:").append(days2mothEnd);
        sb.append(" WDME:").append(countofDayOfWeekWithinMonthNegative);
        return sb.toString();
    }

    public int getDayNumberFromEnd(Calendar cal) {
        return cal.get(5) - cal.getActualMaximum(5) - 1;
    }

    public int getDOWnumberFromEnd(Calendar current) {
        int countofDayOfWeekWithinMonthNegative = 0;
        Calendar cal = (Calendar)current.clone();
        int month2 = cal.get(2);
        while (month2 == cal.get(2)) {
            cal.add(6, 7);
            ++countofDayOfWeekWithinMonthNegative;
        }
        return countofDayOfWeekWithinMonthNegative * -1;
    }

    public int getDOWnumber(Calendar current) {
        int countofDayOfWeekWithinMonth = 0;
        Calendar cal = (Calendar)current.clone();
        int month = cal.get(2);
        while (month == cal.get(2)) {
            cal.add(6, -7);
            ++countofDayOfWeekWithinMonth;
        }
        return countofDayOfWeekWithinMonth;
    }

    public int getOurDayOfWeek(int calendarDoW) {
        calendarDoW = calendarDoW == 1 ? 7 : --calendarDoW;
        return calendarDoW;
    }

    public int getCalendarDayOfWeek(int dow) {
        dow = dow == 7 ? 1 : ++dow;
        return dow;
    }

    public void setMask(String mask) throws Exception {
        this.mask = mask;
        this.init(mask);
    }

    public String getMask() {
        return this.mask;
    }

    public long getNextTime() throws Exception {
        return this.getNextTimeFrom(this.internalTime.get(), 1);
    }

    public long getNextTimeFrom(long fromTime, int scheduleStep) throws Exception {
        return this.getTimeFrom(fromTime, scheduleStep, false);
    }

    public long getTimeFrom(long fromTime, int scheduleStep, boolean inverted) throws Exception {
        if (this.filterDay == null) {
            throw new Exception("Please set mask first");
        }
        Calendar cal = Calendar.getInstance(this.getTimeZone(), Locale.ENGLISH);
        cal.setTimeInMillis(fromTime);
        boolean isDST = this.timeZone.inDaylightTime(cal.getTime());
        if (isDST && !this.timeZone.inDaylightTime(cal.getTime())) {
            cal.add(14, -1 * this.timeZone.getDSTSavings());
        }
        long baseline = fromTime;
        for (int i = 0; i < scheduleStep; ++i) {
            cal.add(13, inverted ? -1 : 1);
            this.rollUp(cal, 13, 60, this.filterSec, inverted);
            this.rollUp(cal, 12, 60, this.filterMin, inverted);
            this.rollUp(cal, 11, 25, this.filterHour, inverted);
            if (inverted) {
                this.rollUpYear(this.filterYear, cal, inverted);
                this.rollUpMonth(this.filterMonth, cal, inverted);
                this.rollUpDays(this.filterDay, this.filterDOW, this.filterDOWMOD, cal, inverted);
            } else {
                this.rollUpYear(this.filterYear, cal, inverted);
                this.rollUpMonth(this.filterMonth, cal, inverted);
                this.rollUpDays(this.filterDay, this.filterDOW, this.filterDOWMOD, cal, inverted);
            }
            this.fineAdjustmentHMS(cal, baseline, inverted);
            baseline = cal.getTimeInMillis();
        }
        if (!this.filterMonth.isEmpty() && !this.filterMonth.contains(cal.get(2) + 1)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy-MM-dd_HH:mm:ss.SSS z");
            simpleDateFormat.setTimeZone(this.getTimeZone());
            throw new Exception("expired Interval: " + simpleDateFormat.format(cal.getTime()));
        }
        cal.add(14, -1 * cal.get(14));
        this.nextTime = cal.getTimeInMillis();
        return this.nextTime;
    }

    public long getPreviousTimeFrom(long fromTime, int scheduleStep) throws Exception {
        return this.getTimeFrom(fromTime, scheduleStep, true);
    }

    public long getDuration() throws Exception {
        if (this.filterDay == null) {
            throw new Exception("Please set mask first");
        }
        long currentTime = System.currentTimeMillis();
        long schedule1 = this.getNextTimeFrom(currentTime, 2);
        long schedule2 = this.getNextTimeFrom(currentTime, 3);
        return schedule2 - schedule1;
    }

    public long getNextTimeFromNow() throws Exception {
        this.setTime(System.currentTimeMillis());
        return this.getNextTime();
    }

    private void init(String pattern) throws Exception {
        this.nextTime = -1L;
        PatternB p = PatternB.getPattern("<^[\\d\\,\\-\\*\\ ]+^.y>/<^[\\w\\d\\,\\-\\*\\ L]+^.m>/<^[\\d\\,\\-\\*\\ L]+^.d><_><^[\\w\\d\\,\\-\\*\\ L]+^.dow>(<^[\\d\\,\\-\\*\\ L]+^.dowMod>)<_><^[\\d\\,\\-\\*\\ L]+^.hh>:<^[\\d\\,\\-\\*\\ L]+^.mm>:<^[\\d\\,\\-\\*\\ L]+^.ss>");
        PatternMatchResult matchesR = p.matchesR(pattern);
        if (matchesR.isMatch()) {
            this.filterYear = this.getArray(matchesR.getValue("y"), 1);
            String monthes = this.replaceMonths(matchesR.getValue("m"));
            if (!checkDigitsAndPunkt.matcher(monthes).matches()) {
                throw new Exception("Invalid month pattern: " + monthes);
            }
            this.filterMonth = this.getArray(monthes, 2);
            this.filterDay = this.getArray(matchesR.getValue("d"), 5);
            this.filterHour = this.getArray(matchesR.getValue("hh"), 11);
            this.filterMin = this.getArray(matchesR.getValue("mm"), 12);
            this.filterSec = this.getArray(matchesR.getValue("ss"), 13);
            String days = this.replaceDaysOfWeek(matchesR.getValue("dow"));
            if (!checkDigitsAndPunkt.matcher(days).matches()) {
                throw new Exception("Invalid month pattern");
            }
            this.filterDOW = this.getArray(days, 7);
            this.filterDOWMOD = this.getArray(matchesR.getValue("dowMod"), 8);
            if (this.filterYear.isEmpty() && this.filterMonth.isEmpty() && this.filterDay.isEmpty() && this.filterHour.isEmpty() && this.filterMin.isEmpty() && this.filterDOW.isEmpty() && this.filterDOWMOD.isEmpty()) {
                throw new Exception("Incorrect configuration: " + pattern + ". less than 1 minute is not supported.");
            }
        } else {
            throw new Exception("Incorrect configuration: " + pattern);
        }
    }

    public void rollUpYear(List<Integer> filterYear, Calendar cal, boolean inverted) throws Exception {
        if (!filterYear.isEmpty()) {
            boolean foundNext = false;
            int currentValue = cal.get(1);
            if (inverted) {
                int prevYear = filterYear.stream().filter(y -> y <= currentValue).min(Comparator.comparingInt(y -> Math.abs(y - currentValue))).orElse(-1);
                if (prevYear > 0) {
                    if (prevYear != currentValue) {
                        cal.set(1, prevYear);
                        cal.set(2, 11);
                        cal.set(5, cal.getActualMaximum(5));
                        this.doRollUpHMS(cal, inverted);
                    }
                    foundNext = true;
                }
            } else {
                int nextYear = filterYear.stream().filter(y -> y >= currentValue).min(Comparator.comparingInt(y -> Math.abs(y - currentValue))).orElse(-1);
                if (nextYear > 0) {
                    if (nextYear != currentValue) {
                        cal.set(1, nextYear);
                        cal.set(2, 0);
                        cal.set(5, 1);
                        this.doRollUpHMS(cal, inverted);
                    }
                    foundNext = true;
                }
            }
            if (!foundNext) {
                throw new Exception("expired Interval: year");
            }
        }
    }

    public void rollUpMonth(List<Integer> filterMonth, Calendar cal, boolean inverted) throws Exception {
        if (!filterMonth.isEmpty()) {
            boolean foundNext = false;
            int currentValue = cal.get(2) + 1;
            if (inverted) {
                int prevMonth = filterMonth.stream().filter(m -> m <= currentValue).min(Comparator.comparingInt(m -> Math.abs(m - currentValue))).orElse(-1);
                if (prevMonth > 0) {
                    if (prevMonth != currentValue) {
                        cal.set(2, prevMonth - 1);
                        cal.set(5, cal.getActualMaximum(5));
                        this.doRollUpHMS(cal, inverted);
                    }
                    foundNext = true;
                }
            } else {
                int nextMonth = filterMonth.stream().filter(y -> y >= currentValue).min(Comparator.comparingInt(y -> Math.abs(y - currentValue))).orElse(-1);
                if (nextMonth > 0) {
                    if (nextMonth != currentValue) {
                        cal.set(2, nextMonth - 1);
                        cal.set(5, 1);
                        this.doRollUpHMS(cal, inverted);
                    }
                    foundNext = true;
                }
            }
            if (!foundNext) {
                if (cal.get(1) < Calendar.getInstance(this.getTimeZone(), Locale.ENGLISH).get(1) + 5) {
                    if (inverted) {
                        cal.add(1, -1);
                        cal.set(2, 11);
                        this.rollUpMonth(filterMonth, cal, inverted);
                    } else {
                        cal.add(1, 1);
                        cal.set(2, 0);
                        this.rollUpMonth(filterMonth, cal, inverted);
                    }
                } else {
                    throw new Exception("Scheduling interval is too far ahead!");
                }
            }
        }
    }

    public void rollUpDays(List<Integer> filterDay, List<Integer> filterDOW, List<Integer> filterDOWMOD, Calendar cal, boolean inverted) throws Exception {
        int maxIteration;
        if (filterDay.isEmpty() && filterDOW.isEmpty() && filterDOWMOD.isEmpty()) {
            return;
        }
        if (filterDay.isEmpty()) {
            Calendar cal2 = (Calendar)cal.clone();
            for (maxIteration = 366; maxIteration > 0; --maxIteration) {
                int dowNumberFromEnd;
                int cal2WeekNumber;
                int cal2DOW = this.getOurDayOfWeek(cal2.get(7));
                if (this.checkDayOfWeek(cal2DOW, cal2WeekNumber = this.getDOWnumber(cal2), dowNumberFromEnd = this.getDOWnumberFromEnd(cal2), filterDOW, filterDOWMOD) && this.checkDay(cal2)) {
                    cal.setTimeInMillis(cal2.getTimeInMillis());
                    break;
                }
                cal2.add(6, inverted ? -1 : 1);
            }
        } else {
            Calendar cal2 = (Calendar)cal.clone();
            while (maxIteration > 0) {
                int dayNumber = cal2.get(5);
                int dayNumberFromEnd = this.getDayNumberFromEnd(cal2);
                if (filterDay.contains(dayNumber) || filterDay.contains(dayNumberFromEnd)) {
                    cal.setTimeInMillis(cal2.getTimeInMillis());
                    break;
                }
                cal2.add(6, inverted ? -1 : 1);
                --maxIteration;
            }
        }
        if (maxIteration == 0) {
            throw new Exception("incorrect mask");
        }
    }

    public void rollUp(Calendar cal, int field, int maxItr, List<Integer> filter, boolean inverted) throws Exception {
        if (!filter.isEmpty()) {
            int maxIteration;
            for (maxIteration = maxItr; maxIteration > 0 && !filter.contains(cal.get(field)); --maxIteration) {
                cal.add(field, inverted ? -1 : 1);
            }
            if (maxIteration == 0) {
                throw new Exception("incorrect mask");
            }
        }
    }

    public void rollUp(Calendar cal, int field, int maxItr, List<Integer> filter) throws Exception {
        this.rollUp(cal, field, maxItr, filter, false);
    }

    public void rollDown(Calendar cal, int field, int maxItr, List<Integer> filter) throws Exception {
        this.rollUp(cal, field, maxItr, filter, true);
    }

    public void rollUpDays(List<Integer> filterDay, List<Integer> filterDOW, List<Integer> filterDOWMOD, Calendar cal) throws Exception {
        this.rollUpDays(filterDay, filterDOW, filterDOWMOD, cal, false);
    }

    public void rollDownDays(List<Integer> filterDay, List<Integer> filterDOW, List<Integer> filterDOWMOD, Calendar cal) throws Exception {
        this.rollUpDays(filterDay, filterDOW, filterDOWMOD, cal, true);
    }

    public void rollUpMonth(List<Integer> filterMonth, Calendar cal) throws Exception {
        this.rollUpMonth(filterMonth, cal, false);
    }

    public void rollDownMonth(List<Integer> filterMonth, Calendar cal) throws Exception {
        this.rollUpMonth(filterMonth, cal, true);
    }

    public void rollUpYear(List<Integer> filterYear, Calendar cal) throws Exception {
        this.rollUpYear(filterYear, cal, false);
    }

    public void rollDownYear(List<Integer> filterYear, Calendar cal) throws Exception {
        this.rollUpYear(filterYear, cal, true);
    }

    public boolean checkDayOfWeek(int dow, int weekNumber, int dowNumberFromEnd, List<Integer> dows, List<Integer> dowMods) {
        if (dows.isEmpty() || dows.contains(dow)) {
            return dowMods.isEmpty() || dowMods.contains(weekNumber) || dowMods.contains(dowNumberFromEnd);
        }
        return false;
    }

    public boolean checkDay(Calendar cal) {
        return !(!this.filterYear.isEmpty() && !this.filterYear.contains(cal.get(1)) || !this.filterMonth.isEmpty() && !this.filterMonth.contains(cal.get(2) + 1) || !this.filterDay.isEmpty() && !this.filterMonth.contains(cal.get(5)));
    }

    private void doRollUpHMS(Calendar cal, boolean inverted) throws Exception {
        if (inverted) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        this.rollUp(cal, 13, 60, this.filterSec, inverted);
        this.rollUp(cal, 12, 60, this.filterMin, inverted);
        this.rollUp(cal, 11, 25, this.filterHour, inverted);
    }

    public void fineAdjustmentHMS(Calendar cal, long fromTime, boolean inverted) {
        if (inverted) {
            Calendar from = Calendar.getInstance();
            from.setTimeInMillis(fromTime);
            if (this.filterSec.isEmpty() && cal.get(12) < from.get(12)) {
                cal.add(13, 59 - cal.get(13));
            }
            if (this.filterMin.isEmpty() && cal.get(11) < from.get(11)) {
                cal.add(12, 59 - cal.get(12));
            }
            if (this.filterHour.isEmpty() && cal.get(6) < from.get(6)) {
                cal.add(11, 23 - cal.get(11));
            }
        } else {
            Calendar from = Calendar.getInstance();
            from.setTimeInMillis(fromTime);
            if (this.filterSec.isEmpty() && cal.getTimeInMillis() - from.getTimeInMillis() > 60000L) {
                cal.add(13, -1 * cal.get(13));
            }
            if (this.filterMin.isEmpty() && cal.getTimeInMillis() - from.getTimeInMillis() > 3600000L) {
                cal.add(12, -1 * cal.get(12));
            }
            if (this.filterHour.isEmpty() && cal.getTimeInMillis() - from.getTimeInMillis() > 86400000L) {
                cal.add(11, -1 * cal.get(11));
            }
        }
    }

    public int getMaxDOWNumberInMonth(int ourDOW, Calendar current) {
        int max = 0;
        Calendar cl = (Calendar)current.clone();
        cl.set(5, 1);
        while (cl.get(7) != this.getCalendarDayOfWeek(ourDOW)) {
            cl.add(6, 1);
        }
        while (cl.get(2) == current.get(2)) {
            cl.add(6, 7);
            ++max;
        }
        return max;
    }

    public List<Integer> getArray(String text, int type) throws Exception {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (text == null || text.length() == 0) {
            return list;
        }
        Matcher m = splitArray.matcher(text);
        while (m.find()) {
            String nchar;
            int digit = Integer.parseInt(m.group(2));
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    if (digit >= 1 && digit <= 12) break;
                    throw new Exception("Invalid Month: " + digit);
                }
                case 5: {
                    if (digit >= 1 && digit <= 31) break;
                    throw new Exception("Invalid Day: " + digit);
                }
                case 11: {
                    if (digit >= 0 && digit <= 23) break;
                    throw new Exception("Invalid Hour: " + digit);
                }
                case 12: 
                case 13: {
                    if (digit >= 0 && digit <= 59) break;
                    throw new Exception("Invalid Minute: " + digit);
                }
                case 7: {
                    if (digit >= 1 && digit <= 7) break;
                    throw new Exception("Invalid Day of Week: " + digit);
                }
                case 8: {
                    if (digit >= 1 && digit <= 5) break;
                    throw new Exception("Invalid Reverse modificator: " + digit);
                }
            }
            boolean isReverse = false;
            if ("L".equalsIgnoreCase(m.group(3))) {
                switch (type) {
                    case 1: 
                    case 2: 
                    case 7: 
                    case 10: 
                    case 12: 
                    case 13: {
                        throw new Exception("Invalid pattern");
                    }
                }
                digit = -1 * digit;
                isReverse = true;
            }
            if ((nchar = m.group(1)) == null || "".equals(nchar)) {
                list.add(digit);
                continue;
            }
            if ("-".equals(nchar)) {
                if (isReverse) {
                    throw new Exception("Invalid syntax near: " + m.group(0));
                }
                int lastD = (Integer)list.get(list.size() - 1);
                for (int i = lastD + 1; i <= digit; ++i) {
                    list.add(i);
                }
                continue;
            }
            if (!",".equals(nchar)) continue;
            list.add(digit);
        }
        return list;
    }

    public String replaceMonths(String months) {
        String text = months.replaceAll("(?i)jan", "1");
        text = text.replaceAll("(?i)feb", "2");
        text = text.replaceAll("(?i)mar", "3");
        text = text.replaceAll("(?i)apr", "4");
        text = text.replaceAll("(?i)may", "5");
        text = text.replaceAll("(?i)jun", "6");
        text = text.replaceAll("(?i)jul", "7");
        text = text.replaceAll("(?i)aug", "8");
        text = text.replaceAll("(?i)sep", "9");
        text = text.replaceAll("(?i)oct", "10");
        text = text.replaceAll("(?i)nov", "11");
        text = text.replaceAll("(?i)dec", "12");
        return text;
    }

    public String getMonth(int number) {
        switch (number) {
            case 1: {
                return "JAN";
            }
            case 2: {
                return "FEB";
            }
            case 3: {
                return "MAR";
            }
            case 4: {
                return "APR";
            }
            case 5: {
                return "MAY";
            }
            case 6: {
                return "JUN";
            }
            case 7: {
                return "JUL";
            }
            case 8: {
                return "AUG";
            }
            case 9: {
                return "SEP";
            }
            case 10: {
                return "OCT";
            }
            case 11: {
                return "NOV";
            }
            case 12: {
                return "DEC";
            }
        }
        return "*";
    }

    public String replaceDaysOfWeek(String days) {
        String text = days.replaceAll("(?i)mon", "1");
        text = text.replaceAll("(?i)tue", "2");
        text = text.replaceAll("(?i)wed", "3");
        text = text.replaceAll("(?i)thu", "4");
        text = text.replaceAll("(?i)fri", "5");
        text = text.replaceAll("(?i)sat", "6");
        text = text.replaceAll("(?i)sun", "7");
        return text;
    }

    public String getDayOfWeek(int number) {
        switch (number) {
            case 1: {
                return "MON";
            }
            case 2: {
                return "TUE";
            }
            case 3: {
                return "WED";
            }
            case 4: {
                return "THU";
            }
            case 5: {
                return "FRI";
            }
            case 6: {
                return "SAT";
            }
            case 7: {
                return "SUN";
            }
        }
        return "*";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeMask)) {
            return false;
        }
        TimeMask t2 = (TimeMask)obj;
        return Objects.equals(this.mask, t2.mask);
    }

    public int hashCode() {
        return this.mask == null ? 0 : this.mask.hashCode();
    }
}

