/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.ext;

import com.blixx.shared.IODataStream;
import com.blixx.shared.Interval;
import com.blixx.shared.ext.TimeMask;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class TimedActionCfg
implements IODataStream,
Cloneable {
    public final int STATE_ENABLED = 1;
    public final int STATE_RUNNING = 2;
    public static final String TYPE_USER = "USER";
    public static final String TYPE_RULE = "RULE";
    public static final String TYPE_AGENT = "AGENT";
    public static String ACTION_DROP = "DROP";
    public static String ACTION_DELAY = "DELAY";
    public static String ACTION_HIDE = "HIDE";
    public static String ACTION_MODIFY = "MODIFY";
    public static final int ACTION_DROP_INT = 1;
    public static final int ACTION_DELAY_INT = 2;
    public static final int ACTION_HIDE_INT = 3;
    public static final int ACTION_MODIFY_INT = 4;
    protected String m_id = null;
    protected String m_startTimePattern = "-";
    protected TimeMask m_timeMask = null;
    protected String m_intervalStr = "1h";
    protected Interval m_interval = null;
    protected long m_currentBeginTime = -1L;
    protected long m_currentEndTime = -1L;
    protected String m_initiatorType = "RULE";
    protected String m_initiatorID = "";
    protected int m_action = 3;
    protected String m_label = "";
    protected String m_descr = "";
    protected int m_stateMask = 1;
    protected Map<String, String> m_filters = new LinkedHashMap<String, String>();

    public static TimedActionCfg getInstance(String mask, String interval) throws Exception {
        TimedActionCfg cfg = new TimedActionCfg();
        cfg.m_intervalStr = interval;
        cfg.m_startTimePattern = mask;
        TimedActionCfg.init(cfg);
        return cfg;
    }

    private static void init(TimedActionCfg cfg) throws Exception {
        cfg.m_interval = Interval.parseInterval(cfg.m_intervalStr, -1);
        if (cfg.m_interval.getIntervalMilliseconds() <= 0L) {
            throw new Exception("Invalid interval");
        }
        cfg.m_timeMask = new TimeMask(cfg.m_startTimePattern);
        long time = System.currentTimeMillis() - cfg.m_interval.getIntervalMilliseconds();
        cfg.m_timeMask.setTime(time);
        cfg.m_currentBeginTime = cfg.m_timeMask.getNextTime();
    }

    public static String getActionLabel(int action) {
        switch (action) {
            case 1: {
                return ACTION_DROP;
            }
            case 2: {
                return ACTION_DELAY;
            }
            case 3: {
                return ACTION_HIDE;
            }
            case 4: {
                return ACTION_MODIFY;
            }
        }
        return "UNKNOWN";
    }

    public TimedActionCfg() {
        this.m_id = UUID.randomUUID().toString();
    }

    public void setEnabled() {
        this.m_stateMask |= 1;
    }

    public void setDisabled() {
        this.m_stateMask &= 0xFFFFFFFE;
    }

    public boolean isEnabled() {
        return (this.m_stateMask & 1) == 1;
    }

    public TimeMask getTimeMask() throws Exception {
        if (this.m_timeMask == null) {
            this.m_timeMask = new TimeMask(this.m_startTimePattern);
        }
        return this.m_timeMask;
    }

    public boolean isActive() {
        if (this.isEnabled()) {
            long now = System.currentTimeMillis();
            if (this.m_currentEndTime > 0L && this.m_currentEndTime < now) {
                return true;
            }
            this.m_currentEndTime = -1L;
            this.m_currentBeginTime = -1L;
            try {
                this.m_timeMask.setTime(now - this.m_interval.getIntervalMilliseconds() - 1000L);
                this.m_currentBeginTime = this.m_timeMask.getNextTime();
                this.m_currentEndTime = this.m_currentBeginTime + this.m_interval.getIntervalMilliseconds();
                if (now >= this.m_currentBeginTime && now < this.m_currentEndTime) {
                    return true;
                }
            }
            catch (Throwable e) {
                this.m_currentBeginTime = -1L;
                this.m_currentEndTime = -1L;
            }
        }
        return false;
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        this.m_id = dis.readUTF();
        this.m_action = dis.readInt();
        this.m_descr = dis.readUTF();
        this.m_label = dis.readUTF();
        while (dis.readBoolean()) {
            this.m_filters.put(dis.readUTF(), dis.readUTF());
        }
        this.m_initiatorID = dis.readUTF();
        this.m_initiatorType = dis.readUTF();
        this.m_intervalStr = dis.readUTF();
        this.m_startTimePattern = dis.readUTF();
        this.m_stateMask = dis.readInt();
        while (dis.readBoolean()) {
            dis.readUTF();
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        dos.writeUTF(this.m_id);
        dos.writeInt(this.m_action);
        dos.writeUTF(this.m_descr);
        dos.writeUTF(this.m_label);
        Iterator<Map.Entry<String, String>> it = this.m_filters.entrySet().iterator();
        while (it.hasNext()) {
            dos.writeBoolean(true);
            dos.writeUTF(it.next().getKey());
            dos.writeUTF(it.next().getValue());
        }
        dos.writeBoolean(false);
        dos.writeUTF(this.m_initiatorID);
        dos.writeUTF(this.m_initiatorType);
        dos.writeUTF(this.m_intervalStr);
        dos.writeUTF(this.m_startTimePattern);
        dos.writeInt(this.m_stateMask);
        dos.writeBoolean(false);
    }

    protected TimedActionCfg clone() throws CloneNotSupportedException {
        TimedActionCfg newObj = new TimedActionCfg();
        newObj.m_action = this.m_action;
        newObj.m_descr = this.m_descr;
        newObj.m_filters = new LinkedHashMap<String, String>(this.m_filters);
        newObj.m_initiatorID = this.m_initiatorID;
        newObj.m_initiatorType = this.m_initiatorType;
        newObj.m_interval = this.m_interval;
        newObj.m_label = this.m_label;
        newObj.m_startTimePattern = this.m_startTimePattern;
        newObj.m_stateMask = this.m_stateMask;
        return newObj;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TimedActionCfg)) {
            return false;
        }
        return this.m_id.equals(((TimedActionCfg)obj).m_id);
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public long getCurrentBeginTime() {
        return this.m_currentBeginTime;
    }
}

