/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.io;

import com.blixx.log.RTLogger;
import com.blixx.shared.Cryptor;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SDataInputStream
implements AutoCloseable {
    public static final int MAX_BYTES_LENGTH = 250000000;
    public static final int MAX_STRING_LENGTH = 0x5000000;
    protected DataInputStream stream = null;
    protected int lastProtocolVersion = 1;
    private String secretKey = "";
    private boolean isTrace = false;

    protected SDataInputStream() {
    }

    public SDataInputStream(InputStream in) {
        this();
        this.setIS(in);
    }

    protected void setIS(InputStream in) {
        try {
            this.stream = new DataInputStream(in);
        }
        catch (Exception e) {
            RTLogger.print(1, "Error setting Stream ", e);
            System.exit(876);
        }
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public int getLastProtocolVersion() {
        return this.lastProtocolVersion;
    }

    public String readUTF(String defaultReturnValue) {
        String res = defaultReturnValue;
        try {
            res = this.readUTF();
        }
        catch (Exception e) {
            RTLogger.print(5, "", e);
        }
        return res;
    }

    public String readUTF() throws IOException {
        Integer[] refProtocolVersion = new Integer[]{this.lastProtocolVersion};
        String result = Cryptor.readUTFV3(this.stream, this.secretKey, refProtocolVersion);
        this.lastProtocolVersion = refProtocolVersion[0];
        if (this.isTrace) {
            RTLogger.print(5, this + " str(" + result + ")");
        }
        return result;
    }

    public int readInt() throws IOException {
        int i = this.stream.readInt();
        if (this.isTrace && i != -1) {
            RTLogger.print(5, this + " int(" + i + ")");
        }
        return i;
    }

    public char readChar() throws IOException {
        return this.stream.readChar();
    }

    public long readLong() throws IOException {
        return this.stream.readLong();
    }

    public double readDouble() throws IOException {
        return this.stream.readDouble();
    }

    public boolean readBoolean() throws IOException {
        return this.stream.readBoolean();
    }

    public int read() throws IOException {
        int read = this.stream.read();
        if (this.isTrace && read != -1) {
            RTLogger.print(5, this + " intch(" + (char)read + ")");
        }
        return read;
    }

    public int read(byte[] v) throws IOException {
        return this.stream.read(v);
    }

    public void readFully(byte[] v) throws IOException {
        this.stream.readFully(v);
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public boolean readFile(String fullPath) throws IOException {
        return Cryptor.readFile(this.stream, fullPath, false, this.lastProtocolVersion, false, this.secretKey);
    }

    public boolean readFileEncoded(String fullPath) throws IOException {
        return Cryptor.readFile(this.stream, fullPath, true, this.stream.readInt(), false, this.secretKey);
    }

    public boolean readFileEncoded(String fullPath, boolean append) throws IOException {
        return Cryptor.readFile(this.stream, fullPath, true, this.stream.readInt(), append, this.secretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFileToNULL(String fullPath) throws IOException {
        byte[] inArr = new byte[]{};
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int blockSize = -1;
            while ((blockSize = this.readInt()) != -1) {
                RTLogger.print(1, "/DEV/NULL:> Reading bytes: %s file: $s", blockSize, fullPath);
                inArr = new byte[blockSize];
                this.stream.readFully(inArr);
                baos.write(inArr, 0, blockSize);
            }
        }
        return baos.toByteArray();
    }

    public void setSecretKey(String agentHash) {
        this.secretKey = agentHash;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isTrace() {
        return this.isTrace;
    }

    public void setTrace(boolean trace) {
        this.isTrace = trace;
    }
}

