/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.io;

import com.blixx.log.RTLogger;
import com.blixx.shared.Cryptor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SDataOutputStream
implements AutoCloseable {
    int version = 1;
    private String secretKey = "";
    private boolean isTrace = false;
    protected DataOutputStream stream = null;
    private OutputStream out = null;

    public SDataOutputStream(OutputStream in, int version) {
        this.setVersion(version);
        this.setOS(in);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    @Deprecated
    public SDataOutputStream(OutputStream in) {
        this(in, 1);
    }

    protected SDataOutputStream() {
    }

    protected void setOS(OutputStream in) {
        try {
            this.out = in;
            this.stream = new DataOutputStream(this.out);
        }
        catch (Exception e) {
            RTLogger.print(1, "Error setting stream ", e);
            System.exit(876);
        }
    }

    public void writeUTF(String msg) throws IOException {
        if (this.isTrace) {
            RTLogger.print(5, this + " str(" + msg + ")");
        }
        byte[] encBytes = Cryptor.writeUTF(msg, this.version, this.secretKey);
        this.stream.write(encBytes);
    }

    public boolean writeFileEncoded(InputStream fis, long maxChunkSize) throws IOException {
        this.stream.writeInt(this.version);
        byte[] arr = new byte[1024];
        int countB = -1;
        for (long sent = 0L; sent < maxChunkSize && (countB = fis.read(arr)) != -1; sent += (long)countB) {
            byte[] chunkBytes = Cryptor.writeEncoded(arr, 0, countB, this.version, this.secretKey);
            this.stream.writeInt(chunkBytes.length);
            this.stream.write(chunkBytes);
        }
        this.writeInt(-1);
        return countB == -1;
    }

    protected void writeEncoded(byte[] toEnc) throws IOException {
        byte[] fileBytes = Cryptor.writeEncoded(toEnc, 0, toEnc.length, this.version, this.secretKey);
        this.stream.writeInt(fileBytes.length);
        this.stream.write(fileBytes);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void writeInt(int i) throws IOException {
        if (this.isTrace) {
            RTLogger.print(5, this + " int(" + i + ")");
        }
        this.stream.writeInt(i);
    }

    public void writeChar(int i) throws IOException {
        this.stream.writeChar(i);
    }

    public void writeLong(long i) throws IOException {
        this.stream.writeLong(i);
    }

    public void writeDouble(double i) throws IOException {
        this.stream.writeDouble(i);
    }

    public void writeBoolean(boolean i) throws IOException {
        this.stream.writeBoolean(i);
    }

    public void write(int i) throws IOException {
        if (this.isTrace) {
            RTLogger.print(5, this + " intch(" + (char)i + ")");
        }
        this.stream.write(i);
    }

    public void write(byte[] v) throws IOException {
        this.stream.write(v);
    }

    public void write(byte[] v, int start, int len) throws IOException {
        this.stream.write(v, start, len);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public void writeFile(InputStream fis) throws IOException {
        byte[] arr = new byte[65536];
        int countB = -1;
        while ((countB = fis.read(arr)) != -1) {
            this.writeInt(countB);
            this.write(arr, 0, countB);
        }
        this.writeInt(-1);
    }

    public void writeBytes(byte[] content) throws IOException {
        this.writeInt(content.length);
        this.write(content);
        this.writeInt(-1);
    }

    public void setSecretKey(String agentHash) {
        this.secretKey = agentHash;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isTrace() {
        return this.isTrace;
    }

    public void setTrace(boolean trace) {
        this.isTrace = trace;
    }
}

