/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IndicationPrinter {
    public static final String SLAVE_SERVER = "Slave server = ";
    public static final String AUTO_ACTION_NODE = "AutoAction Host = ";
    public static final String AGENT_HOST = "AGENT Host = ";
    public static final String AGENT_ID = "AgentID = ";
    public static final String ALERT_FINISHED_TIME = "Alert Finished = ";
    public static final String ANNOTATIONS_HEADER = "Annotations:\n";
    public static final String APPLICATION = "Application = ";
    public static final String AUTO_ACTION = "Auto Action = ";
    public static final String AVAILABILITY_METRIC = "Availability Metric = ";
    public static final String CLOSE_MASK = "Close Mask = ";
    public static final String CUSTOM_ATTRIBUTES_HEADER = "Custom Attributes:\n";
    public static final String CUSTOM_TEXT = "Custom Text = ";
    public static final String DE_DUPLICATION_KEY_ONLY = "DeDuplication KeyOnly = ";
    public static final String DUPLICATES2 = "Duplicates = ";
    public static final String END_VALUE = "End Value = ";
    public static final String FIRST_SUBMIT = "First Submit = ";
    public static final String GROUP = "Group = ";
    public static final String HOST = "Host = ";
    public static final String INDICATION_TEXT = "INDICATION Text = ";
    public static final String KEY = "Key = ";
    public static final String KPI_METRIC = "KPI Metric = ";
    public static final String LAST_DUPLICATE_TIME = "Last Duplicate = ";
    public static final String OBJECT = "Object = ";
    public static final String OP_ACTION = "Op Action = ";
    public static final String OWNER2 = "Owner = ";
    public static final String SERVER_TIME = "Server Received = ";
    public static final String SEVERITY = "Severity = ";
    public static final String SOURCE = "Source = ";
    public static final String STATE = "State = ";
    public static final String UUID = "UUID = ";
    public static final String VALUE = "Value = ";
    SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private StringBuffer createStringBuffer(SEvent se) {
        SEventFwd sef;
        StringBuffer sb = new StringBuffer();
        sb.append("------------------------------------------------------------------------\n");
        sb.append(INDICATION_TEXT).append(se.getText().trim().replace('\n', ' ')).append('\n');
        sb.append(SEVERITY).append(se.getSeverity()).append('\n');
        sb.append(UUID).append(se.getID()).append('\n');
        sb.append(APPLICATION).append(se.getApplication()).append('\n');
        sb.append(GROUP).append(se.getGroup()).append('\n');
        sb.append(HOST).append(se.getNode()).append('\n');
        sb.append(AGENT_HOST).append(se.getAgentNode()).append('\n');
        String kpi = se.getTypeA() == 1 ? "true" : "false";
        sb.append(KPI_METRIC).append(kpi).append('\n');
        String av = se.getTypeK() == 1 ? "true" : "false";
        sb.append(AVAILABILITY_METRIC).append(av).append('\n');
        sb.append(OBJECT).append(se.getObject()).append('\n');
        sb.append(KEY).append(se.getKeyConfigured()).append('\n');
        sb.append(CLOSE_MASK).append(se.getCloseMask()).append('\n');
        sb.append(AUTO_ACTION).append(se.getAutoAction()).append('\n');
        sb.append(AUTO_ACTION_NODE).append(se.getAutoActionNode()).append('\n');
        String opAction = se.getOpAction().trim();
        sb.append(OP_ACTION).append(opAction).append('\n');
        sb.append(SOURCE).append(se.getSource()).append('\n');
        String state = "Unknown";
        switch (se.getState()) {
            case 'A': {
                state = "Auto Closed Message";
                break;
            }
            case 'O': {
                state = "Closed By Operator";
                break;
            }
            case '-': {
                state = "Active";
                break;
            }
            case 'D': {
                state = "Archived";
                break;
            }
        }
        sb.append(STATE).append(state).append('\n');
        sb.append(DUPLICATES2).append(se.getDuplicates()).append('\n');
        String agentFirstTime = this.m_sdf.format(new Date(se.getFirstTime()));
        sb.append(FIRST_SUBMIT).append(agentFirstTime).append('\n');
        String agentTime = this.m_sdf.format(new Date(se.getTime()));
        sb.append(LAST_DUPLICATE_TIME).append(agentTime).append('\n');
        String srvTime = this.m_sdf.format(new Date(se.getSTime()));
        sb.append(SERVER_TIME).append(srvTime).append('\n');
        if (se.getSource().startsWith("Monitor")) {
            sb.append(VALUE).append(se.getValue()).append('\n');
            if (se instanceof SEventFwd && (sef = (SEventFwd)se).getTFA() > 0L) {
                sb.append(END_VALUE).append(sef.getVFA()).append('\n');
                String srvTimeFA = this.m_sdf.format(new Date(sef.getTFA()));
                sb.append(ALERT_FINISHED_TIME).append(srvTimeFA).append('\n');
            }
        } else {
            sb.append(VALUE).append('\n');
            sb.append(END_VALUE).append('\n');
            sb.append(ALERT_FINISHED_TIME).append('\n');
        }
        if (se instanceof SEventFwd) {
            String customText;
            String owner;
            String srvSlave;
            sef = (SEventFwd)se;
            if (sef.getDeDuplicationKeyOnly()) {
                sb.append(DE_DUPLICATION_KEY_ONLY).append("true").append('\n');
            } else {
                sb.append(DE_DUPLICATION_KEY_ONLY).append("false").append('\n');
            }
            String agentID = sef.getT1();
            if (agentID != null && agentID.length() > 0) {
                sb.append(AGENT_ID).append(agentID).append('\n');
            }
            if ((srvSlave = sef.getSrv()) != null && srvSlave.length() > 0) {
                sb.append(SLAVE_SERVER).append(srvSlave).append('\n');
            }
            if ((owner = sef.getT5()) != null && owner.length() > 0) {
                String user = "";
                String date = "";
                String[] arr = owner.split("\n");
                user = arr[0];
                try {
                    date = this.m_sdf.format(new Date(Long.parseLong(arr[1])));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                sb.append(OWNER2).append(user);
                if (date.length() > 0) {
                    sb.append(" (").append(date).append(')');
                }
                sb.append('\n');
            }
            if ((customText = sef.getT7()) != null && customText.length() > 0) {
                sb.append(CUSTOM_TEXT).append(customText);
                sb.append('\n');
            }
            sb.append(CUSTOM_ATTRIBUTES_HEADER);
            for (int i = 0; i < 15; ++i) {
                int indexOf_EQ;
                String CAName = "CA" + (i + 1);
                String str = sef.m_CustomAttributes.get(CAName);
                if (str == null || (indexOf_EQ = str.indexOf(61)) == -1) continue;
                String name = str.substring(0, indexOf_EQ);
                String value = str.substring(indexOf_EQ + 1);
                sb.append(name).append(" = ").append(value).append('\n');
            }
        } else {
            sb.append(DE_DUPLICATION_KEY_ONLY).append("false").append('\n');
            sb.append(AGENT_ID).append('\n');
            sb.append(SLAVE_SERVER).append('\n');
            sb.append(OWNER2).append('\n');
            sb.append(CUSTOM_ATTRIBUTES_HEADER);
        }
        sb.append(ANNOTATIONS_HEADER);
        if (se.getAnnotationFlag()) {
            StringBuffer duplicates = new StringBuffer();
            Boolean dFlag = false;
            for (int i = 0; i < se.getAnnotations().size(); ++i) {
                String time;
                int firstNL;
                String ann = se.getAnnotations().get(i);
                if (ann == null) continue;
                String noteLabel = "Note " + i;
                if (ann.startsWith("AAT")) {
                    noteLabel = "AutoAction\nSuccess\n";
                    firstNL = ann.indexOf(10);
                    time = ann.substring(ann.indexOf(124) + 1, firstNL);
                    noteLabel = noteLabel + time;
                    ann = ann.substring(firstNL + 1);
                } else {
                    String user;
                    if (ann.startsWith("DD")) {
                        firstNL = ann.indexOf(124);
                        String line = ann.substring(firstNL + 1);
                        if (duplicates.length() == 0) {
                            duplicates.append(line.replace('\n', ' '));
                        } else {
                            duplicates.append('\n').append(line.replace('\n', ' '));
                        }
                        if (dFlag.booleanValue()) continue;
                        String duplicateLabel = "Custom Attributes in duplicates";
                        sb.append(duplicateLabel).append(" = ").append(duplicates.toString()).append('\n');
                        dFlag = true;
                        continue;
                    }
                    if (ann.startsWith("AAF")) {
                        noteLabel = "AutoAction\nFailed\n";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        noteLabel = noteLabel + time;
                        ann = ann.substring(firstNL + 1);
                    } else if (ann.startsWith("SAM")) {
                        noteLabel = "Auto closed\n";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        noteLabel = noteLabel + time;
                        ann = ann.substring(firstNL + 1);
                    } else if (ann.startsWith("OAM")) {
                        noteLabel = "Operator closed\n";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        noteLabel = noteLabel + time;
                        ann = ann.substring(firstNL + 1);
                    } else if (ann.startsWith("OMN")) {
                        noteLabel = "OP: ";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        int lnl = (ann = ann.substring(firstNL + 1)).indexOf(10);
                        if (lnl != -1) {
                            user = ann.substring(0, lnl);
                            noteLabel = noteLabel + user + "\n";
                        }
                        noteLabel = noteLabel + time;
                    } else if (ann.startsWith("REO")) {
                        noteLabel = "Re-opened by: ";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        try {
                            time = this.m_sdf.format(new Date(Long.parseLong(time)));
                        }
                        catch (Throwable lnl) {
                            // empty catch block
                        }
                        ann = ann.substring(firstNL + 1);
                        int lnl = ann.indexOf(10);
                        if (lnl != -1) {
                            user = ann.substring(0, lnl);
                            noteLabel = noteLabel + user + "\n";
                        }
                        noteLabel = noteLabel + time;
                    }
                }
                sb.append(noteLabel.trim().replace('\n', ' ')).append('\n').append(ann).append('\n');
            }
            if (dFlag.booleanValue()) {
                sb.append(duplicates.toString()).append('\n');
            }
        }
        return sb;
    }

    public void export(SEvent se, OutputStream os) {
        try {
            StringBuffer sb = this.createStringBuffer(se);
            os.write(sb.toString().getBytes());
        }
        catch (IOException e) {
            RTLogger.print(2, "", e);
        }
    }
}

