/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PStatisticClass {
    private String m_pName = null;
    private int m_totalMsgs = 0;
    private Map<String, Integer> m_condCount = null;
    private Map<String, Integer> m_condWithSev = null;
    private List<Integer> m_globalSevs = null;
    private static List<Integer> sevEmpty = new ArrayList<Integer>(6);

    public PStatisticClass(String pName) {
        this.m_pName = pName;
        this.m_globalSevs = new ArrayList<Integer>(sevEmpty);
        this.m_condWithSev = new HashMap<String, Integer>();
        this.m_condCount = new HashMap<String, Integer>();
    }

    public void addEvent(SEvent se) {
        String source = se.getSource();
        String[] params = source.split("\\Q:\\E");
        if (params.length < 3) {
            return;
        }
        String condID = params[2];
        int sevInt = se.getSeverityInt();
        if (sevInt < 0) {
            sevInt += 6;
        }
        if (sevInt < 0 || sevInt > 5) {
            RTLogger.print(1, "invalid severity " + se.getSeverityInt() + " for " + se.getText());
            return;
        }
        ++this.m_totalMsgs;
        int count = this.m_globalSevs.get(sevInt);
        this.m_globalSevs.set(sevInt, count + 1);
        if (!this.m_condWithSev.containsKey(condID)) {
            this.m_condWithSev.put(condID, sevInt);
        }
        if (this.m_condCount.containsKey(condID)) {
            Integer number = this.m_condCount.get(condID);
            this.m_condCount.put(condID, number + 1);
        } else {
            this.m_condCount.put(condID, 1);
        }
    }

    public String getPolicyName() {
        return this.m_pName;
    }

    public int getMessageCount() {
        return this.m_totalMsgs;
    }

    public int getMessageCount(int sev) {
        return this.m_globalSevs.get(sev);
    }

    public Map<String, Integer> getConditions() {
        return this.m_condCount;
    }

    public List<Integer> getSeverityCount() {
        return this.m_globalSevs;
    }

    static {
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
        sevEmpty.add(0);
    }
}

