/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.utils.Digest;

public class ShabalGeneric
implements Digest {
    private int outSizeW32;
    private byte[] buf;
    private int ptr;
    private int[] state;
    private long W;
    private static final int[][] IVs = new int[16][];
    private int[] M = new int[16];

    private ShabalGeneric() {
        this.buf = new byte[64];
        this.state = new int[44];
    }

    public ShabalGeneric(int outSize) {
        this();
        if (outSize < 32 || outSize > 512 || (outSize & 0x1F) != 0) {
            throw new IllegalArgumentException("invalid Shabal output size: " + outSize);
        }
        this.outSizeW32 = outSize >>> 5;
        this.reset();
    }

    @Override
    public void update(byte in) {
        this.buf[this.ptr++] = in;
        if (this.ptr == 64) {
            this.core(this.buf, 0, 1);
            this.ptr = 0;
        }
    }

    @Override
    public void update(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
    }

    @Override
    public void update(byte[] inbuf, int off, int len) {
        int num;
        if (this.ptr != 0) {
            int rlen = 64 - this.ptr;
            if (len < rlen) {
                System.arraycopy(inbuf, off, this.buf, this.ptr, len);
                this.ptr += len;
                return;
            }
            System.arraycopy(inbuf, off, this.buf, this.ptr, rlen);
            off += rlen;
            len -= rlen;
            this.core(this.buf, 0, 1);
        }
        if ((num = len >>> 6) > 0) {
            this.core(inbuf, off, num);
            off += num << 6;
            len &= 0x3F;
        }
        System.arraycopy(inbuf, off, this.buf, 0, len);
        this.ptr = len;
    }

    @Override
    public int getDigestLength() {
        return this.outSizeW32 << 2;
    }

    @Override
    public byte[] digest() {
        int n = this.getDigestLength();
        byte[] out = new byte[n];
        this.digest(out, 0, n);
        return out;
    }

    @Override
    public byte[] digest(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
        return this.digest();
    }

    @Override
    public int digest(byte[] outbuf, int off, int len) {
        int i;
        int dlen = this.getDigestLength();
        if (len > dlen) {
            len = dlen;
        }
        this.buf[this.ptr++] = -128;
        for (i = this.ptr; i < 64; ++i) {
            this.buf[i] = 0;
        }
        for (i = 0; i < 4; ++i) {
            this.core(this.buf, 0, 1);
            --this.W;
        }
        int j = 44 - (dlen >>> 2);
        int w = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if ((i2 & 3) == 0) {
                w = this.state[j++];
            }
            outbuf[i2] = (byte)w;
            w >>>= 8;
        }
        this.reset();
        return len;
    }

    private static int[] getIV(int outSizeW32) {
        int[] iv = IVs[outSizeW32 - 1];
        if (iv == null) {
            int i;
            int outSize = outSizeW32 << 5;
            ShabalGeneric sg = new ShabalGeneric();
            for (i = 0; i < 44; ++i) {
                sg.state[i] = 0;
            }
            sg.W = -1L;
            for (i = 0; i < 16; ++i) {
                sg.buf[(i << 2) + 0] = (byte)(outSize + i);
                sg.buf[(i << 2) + 1] = (byte)(outSize + i >>> 8);
            }
            sg.core(sg.buf, 0, 1);
            for (i = 0; i < 16; ++i) {
                sg.buf[(i << 2) + 0] = (byte)(outSize + i + 16);
                sg.buf[(i << 2) + 1] = (byte)(outSize + i + 16 >>> 8);
            }
            sg.core(sg.buf, 0, 1);
            ShabalGeneric.IVs[outSizeW32 - 1] = sg.state;
            iv = sg.state;
        }
        return iv;
    }

    @Override
    public void reset() {
        System.arraycopy(ShabalGeneric.getIV(this.outSizeW32), 0, this.state, 0, 44);
        this.W = 1L;
        this.ptr = 0;
    }

    @Override
    public Digest copy() {
        ShabalGeneric d = this.dup();
        d.outSizeW32 = this.outSizeW32;
        System.arraycopy(this.buf, 0, d.buf, 0, this.ptr);
        d.ptr = this.ptr;
        System.arraycopy(this.state, 0, d.state, 0, 44);
        d.W = this.W;
        return d;
    }

    ShabalGeneric dup() {
        return new ShabalGeneric();
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    private static final int decodeLEInt(byte[] data, int off) {
        return data[off + 0] & 0xFF | (data[off + 1] & 0xFF) << 8 | (data[off + 2] & 0xFF) << 16 | (data[off + 3] & 0xFF) << 24;
    }

    private final void core(byte[] data, int off, int num) {
        int A0 = this.state[0];
        int A1 = this.state[1];
        int A2 = this.state[2];
        int A3 = this.state[3];
        int A4 = this.state[4];
        int A5 = this.state[5];
        int A6 = this.state[6];
        int A7 = this.state[7];
        int A8 = this.state[8];
        int A9 = this.state[9];
        int AA = this.state[10];
        int AB = this.state[11];
        int B0 = this.state[12];
        int B1 = this.state[13];
        int B2 = this.state[14];
        int B3 = this.state[15];
        int B4 = this.state[16];
        int B5 = this.state[17];
        int B6 = this.state[18];
        int B7 = this.state[19];
        int B8 = this.state[20];
        int B9 = this.state[21];
        int BA = this.state[22];
        int BB = this.state[23];
        int BC = this.state[24];
        int BD = this.state[25];
        int BE = this.state[26];
        int BF = this.state[27];
        int C0 = this.state[28];
        int C1 = this.state[29];
        int C2 = this.state[30];
        int C3 = this.state[31];
        int C4 = this.state[32];
        int C5 = this.state[33];
        int C6 = this.state[34];
        int C7 = this.state[35];
        int C8 = this.state[36];
        int C9 = this.state[37];
        int CA = this.state[38];
        int CB = this.state[39];
        int CC = this.state[40];
        int CD = this.state[41];
        int CE = this.state[42];
        int CF = this.state[43];
        while (num-- > 0) {
            int M0 = ShabalGeneric.decodeLEInt(data, off + 0);
            B0 += M0;
            B0 = B0 << 17 | B0 >>> 15;
            int M1 = ShabalGeneric.decodeLEInt(data, off + 4);
            B1 += M1;
            B1 = B1 << 17 | B1 >>> 15;
            int M2 = ShabalGeneric.decodeLEInt(data, off + 8);
            B2 += M2;
            B2 = B2 << 17 | B2 >>> 15;
            int M3 = ShabalGeneric.decodeLEInt(data, off + 12);
            B3 += M3;
            B3 = B3 << 17 | B3 >>> 15;
            int M4 = ShabalGeneric.decodeLEInt(data, off + 16);
            B4 += M4;
            B4 = B4 << 17 | B4 >>> 15;
            int M5 = ShabalGeneric.decodeLEInt(data, off + 20);
            B5 += M5;
            B5 = B5 << 17 | B5 >>> 15;
            int M6 = ShabalGeneric.decodeLEInt(data, off + 24);
            B6 += M6;
            B6 = B6 << 17 | B6 >>> 15;
            int M7 = ShabalGeneric.decodeLEInt(data, off + 28);
            B7 += M7;
            B7 = B7 << 17 | B7 >>> 15;
            int M8 = ShabalGeneric.decodeLEInt(data, off + 32);
            B8 += M8;
            B8 = B8 << 17 | B8 >>> 15;
            int M9 = ShabalGeneric.decodeLEInt(data, off + 36);
            B9 += M9;
            B9 = B9 << 17 | B9 >>> 15;
            int MA = ShabalGeneric.decodeLEInt(data, off + 40);
            BA += MA;
            BA = BA << 17 | BA >>> 15;
            int MB = ShabalGeneric.decodeLEInt(data, off + 44);
            BB += MB;
            BB = BB << 17 | BB >>> 15;
            int MC = ShabalGeneric.decodeLEInt(data, off + 48);
            BC += MC;
            BC = BC << 17 | BC >>> 15;
            int MD = ShabalGeneric.decodeLEInt(data, off + 52);
            BD += MD;
            BD = BD << 17 | BD >>> 15;
            int ME = ShabalGeneric.decodeLEInt(data, off + 56);
            BE += ME;
            BE = BE << 17 | BE >>> 15;
            int MF = ShabalGeneric.decodeLEInt(data, off + 60);
            BF += MF;
            BF = BF << 17 | BF >>> 15;
            off += 64;
            A0 ^= (int)this.W;
            A1 ^= (int)(this.W >>> 32);
            ++this.W;
            A0 = (A0 ^ (AB << 15 | AB >>> 17) * 5 ^ C8) * 3 ^ BD ^ B9 & ~B6 ^ M0;
            B0 = ~(B0 << 1 | B0 >>> 31) ^ A0;
            A1 = (A1 ^ (A0 << 15 | A0 >>> 17) * 5 ^ C7) * 3 ^ BE ^ BA & ~B7 ^ M1;
            B1 = ~(B1 << 1 | B1 >>> 31) ^ A1;
            A2 = (A2 ^ (A1 << 15 | A1 >>> 17) * 5 ^ C6) * 3 ^ BF ^ BB & ~B8 ^ M2;
            B2 = ~(B2 << 1 | B2 >>> 31) ^ A2;
            A3 = (A3 ^ (A2 << 15 | A2 >>> 17) * 5 ^ C5) * 3 ^ B0 ^ BC & ~B9 ^ M3;
            B3 = ~(B3 << 1 | B3 >>> 31) ^ A3;
            A4 = (A4 ^ (A3 << 15 | A3 >>> 17) * 5 ^ C4) * 3 ^ B1 ^ BD & ~BA ^ M4;
            B4 = ~(B4 << 1 | B4 >>> 31) ^ A4;
            A5 = (A5 ^ (A4 << 15 | A4 >>> 17) * 5 ^ C3) * 3 ^ B2 ^ BE & ~BB ^ M5;
            B5 = ~(B5 << 1 | B5 >>> 31) ^ A5;
            A6 = (A6 ^ (A5 << 15 | A5 >>> 17) * 5 ^ C2) * 3 ^ B3 ^ BF & ~BC ^ M6;
            B6 = ~(B6 << 1 | B6 >>> 31) ^ A6;
            A7 = (A7 ^ (A6 << 15 | A6 >>> 17) * 5 ^ C1) * 3 ^ B4 ^ B0 & ~BD ^ M7;
            B7 = ~(B7 << 1 | B7 >>> 31) ^ A7;
            A8 = (A8 ^ (A7 << 15 | A7 >>> 17) * 5 ^ C0) * 3 ^ B5 ^ B1 & ~BE ^ M8;
            B8 = ~(B8 << 1 | B8 >>> 31) ^ A8;
            A9 = (A9 ^ (A8 << 15 | A8 >>> 17) * 5 ^ CF) * 3 ^ B6 ^ B2 & ~BF ^ M9;
            B9 = ~(B9 << 1 | B9 >>> 31) ^ A9;
            AA = (AA ^ (A9 << 15 | A9 >>> 17) * 5 ^ CE) * 3 ^ B7 ^ B3 & ~B0 ^ MA;
            BA = ~(BA << 1 | BA >>> 31) ^ AA;
            AB = (AB ^ (AA << 15 | AA >>> 17) * 5 ^ CD) * 3 ^ B8 ^ B4 & ~B1 ^ MB;
            BB = ~(BB << 1 | BB >>> 31) ^ AB;
            A0 = (A0 ^ (AB << 15 | AB >>> 17) * 5 ^ CC) * 3 ^ B9 ^ B5 & ~B2 ^ MC;
            BC = ~(BC << 1 | BC >>> 31) ^ A0;
            A1 = (A1 ^ (A0 << 15 | A0 >>> 17) * 5 ^ CB) * 3 ^ BA ^ B6 & ~B3 ^ MD;
            BD = ~(BD << 1 | BD >>> 31) ^ A1;
            A2 = (A2 ^ (A1 << 15 | A1 >>> 17) * 5 ^ CA) * 3 ^ BB ^ B7 & ~B4 ^ ME;
            BE = ~(BE << 1 | BE >>> 31) ^ A2;
            A3 = (A3 ^ (A2 << 15 | A2 >>> 17) * 5 ^ C9) * 3 ^ BC ^ B8 & ~B5 ^ MF;
            BF = ~(BF << 1 | BF >>> 31) ^ A3;
            A4 = (A4 ^ (A3 << 15 | A3 >>> 17) * 5 ^ C8) * 3 ^ BD ^ B9 & ~B6 ^ M0;
            B0 = ~(B0 << 1 | B0 >>> 31) ^ A4;
            A5 = (A5 ^ (A4 << 15 | A4 >>> 17) * 5 ^ C7) * 3 ^ BE ^ BA & ~B7 ^ M1;
            B1 = ~(B1 << 1 | B1 >>> 31) ^ A5;
            A6 = (A6 ^ (A5 << 15 | A5 >>> 17) * 5 ^ C6) * 3 ^ BF ^ BB & ~B8 ^ M2;
            B2 = ~(B2 << 1 | B2 >>> 31) ^ A6;
            A7 = (A7 ^ (A6 << 15 | A6 >>> 17) * 5 ^ C5) * 3 ^ B0 ^ BC & ~B9 ^ M3;
            B3 = ~(B3 << 1 | B3 >>> 31) ^ A7;
            A8 = (A8 ^ (A7 << 15 | A7 >>> 17) * 5 ^ C4) * 3 ^ B1 ^ BD & ~BA ^ M4;
            B4 = ~(B4 << 1 | B4 >>> 31) ^ A8;
            A9 = (A9 ^ (A8 << 15 | A8 >>> 17) * 5 ^ C3) * 3 ^ B2 ^ BE & ~BB ^ M5;
            B5 = ~(B5 << 1 | B5 >>> 31) ^ A9;
            AA = (AA ^ (A9 << 15 | A9 >>> 17) * 5 ^ C2) * 3 ^ B3 ^ BF & ~BC ^ M6;
            B6 = ~(B6 << 1 | B6 >>> 31) ^ AA;
            AB = (AB ^ (AA << 15 | AA >>> 17) * 5 ^ C1) * 3 ^ B4 ^ B0 & ~BD ^ M7;
            B7 = ~(B7 << 1 | B7 >>> 31) ^ AB;
            A0 = (A0 ^ (AB << 15 | AB >>> 17) * 5 ^ C0) * 3 ^ B5 ^ B1 & ~BE ^ M8;
            B8 = ~(B8 << 1 | B8 >>> 31) ^ A0;
            A1 = (A1 ^ (A0 << 15 | A0 >>> 17) * 5 ^ CF) * 3 ^ B6 ^ B2 & ~BF ^ M9;
            B9 = ~(B9 << 1 | B9 >>> 31) ^ A1;
            A2 = (A2 ^ (A1 << 15 | A1 >>> 17) * 5 ^ CE) * 3 ^ B7 ^ B3 & ~B0 ^ MA;
            BA = ~(BA << 1 | BA >>> 31) ^ A2;
            A3 = (A3 ^ (A2 << 15 | A2 >>> 17) * 5 ^ CD) * 3 ^ B8 ^ B4 & ~B1 ^ MB;
            BB = ~(BB << 1 | BB >>> 31) ^ A3;
            A4 = (A4 ^ (A3 << 15 | A3 >>> 17) * 5 ^ CC) * 3 ^ B9 ^ B5 & ~B2 ^ MC;
            BC = ~(BC << 1 | BC >>> 31) ^ A4;
            A5 = (A5 ^ (A4 << 15 | A4 >>> 17) * 5 ^ CB) * 3 ^ BA ^ B6 & ~B3 ^ MD;
            BD = ~(BD << 1 | BD >>> 31) ^ A5;
            A6 = (A6 ^ (A5 << 15 | A5 >>> 17) * 5 ^ CA) * 3 ^ BB ^ B7 & ~B4 ^ ME;
            BE = ~(BE << 1 | BE >>> 31) ^ A6;
            A7 = (A7 ^ (A6 << 15 | A6 >>> 17) * 5 ^ C9) * 3 ^ BC ^ B8 & ~B5 ^ MF;
            BF = ~(BF << 1 | BF >>> 31) ^ A7;
            A8 = (A8 ^ (A7 << 15 | A7 >>> 17) * 5 ^ C8) * 3 ^ BD ^ B9 & ~B6 ^ M0;
            B0 = ~(B0 << 1 | B0 >>> 31) ^ A8;
            A9 = (A9 ^ (A8 << 15 | A8 >>> 17) * 5 ^ C7) * 3 ^ BE ^ BA & ~B7 ^ M1;
            B1 = ~(B1 << 1 | B1 >>> 31) ^ A9;
            AA = (AA ^ (A9 << 15 | A9 >>> 17) * 5 ^ C6) * 3 ^ BF ^ BB & ~B8 ^ M2;
            B2 = ~(B2 << 1 | B2 >>> 31) ^ AA;
            AB = (AB ^ (AA << 15 | AA >>> 17) * 5 ^ C5) * 3 ^ B0 ^ BC & ~B9 ^ M3;
            B3 = ~(B3 << 1 | B3 >>> 31) ^ AB;
            A0 = (A0 ^ (AB << 15 | AB >>> 17) * 5 ^ C4) * 3 ^ B1 ^ BD & ~BA ^ M4;
            B4 = ~(B4 << 1 | B4 >>> 31) ^ A0;
            A1 = (A1 ^ (A0 << 15 | A0 >>> 17) * 5 ^ C3) * 3 ^ B2 ^ BE & ~BB ^ M5;
            B5 = ~(B5 << 1 | B5 >>> 31) ^ A1;
            A2 = (A2 ^ (A1 << 15 | A1 >>> 17) * 5 ^ C2) * 3 ^ B3 ^ BF & ~BC ^ M6;
            B6 = ~(B6 << 1 | B6 >>> 31) ^ A2;
            A3 = (A3 ^ (A2 << 15 | A2 >>> 17) * 5 ^ C1) * 3 ^ B4 ^ B0 & ~BD ^ M7;
            B7 = ~(B7 << 1 | B7 >>> 31) ^ A3;
            A4 = (A4 ^ (A3 << 15 | A3 >>> 17) * 5 ^ C0) * 3 ^ B5 ^ B1 & ~BE ^ M8;
            B8 = ~(B8 << 1 | B8 >>> 31) ^ A4;
            A5 = (A5 ^ (A4 << 15 | A4 >>> 17) * 5 ^ CF) * 3 ^ B6 ^ B2 & ~BF ^ M9;
            B9 = ~(B9 << 1 | B9 >>> 31) ^ A5;
            A6 = (A6 ^ (A5 << 15 | A5 >>> 17) * 5 ^ CE) * 3 ^ B7 ^ B3 & ~B0 ^ MA;
            BA = ~(BA << 1 | BA >>> 31) ^ A6;
            A7 = (A7 ^ (A6 << 15 | A6 >>> 17) * 5 ^ CD) * 3 ^ B8 ^ B4 & ~B1 ^ MB;
            BB = ~(BB << 1 | BB >>> 31) ^ A7;
            A8 = (A8 ^ (A7 << 15 | A7 >>> 17) * 5 ^ CC) * 3 ^ B9 ^ B5 & ~B2 ^ MC;
            BC = ~(BC << 1 | BC >>> 31) ^ A8;
            A9 = (A9 ^ (A8 << 15 | A8 >>> 17) * 5 ^ CB) * 3 ^ BA ^ B6 & ~B3 ^ MD;
            BD = ~(BD << 1 | BD >>> 31) ^ A9;
            AA = (AA ^ (A9 << 15 | A9 >>> 17) * 5 ^ CA) * 3 ^ BB ^ B7 & ~B4 ^ ME;
            BE = ~(BE << 1 | BE >>> 31) ^ AA;
            AB = (AB ^ (AA << 15 | AA >>> 17) * 5 ^ C9) * 3 ^ BC ^ B8 & ~B5 ^ MF;
            BF = ~(BF << 1 | BF >>> 31) ^ AB;
            AB += C6 + CA + CE;
            AA += C5 + C9 + CD;
            A9 += C4 + C8 + CC;
            A8 += C3 + C7 + CB;
            A7 += C2 + C6 + CA;
            A6 += C1 + C5 + C9;
            A5 += C0 + C4 + C8;
            A4 += CF + C3 + C7;
            A3 += CE + C2 + C6;
            A2 += CD + C1 + C5;
            A1 += CC + C0 + C4;
            A0 += CB + CF + C3;
            int tmp = B0;
            B0 = C0 - M0;
            C0 = tmp;
            tmp = B1;
            B1 = C1 - M1;
            C1 = tmp;
            tmp = B2;
            B2 = C2 - M2;
            C2 = tmp;
            tmp = B3;
            B3 = C3 - M3;
            C3 = tmp;
            tmp = B4;
            B4 = C4 - M4;
            C4 = tmp;
            tmp = B5;
            B5 = C5 - M5;
            C5 = tmp;
            tmp = B6;
            B6 = C6 - M6;
            C6 = tmp;
            tmp = B7;
            B7 = C7 - M7;
            C7 = tmp;
            tmp = B8;
            B8 = C8 - M8;
            C8 = tmp;
            tmp = B9;
            B9 = C9 - M9;
            C9 = tmp;
            tmp = BA;
            BA = CA - MA;
            CA = tmp;
            tmp = BB;
            BB = CB - MB;
            CB = tmp;
            tmp = BC;
            BC = CC - MC;
            CC = tmp;
            tmp = BD;
            BD = CD - MD;
            CD = tmp;
            tmp = BE;
            BE = CE - ME;
            CE = tmp;
            tmp = BF;
            BF = CF - MF;
            CF = tmp;
        }
        this.state[0] = A0;
        this.state[1] = A1;
        this.state[2] = A2;
        this.state[3] = A3;
        this.state[4] = A4;
        this.state[5] = A5;
        this.state[6] = A6;
        this.state[7] = A7;
        this.state[8] = A8;
        this.state[9] = A9;
        this.state[10] = AA;
        this.state[11] = AB;
        this.state[12] = B0;
        this.state[13] = B1;
        this.state[14] = B2;
        this.state[15] = B3;
        this.state[16] = B4;
        this.state[17] = B5;
        this.state[18] = B6;
        this.state[19] = B7;
        this.state[20] = B8;
        this.state[21] = B9;
        this.state[22] = BA;
        this.state[23] = BB;
        this.state[24] = BC;
        this.state[25] = BD;
        this.state[26] = BE;
        this.state[27] = BF;
        this.state[28] = C0;
        this.state[29] = C1;
        this.state[30] = C2;
        this.state[31] = C3;
        this.state[32] = C4;
        this.state[33] = C5;
        this.state[34] = C6;
        this.state[35] = C7;
        this.state[36] = C8;
        this.state[37] = C9;
        this.state[38] = CA;
        this.state[39] = CB;
        this.state[40] = CC;
        this.state[41] = CD;
        this.state[42] = CE;
        this.state[43] = CF;
    }

    @Override
    public String toString() {
        return "Shabal-" + (this.getDigestLength() << 3);
    }
}

