/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import java.util.ArrayList;
import java.util.Arrays;

public class StrUtils {
    public static final char DOUBLEQUOTE_CHAR = '\"';
    public static String SEP = "\u001d\u001e\u001f";

    public String[] processQuoted(String cmd) {
        if (cmd == null) {
            return new String[0];
        }
        cmd = cmd.replace("\r", "");
        String[] inCMD = null;
        if (cmd.indexOf(SEP) != -1) {
            inCMD = cmd.split("(" + SEP + ")+");
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, "v2 recon: " + Arrays.asList(inCMD));
            }
            return inCMD;
        }
        if (cmd.indexOf(34) != -1) {
            inCMD = cmd.split(" {1}");
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, "v2 recon: " + Arrays.asList(inCMD));
            }
            ArrayList<String> params = new ArrayList<String>(inCMD.length);
            boolean quoteStarted = false;
            String quoted = null;
            for (int i = 0; i < inCMD.length; ++i) {
                String el;
                int firstQ = inCMD[i].indexOf("\"");
                int lastQ = inCMD[i].lastIndexOf("\"");
                if (!quoteStarted && firstQ != -1 && firstQ == lastQ) {
                    quoteStarted = true;
                    quoted = inCMD[i] + " ";
                    continue;
                }
                if (quoteStarted && inCMD[i].endsWith("\\\"")) {
                    quoted = quoted + inCMD[i] + " ";
                    continue;
                }
                if (quoteStarted && !inCMD[i].endsWith("\"")) {
                    quoted = quoted + inCMD[i] + " ";
                    continue;
                }
                if (quoteStarted && inCMD[i].endsWith("\"")) {
                    quoted = quoted + inCMD[i];
                    quoteStarted = false;
                    el = quoted.replace("\\\"", "\"");
                    params.add(el);
                    quoted = null;
                    continue;
                }
                el = inCMD[i].replace("\\\"", "\"");
                if (el.equals("")) continue;
                params.add(el);
            }
            if (quoted != null && !quoted.equals("")) {
                params.add(quoted.replace("\\\"", "\""));
            }
            inCMD = params.toArray(new String[0]);
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, "msg recon: " + params);
            }
        } else {
            inCMD = cmd.split(" +");
        }
        return inCMD;
    }

    public String[] processQuoted(String cmd, char splitChar) {
        if (cmd == null) {
            return new String[0];
        }
        cmd = cmd.replace("\r", "");
        String[] inCMD = null;
        if (cmd.indexOf(34) != -1) {
            inCMD = cmd.split(splitChar + "{1}");
            ArrayList<String> params = new ArrayList<String>(inCMD.length);
            boolean quoteStarted = false;
            String quoted = null;
            for (int i = 0; i < inCMD.length; ++i) {
                String el;
                int firstQ = inCMD[i].indexOf("\"");
                int lastQ = inCMD[i].lastIndexOf("\"");
                if (!quoteStarted && firstQ != -1 && firstQ == lastQ) {
                    quoteStarted = true;
                    quoted = inCMD[i] + splitChar;
                    continue;
                }
                if (quoteStarted && inCMD[i].endsWith("\\\"")) {
                    quoted = quoted + inCMD[i] + splitChar;
                    continue;
                }
                if (quoteStarted && !inCMD[i].endsWith("\"")) {
                    quoted = quoted + inCMD[i] + splitChar;
                    continue;
                }
                if (quoteStarted && inCMD[i].endsWith("\"")) {
                    quoted = quoted + inCMD[i];
                    quoteStarted = false;
                    el = quoted.replace("\\\"", "\"");
                    params.add(el);
                    quoted = null;
                    continue;
                }
                el = inCMD[i].replace("\\\"", "\"");
                params.add(el);
            }
            if (quoted != null) {
                params.add(quoted.replace("\\\"", "\""));
            }
            inCMD = params.toArray(new String[0]);
        } else {
            inCMD = cmd.split(splitChar + "{1}");
        }
        return inCMD;
    }

    public String removeQuotes(String in) {
        if (in != null) {
            if (in.length() > 0 && in.charAt(0) == '\"') {
                in = in.substring(1);
            }
            if (in.endsWith("\"")) {
                in = in.substring(0, in.length() - 1);
            }
        }
        return in;
    }

    public String removeQuotesStrict(String in) {
        if (in != null && in.startsWith("\"") && in.endsWith("\"")) {
            in = in.substring(1, in.length() - 1);
        }
        return in;
    }

    public String removeQuotesStrict(StringBuffer in) {
        if (in == null) {
            return null;
        }
        if (in.length() > 1 && in.charAt(0) == '\"' && in.charAt(in.length() - 1) == '\"') {
            in = in.deleteCharAt(0);
            in = in.deleteCharAt(in.length() - 1);
        }
        return in.toString();
    }

    public String removeQuotesStrict(StringBuilder in) {
        if (in == null) {
            return null;
        }
        if (in.length() > 1 && in.charAt(0) == '\"' && in.charAt(in.length() - 1) == '\"') {
            in = in.deleteCharAt(0);
            in = in.deleteCharAt(in.length() - 1);
        }
        return in.toString();
    }

    public String[] split(String input, char character) {
        if (input == null) {
            return new String[0];
        }
        String[] res = new String[]{};
        if (input != null) {
            res = input.split("(?<![\\\\])(?:[" + character + "])");
            for (int i = 0; i < res.length; ++i) {
                res[i] = res[i].replace("\\" + character, "" + character).trim();
            }
        }
        return res;
    }

    public String[] split(String input, String separators) {
        if (input == null) {
            return null;
        }
        ArrayList<String> arr = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean isDQ = false;
        for (int i = 0; i < input.length(); ++i) {
            if (!isDQ && separators.indexOf(input.charAt(i)) != -1) {
                arr.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (input.charAt(i) == '\\') {
                if (i < input.length() - 1) {
                    sb.append(input.charAt(++i));
                    continue;
                }
                sb.append('\\');
                continue;
            }
            if (input.charAt(i) == '\"') {
                isDQ = !isDQ;
            }
            sb.append(input.charAt(i));
        }
        arr.add(sb.toString());
        return arr.toArray(new String[0]);
    }

    public static boolean areStringEquals(String val1, String val2) {
        return val1 == null ? val2 == null : val1.equals(val2);
    }
}

