/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.log.RTLogger;
import com.blixx.shared.exceptions.LockedFileException;
import com.blixx.shared.utils.AsfUtils;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.zip.ZipEntry;
import com.blixx.shared.zip.ZipFile;
import com.blixx.shared.zip.ZipOutputStream;
import com.boom.SharedLocks;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;

public class ZIP {
    public static final String DIRECTORY_IS_EMPTY = "Directory is empty";
    protected List<Pattern> exceptMasks = new ArrayList<Pattern>();
    protected String specificAgentID = null;
    protected boolean isSpecificFound = false;

    public void addExceptionMask(String mask) {
        mask = mask.replace(".", "\\.");
        mask = mask.replace("*", ".*");
        mask = mask.replace("?", ".");
        Pattern p = Pattern.compile(mask);
        this.exceptMasks.add(p);
    }

    public void cleanExceptions() {
        this.exceptMasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipAgent(String sourcePath, String targetZipPath, File agent, File conf, File agtTrustStore) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipPath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            this.zipFile(zos, agent, agent.getParentFile().getPath() + File.separatorChar);
            ZipEntry anEntry = new ZipEntry("conf/");
            anEntry.setUnixMode(16877);
            zos.putNextEntry(anEntry);
            this.zipAgent(zos, "conf/", conf);
            SharedLocks.agentTsFileLock.readLock().lock();
            try {
                if (agtTrustStore != null && agtTrustStore.exists() && agtTrustStore.isFile()) {
                    this.zipAgent(zos, "conf/", agtTrustStore);
                }
            }
            finally {
                SharedLocks.agentTsFileLock.readLock().unlock();
            }
            String zipRootPath = sourcePath + File.separatorChar;
            try {
                this.zipDir(sourcePath, zos, zipRootPath);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public void zipDir(String sourcePath, String targetZipPath) throws FileNotFoundException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipPath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            String zipRootPath = sourcePath + File.separator;
            this.zipDir(sourcePath, zos, zipRootPath);
        }
    }

    public void zipDir(String sourcePath, List<String> onlySubDirs, String targetZipPath) throws FileNotFoundException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipPath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            String zipRootPath = sourcePath + File.separator;
            for (int i = 0; i < onlySubDirs.size(); ++i) {
                File f = new File(sourcePath, onlySubDirs.get(i));
                if (!f.exists() || !f.isDirectory()) continue;
                String filePath = f.getPath();
                String zipPath = f.getPath().replace(zipRootPath, "");
                ZipEntry anEntry = new ZipEntry(zipPath + "/");
                anEntry.setUnixMode(16877);
                zos.putNextEntry(anEntry);
                try {
                    this.zipDir(filePath, zos, zipRootPath);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public void zipDirZero(String sourcePath, String targetZipPath) throws FileNotFoundException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipPath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            sourcePath = sourcePath.replace('\\', File.separatorChar);
            sourcePath = sourcePath.replace('/', File.separatorChar);
            if (sourcePath.endsWith(File.separator)) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            String zipRootPath = sourcePath + File.separator;
            this.zipDir(sourcePath, zos, zipRootPath);
        }
    }

    public void zipDirZero(String dir2zip, ZipOutputStream zos, String zipRootPath) throws FileNotFoundException, IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                String zipPath = f.getPath().replace(zipRootPath, "");
                ZipEntry anEntry = new ZipEntry(zipPath + "/");
                anEntry.setUnixMode(16877);
                zos.putNextEntry(anEntry);
                this.zipDirZero(filePath, zos, zipRootPath);
                continue;
            }
            if (this.exceptMasks.size() > 0) {
                boolean toSkip = false;
                for (Pattern p : this.exceptMasks) {
                    String cpath;
                    Matcher m = p.matcher(cpath = f.getCanonicalPath());
                    if (!m.matches()) continue;
                    toSkip = true;
                    RTLogger.print(4, "Skipped zipping file: " + cpath);
                    break;
                }
                if (toSkip) continue;
            }
            this.zipFileZero(zos, f, zipRootPath);
        }
    }

    public void zipDir(String dir2zip, ZipOutputStream zos, String zipRootPath) throws FileNotFoundException, IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        if (dirList.length == 0) {
            throw new FileNotFoundException("Directory is empty {" + dir2zip + "}");
        }
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                String zipPath = f.getPath().replace(zipRootPath, "");
                ZipEntry anEntry = new ZipEntry(zipPath + "/");
                anEntry.setUnixMode(16877);
                zos.putNextEntry(anEntry);
                try {
                    this.zipDir(filePath, zos, zipRootPath);
                }
                catch (FileNotFoundException fileNotFoundException) {}
                continue;
            }
            if (!this.exceptMasks.isEmpty()) {
                boolean toSkip = false;
                for (Pattern p : this.exceptMasks) {
                    String cpath;
                    Matcher m = p.matcher(cpath = f.getCanonicalPath());
                    if (!m.matches()) continue;
                    toSkip = true;
                    RTLogger.print(4, "Skipped zipping file: " + cpath);
                    break;
                }
                if (toSkip) continue;
            }
            this.zipFile(zos, f, zipRootPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipFile(ZipOutputStream zos, File f, String rootPath) throws FileNotFoundException, IOException {
        byte[] readBuffer = new byte[64000];
        int bytesIn = 0;
        InputStream fis = null;
        try {
            String zipPath = f.getPath().replace(rootPath, "");
            zipPath = zipPath.replace('\\', '/');
            ZipEntry anEntry = new ZipEntry(zipPath);
            zos.putNextEntry(anEntry);
            if (this.isForceAgentSpecificFilesProcessing() && f.getName().toLowerCase().endsWith(".asf")) {
                String data = AsfUtils.getAgentSpecificJson(f, this.specificAgentID);
                if (data == null) {
                    fis = new FileInputStream(f);
                } else {
                    fis = new ByteArrayInputStream(data.getBytes());
                    this.isSpecificFound = true;
                }
            } else {
                fis = new FileInputStream(f);
            }
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public byte[] zipString(String nonZipString) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(nonZipString.getBytes("UTF-8"));
             DeflaterOutputStream os = new DeflaterOutputStream((OutputStream)bos, new Deflater(-1), true);){
            this.copyInputStream(bis, os);
        }
        return bos.toByteArray();
    }

    public String unzipString(byte[] zipedString) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(zipedString);
             InflaterOutputStream inf = new InflaterOutputStream(bos, new Inflater());){
            this.copyInputStream(bis, inf);
        }
        return bos.toString("UTF-8");
    }

    public void zipFileZero(ZipOutputStream zos, File f, String rootPath) throws FileNotFoundException, IOException {
        String zipPath = f.getPath().replace(rootPath, "");
        ZipEntry anEntry = new ZipEntry(zipPath);
        zos.putNextEntry(anEntry);
    }

    public void zipAgent(ZipOutputStream zos, String zipPath, File f) throws FileNotFoundException, IOException {
        byte[] readBuffer = new byte[64000];
        int bytesIn = 0;
        try (FileInputStream fis = new FileInputStream(f);){
            if (!zipPath.endsWith("/")) {
                zipPath = zipPath + "/";
            }
            zipPath = zipPath.replace('\\', '/');
            ZipEntry anEntry = new ZipEntry(zipPath + f.getName());
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
        }
    }

    public List<String> unzip(String zipfile, String targetDir) throws IOException, LockedFileException {
        LinkedList<String> result = new LinkedList<String>();
        File targetD = new File(targetDir);
        if (!targetD.exists()) {
            targetD.mkdirs();
        }
        try (ZipFile zipFile = new ZipFile(zipfile);){
            String name;
            ZipEntry entry;
            Enumeration<ZipEntry> entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                name = entry.getName();
                name = name.replace('\\', File.separatorChar);
                String parent = new File(name = name.replace('/', File.separatorChar)).getParent();
                if (parent != null) {
                    new File(targetD, parent).mkdirs();
                }
                if (!entry.isDirectory()) continue;
                name = name.replace('\\', File.separatorChar);
                File dir = new File(targetD, name = name.replace('/', File.separatorChar));
                if (dir.exists()) continue;
                dir.mkdirs();
            }
            entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                name = entry.getName();
                name = name.replace('\\', File.separatorChar);
                name = name.replace('/', File.separatorChar);
                if (entry.isDirectory()) {
                    File dir = new File(targetD, name);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    } else if (dir.isFile()) {
                        dir.delete();
                        dir.mkdirs();
                    }
                    result.add(dir.getCanonicalPath());
                    continue;
                }
                File nf = new File(targetD, name);
                if (nf.isDirectory()) {
                    FileUtils.deleteDirectoryRecursive(nf.getCanonicalPath());
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(nf, false);){
                    try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                        this.copyInputStream(zipFile.getInputStream(entry), bufferedOutputStream);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                catch (Throwable e) {
                    throw new LockedFileException(e);
                }
                result.add(nf.getCanonicalPath());
            }
        }
        return result;
    }

    public void deleteFilesExcept(List<String> canonical_names, String rootDir) {
        File targetD = new File(rootDir);
        if (targetD.exists() && targetD.isDirectory()) {
            File[] list = targetD.listFiles();
            for (int i = 0; i < list.length; ++i) {
                try {
                    String cname = list[i].getCanonicalPath();
                    if (list[i].isDirectory()) {
                        this.deleteFilesExcept(canonical_names, cname);
                        File[] rest = list[i].listFiles();
                        if (rest == null || rest.length != 0 || canonical_names.contains(cname)) continue;
                        list[i].delete();
                        continue;
                    }
                    if (canonical_names.contains(cname)) continue;
                    if (!this.exceptMasks.isEmpty()) {
                        boolean toSkip = false;
                        for (Pattern p : this.exceptMasks) {
                            String cpath;
                            Matcher m = p.matcher(cpath = list[i].getCanonicalPath());
                            if (!m.matches()) continue;
                            toSkip = true;
                            break;
                        }
                        if (toSkip) continue;
                    }
                    list[i].delete();
                    continue;
                }
                catch (Throwable e) {
                    RTLogger.print(3, "Can't delete file: " + list[i].getName());
                }
            }
        }
    }

    private synchronized void copyInputStream(InputStream inp, OutputStream outp) throws IOException {
        try (InputStream in = inp;
             OutputStream out = outp;){
            byte[] buffer = new byte[64000];
            int len = 0;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public boolean isForceAgentSpecificFilesProcessing() {
        return this.specificAgentID != null;
    }

    public void setForceAgentSpecificFilesProcessing(String agentID) {
        this.specificAgentID = agentID;
        this.isSpecificFound = false;
    }

    public boolean isAgentSpecificFileFound() {
        return this.isSpecificFound;
    }
}

