/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt;

import com.blixx.shared.Cryptor;
import com.boom.crt.hlp.BasicCertificateInfo;
import com.boom.crt.hlp.CertificateSerializationHelper;
import com.boom.crt.hlp.KeyStoreUtils;
import com.boom.crt.hlp.NotSupportedCertificateException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.security.x509.X509CertImpl;

public class KeyStoreBase {
    public static final String RSA = "RSA";
    public static final String SHA256_WITH_RSA = "SHA256WithRSA";
    public static final String PKCS12 = "PKCS12";
    public static final String JKS = "JKS";
    protected String keyStoreType;
    protected Path keyStoreTmpPath;
    protected Path keyStorePath;
    protected String pwdEncrypted;
    protected KeyStore keyStore;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public KeyStoreBase(String keyStoreType, Path keyStorePath, String pwdEncrypted) {
        this.keyStoreType = keyStoreType;
        this.keyStorePath = keyStorePath.toAbsolutePath();
        this.keyStoreTmpPath = keyStorePath.toAbsolutePath().getParent().resolve(keyStorePath.getFileName() + "_tmp");
        this.pwdEncrypted = pwdEncrypted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createKeyStore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore ks = KeyStore.getInstance(this.keyStoreType);
        ks.load(null, this.getPwdArray());
        this.lock.writeLock().lock();
        try {
            if (!Files.exists(this.keyStoreTmpPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.keyStoreTmpPath.getParent(), new FileAttribute[0]);
            }
            try (OutputStream outputStream = Files.newOutputStream(this.keyStoreTmpPath, new OpenOption[0]);){
                ks.store(outputStream, this.getPwdArray());
            }
            Files.move(this.keyStoreTmpPath, this.keyStorePath, StandardCopyOption.ATOMIC_MOVE);
            this.keyStore = ks;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore ks = KeyStore.getInstance(this.keyStoreType);
        this.lock.readLock().lock();
        try (InputStream inputStream = Files.newInputStream(this.keyStorePath, new OpenOption[0]);){
            ks.load(inputStream, this.getPwdArray());
            this.keyStore = ks;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        this.lock.writeLock().lock();
        try {
            try (OutputStream outputStream = Files.newOutputStream(this.keyStoreTmpPath, new OpenOption[0]);){
                this.keyStore.store(outputStream, this.getPwdArray());
            }
            Files.move(this.keyStoreTmpPath, this.keyStorePath, StandardCopyOption.ATOMIC_MOVE);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<BasicCertificateInfo> getCertificatesInfo() throws KeyStoreException, CertificateParsingException {
        ArrayList<BasicCertificateInfo> result = new ArrayList<BasicCertificateInfo>();
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = this.keyStore.getCertificate(alias);
            if (!(cert instanceof X509Certificate)) continue;
            result.add(new BasicCertificateInfo(alias, (X509Certificate)cert));
        }
        return result;
    }

    public void importCertificate(String alias, byte[] certBytes) throws CertificateException, IOException, KeyStoreException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(certBytes));){
            if (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                this.keyStore.setCertificateEntry(alias, cert);
            }
        }
    }

    public void importCertificate(String alias, Certificate cert) throws CertificateException, IOException, KeyStoreException {
        this.keyStore.setCertificateEntry(alias, cert);
    }

    public boolean importTrustedCACertificate(byte[] certBytes) throws CertificateException, IOException, KeyStoreException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(certBytes));){
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                certificates.add(cert);
            }
        }
        return KeyStoreUtils.importTrustedCACertificatesIgnoringDuplicates(certificates, this);
    }

    public byte[] exportCertificate(String alias) throws KeyStoreException, IOException, CertificateEncodingException, NotSupportedCertificateException {
        Certificate cert = this.keyStore.getCertificate(alias);
        if (cert instanceof X509CertImpl) {
            return CertificateSerializationHelper.serializeCertificate((X509CertImpl)cert);
        }
        throw new NotSupportedCertificateException("Certificate format not supported. Expected X509Certificate found " + cert.getClass().getName());
    }

    public void deleteCertificate(String alias) throws KeyStoreException {
        this.keyStore.deleteEntry(alias);
    }

    public boolean isEmpty() throws KeyStoreException {
        return !this.keyStore.aliases().hasMoreElements();
    }

    public char[] getPwdArray() {
        return Cryptor.decrypt(this.pwdEncrypted).toCharArray();
    }

    public Path getKeyStorePath() {
        return this.keyStorePath;
    }

    public boolean isSelfSignedCertificate(String alias) throws KeyStoreException {
        boolean result = false;
        Certificate[] chain = this.keyStore.getCertificateChain(alias);
        if (chain.length == 1 && chain[0] instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)chain[0];
            result = cert.getSubjectX500Principal().equals(cert.getIssuerX500Principal());
        }
        return result;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getPwdEncrypted() {
        return this.pwdEncrypted;
    }

    public boolean exists() {
        return Files.exists(this.keyStorePath, new LinkOption[0]) && Files.isRegularFile(this.keyStorePath, new LinkOption[0]);
    }
}

