/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt;

import com.boom.crt.GeneralNameParsingException;
import com.boom.crt.KeyStoreBase;
import com.boom.crt.hlp.CertificateSerializationHelper;
import com.boom.crt.hlp.KeyStoreUtils;
import com.boom.crt.hlp.NotSupportedCertificateException;
import com.boom.crt.hlp.SubjectAlternativeNameEntry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs10.PKCS10;
import sun.security.pkcs10.PKCS10Attribute;
import sun.security.pkcs10.PKCS10Attributes;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KeyStoreClient
extends KeyStoreBase {
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);

    public KeyStoreClient(String keyStoreType, Path keyStorePath, String pwdEncrypted) {
        super(keyStoreType, keyStorePath, pwdEncrypted);
    }

    public byte[] signCertificateRequest(String aliasOfSigner, byte[] csrBytes, int daysValid, String algorithm, boolean sanCritical, List<SubjectAlternativeNameEntry> sanList) throws CertificateException, NoSuchAlgorithmException, IOException, SignatureException, NoSuchProviderException, InvalidKeyException, UnrecoverableKeyException, KeyStoreException, GeneralNameParsingException, NotSupportedCertificateException {
        Key signerKey = this.keyStore.getKey(aliasOfSigner, this.getPwdArray());
        Certificate signerCertificate = this.keyStore.getCertificate(aliasOfSigner);
        if (signerCertificate instanceof X509Certificate) {
            X500Principal subjectX500Principal = ((X509Certificate)signerCertificate).getSubjectX500Principal();
            byte[] bareCSR = CertificateSerializationHelper.stripCertificateDelimiters(csrBytes);
            PKCS10 csr = new PKCS10(Base64.getMimeDecoder().decode(bareCSR));
            GeneralNames generalNames = new GeneralNames();
            for (SubjectAlternativeNameEntry subjectAlternativeNameEntry : sanList) {
                generalNames.add(subjectAlternativeNameEntry.toGeneralName());
            }
            GeneralNames generalNamesFromCSR = KeyStoreUtils.extractSubjectAlternativeNamesFromCRS(csr);
            for (GeneralName name : generalNamesFromCSR.names()) {
                generalNames.add(name);
            }
            X509CertImpl x509CertImpl = KeyStoreUtils.sign((PrivateKey)signerKey, signerCertificate.getPublicKey(), csr.getSubjectPublicKeyInfo(), subjectX500Principal.toString(), csr.getSubjectName().getName(), daysValid, algorithm, sanCritical, generalNames, false, 0);
            StringBuilder builder = new StringBuilder();
            builder.append(new String(CertificateSerializationHelper.serializeCertificate(x509CertImpl)));
            builder.append(new String(CertificateSerializationHelper.serializeCertificate((X509Certificate)signerCertificate)));
            return builder.toString().getBytes();
        }
        throw new NotSupportedCertificateException("Certificate format not supported. Expected X509Certificate found " + signerCertificate.getClass().getName());
    }

    public void generateAndImportSelfSignedCertificate(String alias, String distinguishedName, int daysValid, String algorithm, boolean sanCritical, List<SubjectAlternativeNameEntry> sanList, boolean isCA, int len) throws GeneralSecurityException, IOException, GeneralNameParsingException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        GeneralNames generalNames = new GeneralNames();
        for (SubjectAlternativeNameEntry sanEntry : sanList) {
            generalNames.add(sanEntry.toGeneralName());
        }
        X509CertImpl certificate = KeyStoreUtils.sign(keyPair.getPrivate(), keyPair.getPublic(), keyPair.getPublic(), distinguishedName, distinguishedName, daysValid, algorithm, sanCritical, generalNames, isCA, len);
        Certificate[] certChain = new Certificate[]{certificate};
        this.keyStore.setKeyEntry(alias, keyPair.getPrivate(), this.getPwdArray(), certChain);
    }

    public void generateAndImportSelfSignedCertificate(String alias, String distinguishedName, int daysValid, String algorithm, boolean sanCritical, List<SubjectAlternativeNameEntry> sanList, boolean isCA) throws GeneralSecurityException, IOException, GeneralNameParsingException {
        this.generateAndImportSelfSignedCertificate(alias, distinguishedName, daysValid, algorithm, sanCritical, sanList, isCA, 1);
    }

    public byte[] createAgentCertificateRequest(String alias, Collection<String> allIPs, Collection<String> allHostnames) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, GeneralNameParsingException, SignatureException, InvalidKeyException, IOException {
        List<SubjectAlternativeNameEntry> sans = KeyStoreUtils.getSubjectAlternativeNameEntries(allIPs, allHostnames);
        return this.createCertificateRequest(alias, false, sans);
    }

    public byte[] createCertificateRequest(String alias, boolean sanCritical, List<SubjectAlternativeNameEntry> sanList) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, SignatureException, InvalidKeyException, IOException, GeneralNameParsingException {
        Key key = this.keyStore.getKey(alias, this.getPwdArray());
        if (key instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)key;
            Certificate cert = this.keyStore.getCertificate(alias);
            X500Principal subjectX500Principal = ((X509Certificate)cert).getSubjectX500Principal();
            PublicKey publicKey = cert.getPublicKey();
            PKCS10 certificateRequest = new PKCS10(publicKey);
            CertificateExtensions certificateExtensions = new CertificateExtensions();
            SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(new KeyIdentifier(publicKey).getIdentifier());
            certificateExtensions.set("SubjectKeyIdentifier", subjectKeyIdentifierExtension);
            PKCS10Attributes attributes = certificateRequest.getAttributes();
            PKCS10Attribute attribute = new PKCS10Attribute(PKCS9Attribute.EXTENSION_REQUEST_OID, certificateExtensions);
            attributes.setAttribute("extensions", attribute);
            if (sanList != null && !sanList.isEmpty()) {
                GeneralNames generalNames = new GeneralNames();
                for (SubjectAlternativeNameEntry sanEntry : sanList) {
                    generalNames.add(sanEntry.toGeneralName());
                }
                SubjectAlternativeNameExtension sanExtension = new SubjectAlternativeNameExtension((Boolean)sanCritical, generalNames);
                certificateExtensions.set("SubjectAlternativeName", sanExtension);
            }
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(privateKey);
            X500Name x500name = new X500Name(subjectX500Principal.getEncoded());
            certificateRequest.encodeAndSign(x500name, signature);
            return CertificateSerializationHelper.serializeCertificateRequest(certificateRequest);
        }
        throw new UnrecoverableKeyException("Key for alias " + alias + " found in key store is not PrivateKey");
    }

    public void importPrivateKeyCertificate(String alias, InputStream signedCertInputStream, Certificate[] certChainFromCA) throws CertificateException, IOException, KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        BufferedInputStream bis = new BufferedInputStream(signedCertInputStream);
        if (bis.available() > 0) {
            Certificate signedCert = cf.generateCertificate(bis);
            Key privateKey = this.keyStore.getKey(alias, this.getPwdArray());
            if (privateKey instanceof PrivateKey) {
                Certificate[] certChain = new Certificate[certChainFromCA.length + 1];
                certChain[0] = signedCert;
                for (int i = 1; i < certChain.length; ++i) {
                    certChain[i] = certChainFromCA[i - 1];
                }
                this.keyStore.setKeyEntry(alias, privateKey, this.getPwdArray(), certChain);
            }
        }
    }

    public void importPrivateKeyCertificate(String alias, byte[] signedCert) throws CertificateException, IOException, KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(signedCert));
        Key privateKey = this.keyStore.getKey(alias, this.getPwdArray());
        if (privateKey instanceof PrivateKey) {
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                certificates.add(cert);
            }
            for (int i = 1; i < certificates.size(); ++i) {
                this.keyStore.setCertificateEntry(KeyStoreUtils.getNextCAAlias(this), (Certificate)certificates.get(i));
            }
            this.keyStore.setKeyEntry(alias, privateKey, this.getPwdArray(), certificates.toArray(new Certificate[certificates.size()]));
        }
    }
}

