/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt.hlp;

import com.blixx.log.RTLogger;
import com.boom.crt.KeyStoreBase;
import com.boom.crt.TrustStoreClient;
import com.boom.crt.hlp.CertificateSerializationHelper;
import com.boom.crt.hlp.SubjectAlternativeNameEntry;
import com.boom.crt.hlp.SubjectAlternativeNameExtension;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs10.PKCS10;
import sun.security.pkcs10.PKCS10Attribute;
import sun.security.pkcs10.PKCS10Attributes;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KeyStoreUtils {
    private static final Pattern caAliasPattern = Pattern.compile("^ca(_(\\d+))?$");

    private KeyStoreUtils() {
    }

    private static int getMaxCANum(KeyStoreBase trustStoreClient) throws KeyStoreException {
        int maxCANum = -1;
        Enumeration<String> aliases = trustStoreClient.getKeyStore().aliases();
        while (aliases.hasMoreElements()) {
            String caNumStr;
            String alias = aliases.nextElement();
            Matcher matcher = caAliasPattern.matcher(alias);
            if (!matcher.find()) continue;
            if (maxCANum < 0) {
                maxCANum = 0;
            }
            if ((caNumStr = matcher.group(2)) == null) continue;
            try {
                int caNum = Integer.parseInt(caNumStr);
                if (caNum <= maxCANum) continue;
                maxCANum = caNum;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxCANum;
    }

    public static String getNextCAAlias(KeyStoreBase trustStoreClient) throws KeyStoreException {
        int maxNum = KeyStoreUtils.getMaxCANum(trustStoreClient);
        return KeyStoreUtils.caNumToAlias(maxNum + 1);
    }

    public static Optional<String> getLatestCAAlias(TrustStoreClient trustStoreClient) throws KeyStoreException {
        Optional<String> result = Optional.empty();
        int num = KeyStoreUtils.getMaxCANum(trustStoreClient);
        if (num >= 0) {
            result = Optional.of(KeyStoreUtils.caNumToAlias(num));
        }
        return result;
    }

    private static String caNumToAlias(int num) {
        String result = num == 0 ? "ca" : "ca_" + num;
        return result;
    }

    public static String getHumanReadableVerificationResult(CertPathValidatorException e) {
        return String.format("Certificate %d in chain affected: %s", e.getIndex(), e.getReason().toString());
    }

    public static boolean matchesCAAliasConvention(String alias) {
        return caAliasPattern.matcher(alias).matches();
    }

    public static boolean importTrustedCACertificatesIgnoringDuplicates(List<Certificate> certificates, KeyStoreBase trustStoreClient) throws KeyStoreException {
        boolean atLeastOneImported = false;
        HashSet<Certificate> trustedCAList = new HashSet<Certificate>();
        KeyStore trustStore = trustStoreClient.getKeyStore();
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!KeyStoreUtils.matchesCAAliasConvention(alias)) continue;
            trustedCAList.add(trustStore.getCertificate(alias));
        }
        for (Certificate cert : certificates) {
            if (trustedCAList.contains(cert)) {
                RTLogger.print(2, "Do not import trusted certificate, since it is already present");
                continue;
            }
            String nextCAAlias = KeyStoreUtils.getNextCAAlias(trustStoreClient);
            RTLogger.print(2, "Importing trusted certificate (" + nextCAAlias + ") " + cert.toString());
            trustStore.setCertificateEntry(nextCAAlias, cert);
            atLeastOneImported = true;
        }
        return atLeastOneImported;
    }

    public static String getKeyStoreType(String ksFile) {
        return ksFile.toLowerCase().endsWith(".p12") ? "PKCS12" : "JKS";
    }

    public static List<SubjectAlternativeNameEntry> getSubjectAlternativeNameEntries(Collection<String> allIPs, Collection<String> allHostnames) {
        ArrayList<SubjectAlternativeNameEntry> sans = new ArrayList<SubjectAlternativeNameEntry>();
        for (String ip : allIPs) {
            sans.add(new SubjectAlternativeNameEntry(SubjectAlternativeNameExtension.IP, ip));
        }
        for (String host : allHostnames) {
            sans.add(new SubjectAlternativeNameEntry(SubjectAlternativeNameExtension.DNS, host));
        }
        return sans;
    }

    public static Path getBackupPath(Path path) {
        return path.toAbsolutePath().getParent().resolve(path.getFileName().toString() + "_bkp");
    }

    public static boolean isCertificateAboutToExpire(KeyStore keyStore, String alias, int agentCertExpirationThresholdDays) throws KeyStoreException {
        boolean result = false;
        Certificate certificate = keyStore.getCertificate(alias);
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            Date notAfter = x509Certificate.getNotAfter();
            result = notAfter.getTime() - TimeUnit.DAYS.toMillis(agentCertExpirationThresholdDays) < System.currentTimeMillis();
        }
        return result;
    }

    public static GeneralNames extractSubjectAlternativeNamesFromCRS(PKCS10 csr) throws IOException {
        GeneralNames generalNames = new GeneralNames();
        PKCS10Attributes attributes = csr.getAttributes();
        for (PKCS10Attribute attr : attributes.getAttributes()) {
            CertificateExtensions certificateExtensions;
            ObjectIdentifier oid = attr.getAttributeId();
            if (!oid.equals(PKCS9Attribute.EXTENSION_REQUEST_OID) || (certificateExtensions = (CertificateExtensions)attr.getAttributeValue()) == null) continue;
            for (Extension extension : certificateExtensions.getAllExtensions()) {
                if (!(extension instanceof sun.security.x509.SubjectAlternativeNameExtension)) continue;
                GeneralNames extractedGeneralNames = ((sun.security.x509.SubjectAlternativeNameExtension)extension).get("subject_name");
                for (GeneralName generalName : extractedGeneralNames.names()) {
                    generalNames.add(generalName);
                }
            }
        }
        return generalNames;
    }

    public static X509CertImpl sign(PrivateKey signerPrivateKey, PublicKey signerPublicKey, PublicKey publicKeyToSign, String signerDistinguishedName, String signedDistinguishedName, int daysValid, String algorithm, boolean sanCritical, GeneralNames generalNames, boolean isCA, int len) throws IOException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        X509CertInfo info = new X509CertInfo();
        Date validFrom = new Date();
        Date validTo = new Date(validFrom.getTime() + TimeUnit.DAYS.toMillis(daysValid));
        X500Name owner = new X500Name(signedDistinguishedName);
        X500Name issuer = new X500Name(signerDistinguishedName);
        info.set("subject", owner);
        info.set("issuer", issuer);
        info.set("validity", new CertificateValidity(validFrom, validTo));
        info.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, new SecureRandom())));
        info.set("key", new CertificateX509Key(publicKeyToSign));
        info.set("version", new CertificateVersion(2));
        info.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(AlgorithmId.sha256WithRSAEncryption_oid)));
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        if (isCA) {
            certificateExtensions.set("BasicConstraints", new BasicConstraintsExtension(true, isCA, len));
        }
        if (!signerPublicKey.equals(publicKeyToSign)) {
            certificateExtensions.set("AuthorityKeyIdentifier", new AuthorityKeyIdentifierExtension(new KeyIdentifier(signerPublicKey), null, null));
            SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(new KeyIdentifier(publicKeyToSign).getIdentifier());
            certificateExtensions.set("SubjectKeyIdentifier", subjectKeyIdentifierExtension);
        }
        if (generalNames != null && !generalNames.isEmpty()) {
            sun.security.x509.SubjectAlternativeNameExtension sanExtension = new sun.security.x509.SubjectAlternativeNameExtension((Boolean)sanCritical, generalNames);
            certificateExtensions.set("SubjectAlternativeName", sanExtension);
        }
        info.set("extensions", certificateExtensions);
        X509CertImpl dummyCert = new X509CertImpl(info);
        dummyCert.sign(signerPrivateKey, algorithm);
        info.set("algorithmID.algorithm", dummyCert.get("x509.algorithm"));
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(signerPrivateKey, algorithm);
        return cert;
    }

    public static boolean csrMatchesCert(Certificate crt, String csrStr) {
        try {
            if (csrStr != null && crt != null) {
                byte[] bareCSR = CertificateSerializationHelper.stripCertificateDelimiters(csrStr.getBytes());
                PKCS10 csr = new PKCS10(Base64.getMimeDecoder().decode(bareCSR));
                return Arrays.equals(crt.getPublicKey().getEncoded(), csr.getSubjectPublicKeyInfo().getEncoded());
            }
        }
        catch (Exception e) {
            RTLogger.print(4, "Error comparing public keys", e);
        }
        return false;
    }
}

