/*
 * Decompiled with CFR 0.152.
 */
package com.boom.crt.hlp;

import com.boom.crt.GeneralNameParsingException;
import com.boom.crt.hlp.SubjectAlternativeNameExtension;
import java.io.IOException;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.RFC822Name;
import sun.security.x509.URIName;

public class SubjectAlternativeNameEntry {
    private SubjectAlternativeNameExtension type;
    private String value;

    public SubjectAlternativeNameEntry(SubjectAlternativeNameExtension type, String value) {
        this.type = type;
        this.value = value;
    }

    public SubjectAlternativeNameExtension getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public GeneralName toGeneralName() throws GeneralNameParsingException, IOException {
        GeneralName result;
        switch (this.type) {
            case EMAIL: {
                result = new GeneralName(new RFC822Name(this.value));
                break;
            }
            case URI: {
                result = new GeneralName(new URIName(this.value));
                break;
            }
            case DNS: {
                result = new GeneralName(new DNSName(this.value));
                break;
            }
            case IP: {
                result = new GeneralName(new IPAddressName(this.value));
                break;
            }
            case OID: {
                result = new GeneralName(new OIDName(this.value));
                break;
            }
            default: {
                throw new GeneralNameParsingException("Could not process name san name " + this.value + " Type " + (Object)((Object)this.type) + " not supported");
            }
        }
        return result;
    }

    public String toString() {
        return (Object)((Object)this.type) + ": " + this.value;
    }
}

