/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.client;

import com.boom.netty.client.ClientConfiguration;
import com.boom.netty.client.ClientConfigurationException;
import com.boom.netty.common.ChannelUtils;
import com.boom.netty.common.DeviceConnectivityListener;
import com.boom.netty.common.MessageSender;
import com.boom.netty.service.basic.msg.BasicMessageTypes;
import com.boom.netty.service.basic.msg.HelloMsg;
import com.boom.netty.service.basic.msg.MessageProcessingFailedMsg;
import com.boom.netty.service.basic.msg.PingMsg;
import com.boom.netty.service.util.PingPongMessageHandler;
import com.boom.netty.service.util.msg.TraceRouteMsg;
import com.boom.netty.ws.client.WebSocketClient;
import com.boom.netty.ws.common.NettyChannelStateListener;
import com.boom.netty.ws.mhf.MessageTypeHandler;
import com.boom.netty.ws.mhf.MessageTypeRegistrationException;
import com.boom.netty.ws.mhf.MessageTypesRepository;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import com.boom.netty.ws.mhf.msg.MessageBase;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
implements NettyChannelStateListener,
MessageSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(Client.class);
    private List<DeviceConnectivityListener> deviceConnectivityListeners = new ArrayList<DeviceConnectivityListener>();
    private boolean isMaster = false;
    private String deviceId;
    private String serverId;
    private WebSocketClient webSocketClient;
    private MessageTypeHandler messageConsumer;
    private ExecutorService asynchronousMessageSendQueue;
    private String logTag;

    public Client(String deviceId, List<String> addresses, int port, int connectTimeoutMs, boolean allowUntrustedCertificates, KeyStore trustStore) throws ClientConfigurationException {
        this(deviceId, addresses, port, connectTimeoutMs, allowUntrustedCertificates, true, trustStore, null, 100, false);
    }

    public Client(ClientConfiguration conf) throws ClientConfigurationException {
        this(conf.getDeviceId(), conf.getAddresses(), conf.getPort(), conf.getConnectTimeoutMs(), conf.isAllowUntrustedCertificates(), conf.isUseWss(), conf.getTrustStore(), conf.getKeyManagerFactory(), conf.getMaxSendQueueSize(), conf.isMaster());
    }

    public Client(String deviceId, List<String> addresses, int port, int connectTimeoutMs, boolean allowUntrustedCertificates, boolean useWss, KeyStore trustStore, KeyManagerFactory keyManagerFactory, int maxSendQueueSize, boolean isMaster) throws ClientConfigurationException {
        this(deviceId, addresses, port, connectTimeoutMs, allowUntrustedCertificates, useWss, trustStore, keyManagerFactory, new NioEventLoopGroup(1), maxSendQueueSize, isMaster);
    }

    public Client(String deviceId, List<String> addresses, int port, int connectTimeoutMs, boolean allowUntrustedCertificates, boolean useWss, KeyStore trustStore, KeyManagerFactory keyManagerFactory, EventLoopGroup eventLoopGroup, int maxSendQueueSize, boolean isMaster) throws ClientConfigurationException {
        if (addresses == null || addresses.isEmpty()) {
            throw new ClientConfigurationException("Undefined target addresses");
        }
        this.logTag = "ClientId: " + deviceId;
        this.deviceId = deviceId;
        this.isMaster = isMaster;
        this.messageConsumer = new MessageTypeHandler(this.logTag);
        this.webSocketClient = new WebSocketClient(addresses, port, connectTimeoutMs, "central", StandardCharsets.UTF_8, allowUntrustedCertificates, useWss, trustStore, keyManagerFactory, eventLoopGroup, "CHANNEL_ENDPOINT", this.messageConsumer, this.logTag);
        this.webSocketClient.addNettyChannelStateListener(this);
        try {
            MessageTypesRepository.getInstance().registerMessageTypes(BasicMessageTypes.BASIC_MESSAGE_TYPES);
        }
        catch (MessageTypeRegistrationException e) {
            throw new RuntimeException("Could not register basic message types", e);
        }
        this.messageConsumer.registerHandler(this);
        this.messageConsumer.registerHandler(new PingPongMessageHandler(deviceId, this));
        if (maxSendQueueSize > 0) {
            this.asynchronousMessageSendQueue = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxSendQueueSize));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::onShutDown));
    }

    public void shutdown() {
        this.onShutDown();
    }

    private void onShutDown() {
        if (this.asynchronousMessageSendQueue != null) {
            this.asynchronousMessageSendQueue.shutdown();
        }
        this.webSocketClient.shutDown(true);
        LOGGER.info("shutdown: {}", (Object)this);
    }

    public void start() {
        this.webSocketClient.connect();
    }

    public void stop() {
        if (this.webSocketClient.getChannel() != null) {
            LOGGER.debug("Closing connection channel for : {}", (Object)this.webSocketClient.getChannel());
            this.webSocketClient.getChannel().close();
        }
    }

    @Override
    public void registerMessageTypes(Map<Integer, Class<?>> messageTypeIdToClassMap) throws MessageTypeRegistrationException {
        MessageTypesRepository.getInstance().registerMessageTypes(messageTypeIdToClassMap);
    }

    @Override
    public void registerHandler(Object handler) {
        this.messageConsumer.registerHandler(handler);
    }

    public void registerConsumers(MessageTypeHandler handler) {
        this.messageConsumer.registerConsumers(handler);
    }

    @Override
    public void channelActive(Channel channel) {
        LOGGER.debug("Channel active {}", (Object)channel);
        this.webSocketClient.sendMessage(new HelloMsg(this.deviceId).setMaster(this.isMaster));
    }

    @Override
    public void channelClosed(Channel channel) {
        LOGGER.debug("Channel closed {}", (Object)channel);
        this.deviceConnectivityListeners.forEach(l -> l.deviceDisconnected(this.serverId));
    }

    @MessageHandlerMethod
    public void handleHelloMessage(HelloMsg helloMsg, Channel channel) {
        this.serverId = helloMsg.getSource();
        LOGGER.debug("Received HelloMsg from {}", (Object)this.serverId);
        this.deviceConnectivityListeners.forEach(l -> l.deviceConnected(this.serverId, ChannelUtils.getPeerCertificates(channel)));
    }

    @Override
    public Optional<ChannelFuture> sendMessageNow(MessageBase messageBase) {
        Optional<ChannelFuture> channelFuture;
        if (messageBase.getSource() == null) {
            messageBase.setSource(this.deviceId);
        }
        if ((channelFuture = this.webSocketClient.sendMessage(messageBase)).isPresent()) {
            channelFuture.get().addListener(future -> {
                if (future.isCancelled() || future.isDone() && !future.isSuccess()) {
                    try {
                        if (future.isDone() && future.get() instanceof Exception) {
                            LOGGER.warn("{} | Could not send message {}. Sending MessageProcessingFailedMsg back for {} {}", this.logTag, messageBase.getTarget(), messageBase, future.get());
                        } else {
                            LOGGER.warn("{} | Could not send message {}. Sending MessageProcessingFailedMsg back for {}", this.logTag, messageBase.getTarget(), messageBase);
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (ExecutionException e) {
                        LOGGER.warn("{} | Could not send message {} to {}. Ex: {} ", this.logTag, messageBase.getTarget(), messageBase, e.getMessage());
                    }
                    MessageProcessingFailedMsg msg = new MessageProcessingFailedMsg(messageBase.getSource(), messageBase.getOperationId(), 2, "Send failed from " + this.deviceId + " to " + messageBase.getTarget(), messageBase.toString());
                    msg.setSource(this.deviceId);
                    this.messageConsumer.handle(msg, null);
                }
            });
        }
        return channelFuture;
    }

    @Override
    public void sendMessage(MessageBase messageBase) {
        if (this.asynchronousMessageSendQueue == null) {
            this.sendMessageNow(messageBase);
        } else {
            this.asynchronousMessageSendQueue.execute(() -> this.sendMessageNow(messageBase));
        }
    }

    @Override
    public Optional<ChannelFuture> sendMessageServerNow(MessageBase message) {
        return this.sendMessageNow(message);
    }

    @Override
    public void sendMessageServer(MessageBase message) {
        this.sendMessage(message);
    }

    @Override
    public void executeInDeviceWorkerThread(String deviceId, Runnable runnable) {
        this.webSocketClient.getChannel().eventLoop().schedule(runnable, 0L, TimeUnit.SECONDS);
    }

    @Override
    public void sendTraceMessage(String deviceId, String operationId) {
        TraceRouteMsg traceMsg = new TraceRouteMsg(deviceId, operationId);
        traceMsg.addHop(this.deviceId);
        this.sendMessage(traceMsg);
    }

    @Override
    public void sendPingMessage(String deviceId, String operationId) {
        PingMsg message = new PingMsg(deviceId, operationId);
        message.setPingInitiatedTimestamp(System.currentTimeMillis());
        this.sendMessageNow(message);
    }

    public void addNettyChannelStateListener(NettyChannelStateListener listener) {
        this.webSocketClient.addNettyChannelStateListener(listener);
    }

    public void removeNettyChannelStateListener(NettyChannelStateListener listener) {
        this.webSocketClient.removeNettyChannelStateListener(listener);
    }

    public void addDeviceConnectivityListener(DeviceConnectivityListener listener) {
        this.deviceConnectivityListeners.add(listener);
    }

    public void removeDeviceConnectivityListener(DeviceConnectivityListener listener) {
        this.deviceConnectivityListeners.remove(listener);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getAddress() {
        return this.webSocketClient.getAddress();
    }

    public int getPort() {
        return this.webSocketClient.getPort();
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean master) {
        this.isMaster = master;
    }

    @Override
    public String getCurrentDeviceId() {
        return this.getDeviceId();
    }

    public String toString() {
        return "Client{clientId='" + this.deviceId + '\'' + ", remote serverId='" + this.serverId + '\'' + '}';
    }
}

