/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.common;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelUtils.class);
    private static CertificateFactory certificateFactory = null;

    private ChannelUtils() {
    }

    public static Certificate[] getPeerCertificates(Channel channel) {
        X509Certificate[] certificates;
        block4: {
            certificates = new X509Certificate[]{};
            try {
                ChannelHandler channelHandler = channel.pipeline().get("ssl");
                if (!(channelHandler instanceof SslHandler)) break block4;
                SslHandler sslHandler = (SslHandler)channelHandler;
                try {
                    certificates = sslHandler.engine().getSession().getPeerCertificateChain();
                }
                catch (UnsupportedOperationException e) {
                    return sslHandler.engine().getSession().getPeerCertificates();
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return ChannelUtils.convertCertificates(certificates);
    }

    private static Certificate[] convertCertificates(X509Certificate[] x509Certificates) {
        Certificate[] result = new Certificate[x509Certificates.length];
        if (certificateFactory == null) {
            result = new Certificate[]{};
        } else {
            for (int i = 0; i < x509Certificates.length; ++i) {
                try (ByteArrayInputStream is = new ByteArrayInputStream(x509Certificates[i].getEncoded());){
                    result[i] = certificateFactory.generateCertificate(is);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Could not convert certificate. index {}", (Object)i, (Object)e);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Corresponding certificates:");
                        for (int j = 0; j < x509Certificates.length; ++j) {
                            LOGGER.debug("cert[{}]: {}", (Object)j, (Object)x509Certificates[j]);
                        }
                    }
                    result = new Certificate[]{};
                }
            }
        }
        return result;
    }

    static {
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            LOGGER.warn("Could not get instance of the certificate factory ", e);
        }
    }
}

