/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.digest;

import com.boom.netty.digest.GeneralDigest;
import com.boom.netty.digest.HashFile;
import com.boom.netty.digest.SHA256Digest;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class DigestManager {
    private static Gson gson = new Gson();

    private DigestManager() {
    }

    public static GeneralDigest getDigest(String algorithm) {
        switch (algorithm) {
            default: 
        }
        return new SHA256Digest();
    }

    public static String readHashFormFile(String filePath) {
        File hashFile = new File(filePath);
        String loadedHash = "";
        if (hashFile.exists()) {
            try (FileInputStream fileStream = new FileInputStream(hashFile);){
                byte[] data = new byte[(int)hashFile.length()];
                fileStream.read(data);
                loadedHash = new String(data, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                return loadedHash;
            }
        }
        return loadedHash;
    }

    public static GeneralDigest loadDigestFromFile(File file) throws IOException {
        String loadedHashFile = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        HashFile hf = gson.fromJson(loadedHashFile, HashFile.class);
        if (hf != null && hf.hashContent != null) {
            return gson.fromJson(hf.hashContent, SHA256Digest.class);
        }
        return null;
    }
}

